/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.servicescommon.coordination;

import com.fasterxml.jackson.databind.JavaType;
import com.spotify.helios.servicescommon.coordination.Node;
import com.spotify.helios.servicescommon.coordination.PersistentPathChildrenCache;
import com.spotify.helios.servicescommon.coordination.ZooKeeperClient;
import com.spotify.helios.servicescommon.coordination.ZooKeeperModelReporter;
import com.spotify.helios.servicescommon.coordination.ZooKeeperOperation;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.transaction.CuratorTransactionResult;
import org.apache.curator.framework.listen.Listenable;
import org.apache.curator.framework.recipes.nodes.PersistentEphemeralNode;
import org.apache.curator.framework.state.ConnectionStateListener;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;

public class ReportingZooKeeperClient
implements ZooKeeperClient {
    private final ZooKeeperClient client;
    private final String tag;
    private final ZooKeeperModelReporter reporter;

    public ReportingZooKeeperClient(ZooKeeperClient client, ZooKeeperModelReporter reporter, String tag) {
        this.client = client;
        this.tag = tag;
        this.reporter = reporter;
    }

    @Override
    public void ensurePath(String path) throws KeeperException {
        this.reporter.time(this.tag, "ensurePath", () -> {
            this.client.ensurePath(path);
            return null;
        });
    }

    @Override
    public void ensurePath(String path, boolean excludingLast) throws KeeperException {
        this.reporter.time(this.tag, "ensurePath", () -> {
            this.client.ensurePath(path, excludingLast);
            return null;
        });
    }

    @Override
    public void ensurePathAndSetData(String path, byte[] data) throws KeeperException {
        this.reporter.time(this.tag, "ensurePathAndSetData", () -> {
            this.client.ensurePathAndSetData(path, data);
            return null;
        });
    }

    @Override
    public byte[] getData(String path) throws KeeperException {
        return this.reporter.time(this.tag, "getData", () -> this.client.getData(path));
    }

    @Override
    public List<String> getChildren(String path) throws KeeperException {
        return this.reporter.time(this.tag, "getChildren", () -> this.client.getChildren(path));
    }

    @Override
    public void delete(String path) throws KeeperException {
        this.reporter.time(this.tag, "delete", () -> {
            this.client.delete(path);
            return null;
        });
    }

    @Override
    public void setData(String path, byte[] bytes) throws KeeperException {
        this.reporter.time(this.tag, "setData", () -> {
            this.client.setData(path, bytes);
            return null;
        });
    }

    @Override
    public void createAndSetData(String path, byte[] data) throws KeeperException {
        this.reporter.time(this.tag, "createAndSetData", () -> {
            this.client.createAndSetData(path, data);
            return null;
        });
    }

    @Override
    public void createWithMode(String path, CreateMode mode) throws KeeperException {
        this.reporter.time(this.tag, "createWithMode", () -> {
            this.client.createWithMode(path, mode);
            return null;
        });
    }

    @Override
    public Stat stat(String path) throws KeeperException {
        return this.reporter.time(this.tag, "stat", () -> this.client.stat(path));
    }

    @Override
    public void deleteRecursive(String path) throws KeeperException {
        this.reporter.time(this.tag, "deleteRecursive", () -> {
            this.client.deleteRecursive(path);
            return null;
        });
    }

    @Override
    public List<String> listRecursive(String path) throws KeeperException {
        return this.reporter.time(this.tag, "listRecursive", () -> this.client.listRecursive(path));
    }

    @Override
    public void create(String path) throws KeeperException {
        this.reporter.time(this.tag, "create", () -> {
            this.client.create(path);
            return null;
        });
    }

    @Override
    public <T> PersistentPathChildrenCache<T> pathChildrenCache(String path, Path snapshotFile, JavaType valueType) throws IOException, InterruptedException {
        return this.client.pathChildrenCache(path, snapshotFile, valueType);
    }

    @Override
    public Collection<CuratorTransactionResult> transaction(List<ZooKeeperOperation> operations) throws KeeperException {
        return this.reporter.time(this.tag, "transaction", () -> this.client.transaction(operations));
    }

    @Override
    public Collection<CuratorTransactionResult> transaction(ZooKeeperOperation ... operations) throws KeeperException {
        return this.reporter.time(this.tag, "transaction", () -> this.client.transaction(operations));
    }

    @Override
    public void delete(String path, int version) throws KeeperException {
        this.reporter.time(this.tag, "delete", () -> {
            this.client.delete(path, version);
            return null;
        });
    }

    @Override
    public Node getNode(String path) throws KeeperException {
        return this.reporter.time(this.tag, "getNode", () -> this.client.getNode(path));
    }

    @Override
    public Stat exists(String path) throws KeeperException {
        return this.reporter.time(this.tag, "exists", () -> this.client.exists(path));
    }

    @Override
    public Listenable<ConnectionStateListener> getConnectionStateListenable() {
        return this.client.getConnectionStateListenable();
    }

    @Override
    public ZooKeeper.States getState() throws KeeperException {
        return this.reporter.time(this.tag, "getState", this.client::getState);
    }

    @Override
    public PersistentEphemeralNode persistentEphemeralNode(String path, PersistentEphemeralNode.Mode mode, byte[] data) {
        return this.client.persistentEphemeralNode(path, mode, data);
    }

    @Override
    public void start() {
        this.client.start();
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public CuratorFramework getCuratorFramework() {
        return this.client.getCuratorFramework();
    }

    @Override
    public void setAcl(String path, List<ACL> aclList) throws KeeperException {
        this.reporter.time(this.tag, "setAcl", () -> {
            this.client.setAcl(path, aclList);
            return null;
        });
    }

    @Override
    public List<ACL> getAcl(String path) throws KeeperException {
        return this.reporter.time(this.tag, "getAcl", () -> this.client.getAcl(path));
    }
}

