/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.servicescommon.coordination;

import com.codahale.metrics.Clock;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.spotify.helios.servicescommon.NoOpRiemannClient;
import com.spotify.helios.servicescommon.RiemannFacade;
import com.spotify.helios.servicescommon.statistics.NoopZooKeeperMetrics;
import com.spotify.helios.servicescommon.statistics.ZooKeeperMetrics;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.zookeeper.KeeperException;

public class ZooKeeperModelReporter {
    private final RiemannFacade riemannFacade;
    private final ZooKeeperMetrics metrics;
    private final ImmutableMap<Class<?>, String> exceptionMap = ImmutableMap.of(KeeperException.OperationTimeoutException.class, (Object)"timeout", KeeperException.ConnectionLossException.class, (Object)"connection_loss", KeeperException.RuntimeInconsistencyException.class, (Object)"inconsistency");
    private final Clock clock = Clock.defaultClock();

    public ZooKeeperModelReporter(RiemannFacade riemannFacade, ZooKeeperMetrics metrics) {
        this.metrics = (ZooKeeperMetrics)Preconditions.checkNotNull((Object)metrics);
        this.riemannFacade = ((RiemannFacade)Preconditions.checkNotNull((Object)riemannFacade)).stack("zookeeper");
    }

    public void checkException(Exception e, String ... tags) {
        Throwable t;
        for (t = e; t != null && !(t instanceof KeeperException); t = t.getCause()) {
        }
        if (t == null) {
            return;
        }
        KeeperException k = (KeeperException)t;
        String message = (String)this.exceptionMap.get(((Object)((Object)k)).getClass());
        if (message == null) {
            return;
        }
        ArrayList tagList = Lists.newArrayList((Object[])new String[]{"zookeeper", "error", message});
        tagList.addAll(Lists.newArrayList((Object[])tags));
        this.riemannFacade.event().tags((List)tagList).send();
        this.metrics.zookeeperTransientError();
    }

    public <T> T time(String tag, String name, ZooKeeperCallable<T> callable) throws KeeperException {
        long startTime = this.clock.getTick();
        try {
            T t = callable.call();
            return t;
        }
        catch (KeeperException e) {
            this.checkException((Exception)((Object)e), tag, name);
            throw e;
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
        finally {
            this.metrics.updateTimer(name, this.clock.getTick() - startTime, TimeUnit.NANOSECONDS);
        }
    }

    public static ZooKeeperModelReporter noop() {
        return new ZooKeeperModelReporter(new NoOpRiemannClient().facade(), new NoopZooKeeperMetrics());
    }

    @FunctionalInterface
    public static interface ZooKeeperCallable<T> {
        public T call() throws KeeperException;
    }
}

