/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.servicescommon.coordination;

import com.spotify.helios.servicescommon.coordination.NodeUpdater;
import com.spotify.helios.servicescommon.coordination.ZooKeeperClient;
import org.apache.curator.utils.ZKPaths;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperNodeUpdater
implements NodeUpdater {
    private static final Logger log = LoggerFactory.getLogger(ZooKeeperNodeUpdater.class);
    private final ZooKeeperClient zooKeeperClient;
    private final String path;

    public ZooKeeperNodeUpdater(String path, ZooKeeperClient zooKeeperClient) {
        this.zooKeeperClient = zooKeeperClient;
        this.path = path;
    }

    @Override
    public boolean update(byte[] bytes) {
        String parent = ZKPaths.getPathAndNode((String)this.path).getPath();
        try {
            if (this.zooKeeperClient.stat(parent) == null) {
                return false;
            }
            if (this.zooKeeperClient.stat(this.path) == null) {
                this.zooKeeperClient.createAndSetData(this.path, bytes);
            } else {
                this.zooKeeperClient.setData(this.path, bytes);
            }
            return true;
        }
        catch (KeeperException.NodeExistsException ignore) {
            return true;
        }
        catch (KeeperException.ConnectionLossException e) {
            log.warn("ZooKeeper connection lost while updating node: {}", (Object)this.path);
            return false;
        }
        catch (KeeperException e) {
            log.error("failed to update node: {}", (Object)this.path, (Object)e);
            return false;
        }
    }
}

