/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.servicescommon.coordination;

import com.spotify.helios.common.descriptors.Descriptor;
import com.spotify.helios.servicescommon.coordination.Check;
import com.spotify.helios.servicescommon.coordination.CheckWithVersion;
import com.spotify.helios.servicescommon.coordination.CreateEmpty;
import com.spotify.helios.servicescommon.coordination.CreateMany;
import com.spotify.helios.servicescommon.coordination.CreateWithData;
import com.spotify.helios.servicescommon.coordination.CreateWithDataAndVersion;
import com.spotify.helios.servicescommon.coordination.Delete;
import com.spotify.helios.servicescommon.coordination.DeleteMany;
import com.spotify.helios.servicescommon.coordination.Node;
import com.spotify.helios.servicescommon.coordination.SetData;
import com.spotify.helios.servicescommon.coordination.ZooKeeperOperation;
import java.util.List;
import java.util.Map;

public class ZooKeeperOperations {
    public static ZooKeeperOperation set(String path, Descriptor data) {
        return new SetData(path, data.toJsonBytes());
    }

    public static ZooKeeperOperation set(String path, byte[] bytes) {
        return new SetData(path, bytes);
    }

    public static ZooKeeperOperation check(String path, int version) {
        return new CheckWithVersion(path, version);
    }

    public static ZooKeeperOperation check(String path) {
        return new Check(path);
    }

    public static ZooKeeperOperation check(Node node) {
        return new CheckWithVersion(node.getPath(), node.getStat().getVersion());
    }

    public static ZooKeeperOperation create(Map<String, byte[]> nodes) {
        return new CreateMany(nodes);
    }

    public static ZooKeeperOperation create(String path) {
        return new CreateEmpty(path);
    }

    public static ZooKeeperOperation create(String path, Descriptor data) {
        return ZooKeeperOperations.create(path, data.toJsonBytes());
    }

    public static ZooKeeperOperation create(String path, Descriptor data, int version) {
        return ZooKeeperOperations.create(path, data.toJsonBytes(), version);
    }

    public static ZooKeeperOperation create(String path, byte[] bytes, int version) {
        return new CreateWithDataAndVersion(path, bytes, version);
    }

    public static ZooKeeperOperation create(String path, byte[] bytes) {
        return new CreateWithData(path, bytes);
    }

    public static ZooKeeperOperation delete(String path) {
        return new Delete(path);
    }

    public static ZooKeeperOperation delete(List<String> paths) {
        return new DeleteMany(paths);
    }
}

