/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.servicescommon.coordination;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Equivalence;
import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.AbstractIdleService;
import com.google.common.util.concurrent.Service;
import com.spotify.helios.agent.BoundedRandomExponentialBackoff;
import com.spotify.helios.agent.RetryScheduler;
import com.spotify.helios.servicescommon.DefaultReactor;
import com.spotify.helios.servicescommon.PersistentAtomicReference;
import com.spotify.helios.servicescommon.Reactor;
import com.spotify.helios.servicescommon.coordination.ZooKeeperClient;
import com.spotify.helios.servicescommon.coordination.ZooKeeperClientProvider;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.state.ConnectionState;
import org.apache.curator.framework.state.ConnectionStateListener;
import org.apache.curator.utils.ZKPaths;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.common.PathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperUpdatingPersistentDirectory
extends AbstractIdleService {
    private static final Logger log = LoggerFactory.getLogger(ZooKeeperUpdatingPersistentDirectory.class);
    private static final long RETRY_INTERVAL_MILLIS = 5000L;
    private static final Map<String, byte[]> EMPTY_ENTRIES = Collections.emptyMap();
    private static final TypeReference<Map<String, byte[]>> ENTRIES_TYPE = new TypeReference<Map<String, byte[]>>(){};
    private static final Equivalence<? super byte[]> BYTE_ARRAY_EQUIVALENCE = new Equivalence<byte[]>(){

        protected boolean doEquivalent(byte[] a, byte[] b) {
            return Arrays.equals(a, b);
        }

        protected int doHash(byte[] bytes) {
            return Arrays.hashCode(bytes);
        }
    };
    private final ZooKeeperClientProvider provider;
    private final String path;
    private final Reactor reactor;
    private final PersistentAtomicReference<Map<String, byte[]>> entries;
    private final Object lock = new Object(){};
    private Map<String, byte[]> remote = Maps.newHashMap();
    private volatile boolean initialized;
    private final ConnectionStateListener connectionStateListener = new ConnectionStateListener(){

        public void stateChanged(CuratorFramework client, ConnectionState newState) {
            switch (newState) {
                case CONNECTED: {
                    break;
                }
                case SUSPENDED: {
                    break;
                }
                case RECONNECTED: {
                    ZooKeeperUpdatingPersistentDirectory.this.initialized = false;
                    ZooKeeperUpdatingPersistentDirectory.this.reactor.signal();
                    break;
                }
                case LOST: {
                    break;
                }
            }
        }
    };

    private ZooKeeperUpdatingPersistentDirectory(String name, ZooKeeperClientProvider provider, Path stateFile, String path) throws IOException, InterruptedException {
        this.provider = provider;
        this.path = path;
        this.entries = PersistentAtomicReference.create(stateFile, ENTRIES_TYPE, Suppliers.ofInstance(EMPTY_ENTRIES));
        this.reactor = new DefaultReactor(name, new Update(), 5000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] put(String key, byte[] value) throws InterruptedException {
        byte[] prev;
        Preconditions.checkArgument((key.indexOf(47) == -1 ? 1 : 0) != 0);
        PathUtils.validatePath((String)ZKPaths.makePath((String)this.path, (String)key));
        Object object = this.lock;
        synchronized (object) {
            HashMap mutable = Maps.newHashMap(this.entries.get());
            prev = mutable.put(key, value);
            try {
                this.entries.set((Map<String, byte[]>)ImmutableMap.copyOf((Map)mutable));
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
        this.reactor.signal();
        return prev;
    }

    public byte[] remove(Object key) throws InterruptedException {
        if (!(key instanceof String)) {
            return null;
        }
        return this.remove((String)key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] remove(String key) throws InterruptedException {
        byte[] value;
        Preconditions.checkArgument((key.indexOf(47) == -1 ? 1 : 0) != 0);
        PathUtils.validatePath((String)ZKPaths.makePath((String)this.path, (String)key));
        Object object = this.lock;
        synchronized (object) {
            HashMap mutable = Maps.newHashMap(this.entries.get());
            value = (byte[])mutable.remove(key);
            try {
                this.entries.set((Map<String, byte[]>)ImmutableMap.copyOf((Map)mutable));
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
        this.reactor.signal();
        return value;
    }

    public byte[] get(Object key) {
        return this.entries.get().get(key);
    }

    public Set<Map.Entry<String, byte[]>> entrySet() {
        return this.entries.get().entrySet();
    }

    private ZooKeeperClient client(String tag) {
        return this.provider.get("persistent_directory_" + tag);
    }

    protected void startUp() throws Exception {
        this.client("startUp").getConnectionStateListenable().addListener((Object)this.connectionStateListener);
        this.reactor.startAsync().awaitRunning();
        this.reactor.signal();
    }

    protected void shutDown() throws Exception {
        this.reactor.stopAsync().awaitTerminated();
    }

    public static ZooKeeperUpdatingPersistentDirectory create(String name, ZooKeeperClientProvider client, Path stateFile, String path) throws IOException, InterruptedException {
        return new ZooKeeperUpdatingPersistentDirectory(name, client, stateFile, path);
    }

    private class Update
    implements Reactor.Callback {
        private Update() {
        }

        @Override
        public void run(boolean timeout) throws InterruptedException {
            RetryScheduler retryScheduler = BoundedRandomExponentialBackoff.newBuilder().setMinInterval(1L, TimeUnit.SECONDS).setMaxInterval(30L, TimeUnit.SECONDS).build().newScheduler();
            while (this.isAlive()) {
                try {
                    if (!this.parentExists()) {
                        log.warn("parent does not exist: {}", (Object)ZooKeeperUpdatingPersistentDirectory.this.path);
                        return;
                    }
                    if (!ZooKeeperUpdatingPersistentDirectory.this.initialized) {
                        this.syncChecked();
                        ZooKeeperUpdatingPersistentDirectory.this.initialized = true;
                    }
                    this.incrementalUpdate();
                    return;
                }
                catch (KeeperException e) {
                    long backoff = retryScheduler.nextMillis();
                    ZooKeeperUpdatingPersistentDirectory.this.initialized = false;
                    if (e instanceof KeeperException.ConnectionLossException) {
                        log.warn("Connection lost. Resyncing in {}ms", (Object)backoff);
                    } else if (e instanceof KeeperException.NodeExistsException || e instanceof KeeperException.NoNodeException) {
                        log.warn("Conflict: {} {}. Resyncing in {}ms", new Object[]{e.getPath(), e.code(), backoff});
                    } else {
                        log.error("Error: Resyncing in {}ms", new Object[]{e.getPath(), e.code(), backoff, e});
                    }
                    Thread.sleep(backoff);
                }
            }
        }

        private boolean isAlive() {
            return ZooKeeperUpdatingPersistentDirectory.this.state().ordinal() < Service.State.STOPPING.ordinal();
        }

        private void incrementalUpdate() throws KeeperException {
            MapDifference difference = Maps.difference((Map)((Map)ZooKeeperUpdatingPersistentDirectory.this.entries.get()), (Map)ZooKeeperUpdatingPersistentDirectory.this.remote, (Equivalence)BYTE_ARRAY_EQUIVALENCE);
            if (difference.areEqual()) {
                return;
            }
            HashMap newRemote = Maps.newHashMap((Map)ZooKeeperUpdatingPersistentDirectory.this.remote);
            Map create = difference.entriesOnlyOnLeft();
            Map update = difference.entriesDiffering();
            Map delete = difference.entriesOnlyOnRight();
            log.debug("create: {}", create.keySet());
            log.debug("update: {}", update.keySet());
            log.debug("delete: {}", delete.keySet());
            for (Map.Entry entry : create.entrySet()) {
                this.write((String)entry.getKey(), (byte[])entry.getValue());
                newRemote.put(entry.getKey(), entry.getValue());
            }
            for (Map.Entry entry : update.entrySet()) {
                this.write((String)entry.getKey(), (byte[])((MapDifference.ValueDifference)entry.getValue()).leftValue());
                newRemote.put(entry.getKey(), ((MapDifference.ValueDifference)entry.getValue()).leftValue());
            }
            for (Map.Entry entry : delete.entrySet()) {
                this.delete((String)entry.getKey());
                newRemote.remove(entry.getKey());
            }
            ZooKeeperUpdatingPersistentDirectory.this.remote = newRemote;
        }

        private boolean parentExists() throws KeeperException {
            return ZooKeeperUpdatingPersistentDirectory.this.client("parentExists").exists(ZooKeeperUpdatingPersistentDirectory.this.path) != null;
        }

        private void delete(String node) throws KeeperException {
            String nodePath;
            ZooKeeperClient client = ZooKeeperUpdatingPersistentDirectory.this.client("delete");
            if (client.stat(nodePath = ZKPaths.makePath((String)ZooKeeperUpdatingPersistentDirectory.this.path, (String)node)) != null) {
                log.debug("deleting node: {}", (Object)nodePath);
                client.delete(nodePath);
            }
        }

        private void write(String node, byte[] data) throws KeeperException {
            String nodePath;
            ZooKeeperClient client = ZooKeeperUpdatingPersistentDirectory.this.client("write");
            if (client.stat(nodePath = ZKPaths.makePath((String)ZooKeeperUpdatingPersistentDirectory.this.path, (String)node)) != null) {
                log.debug("setting node: {}", (Object)nodePath);
                client.setData(nodePath, data);
            } else {
                log.debug("creating node: {}", (Object)nodePath);
                client.createAndSetData(nodePath, data);
            }
        }

        private void syncChecked() throws KeeperException {
            ZooKeeperClient client = ZooKeeperUpdatingPersistentDirectory.this.client("sync");
            List<String> nodes = client.getChildren(ZooKeeperUpdatingPersistentDirectory.this.path);
            Map snapshot = (Map)ZooKeeperUpdatingPersistentDirectory.this.entries.get();
            ZooKeeperUpdatingPersistentDirectory.this.remote = Maps.newHashMap();
            for (String string : nodes) {
                String nodePath = ZKPaths.makePath((String)ZooKeeperUpdatingPersistentDirectory.this.path, (String)string);
                byte[] data = client.getData(nodePath);
                ZooKeeperUpdatingPersistentDirectory.this.remote.put(string, data);
            }
            for (Map.Entry entry : snapshot.entrySet()) {
                String node = (String)entry.getKey();
                byte[] remoteData = (byte[])ZooKeeperUpdatingPersistentDirectory.this.remote.get(node);
                byte[] localData = (byte[])entry.getValue();
                String nodePath = ZKPaths.makePath((String)ZooKeeperUpdatingPersistentDirectory.this.path, (String)node);
                if (remoteData == null) {
                    log.debug("sync: creating node {}", (Object)nodePath);
                    client.createAndSetData(nodePath, localData);
                    ZooKeeperUpdatingPersistentDirectory.this.remote.put(node, localData);
                    continue;
                }
                if (Arrays.equals(remoteData, localData)) continue;
                log.debug("sync: updating node {}", (Object)nodePath);
                client.setData(nodePath, localData);
                ZooKeeperUpdatingPersistentDirectory.this.remote.put(node, localData);
            }
            ImmutableSet keySet = ImmutableSet.copyOf(ZooKeeperUpdatingPersistentDirectory.this.remote.keySet());
            for (String node : keySet) {
                if (snapshot.containsKey(node)) continue;
                String nodePath = ZKPaths.makePath((String)ZooKeeperUpdatingPersistentDirectory.this.path, (String)node);
                log.debug("sync: deleting node {}", (Object)nodePath);
                client.delete(nodePath);
                ZooKeeperUpdatingPersistentDirectory.this.remote.remove(node);
            }
        }
    }
}

