/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.servicescommon.statistics;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metered;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Snapshot;
import com.codahale.metrics.Timer;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.net.HostAndPort;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import eu.toolchain.ffwd.FastForward;
import eu.toolchain.ffwd.Metric;
import io.dropwizard.lifecycle.Managed;
import java.io.IOException;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FastForwardReporter
implements Managed {
    private static final Logger log = LoggerFactory.getLogger(FastForwardReporter.class);
    private final FastForward fastForward;
    private final MetricRegistry metricRegistry;
    private final ScheduledExecutorService executor;
    private final String key;
    private final long interval;
    private final TimeUnit intervalTimeUnit;
    private final Supplier<Map<String, String>> additionalAttributesSupplier;
    private Map<String, String> additionalAttributes;

    public static FastForwardReporter create(MetricRegistry registry, Optional<HostAndPort> address, String metricKey, int intervalSeconds) throws SocketException, UnknownHostException {
        return FastForwardReporter.create(registry, address, metricKey, intervalSeconds, Collections::emptyMap);
    }

    public static FastForwardReporter create(MetricRegistry registry, Optional<HostAndPort> address, String metricKey, int intervalSeconds, Supplier<Map<String, String>> additionalAttributes) throws SocketException, UnknownHostException {
        FastForward ff = address.isPresent() ? FastForward.setup((String)address.get().getHostText(), (int)address.get().getPort()) : FastForward.setup();
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("fast-forward-reporter-%d").build();
        ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor(threadFactory);
        return new FastForwardReporter(ff, registry, executorService, metricKey, intervalSeconds, TimeUnit.SECONDS, additionalAttributes);
    }

    FastForwardReporter(FastForward fastForward, MetricRegistry metricRegistry, ScheduledExecutorService executor, String key, long interval, TimeUnit intervalTimeUnit, Supplier<Map<String, String>> additionalAttributes) {
        this.fastForward = fastForward;
        this.metricRegistry = metricRegistry;
        this.executor = executor;
        this.key = key;
        this.interval = interval;
        this.intervalTimeUnit = intervalTimeUnit;
        this.additionalAttributesSupplier = additionalAttributes;
    }

    public void start() throws Exception {
        log.info("Scheduling reporting of metrics every {} {}", (Object)this.interval, (Object)this.intervalTimeUnit.name().toLowerCase());
        this.executor.scheduleAtFixedRate(() -> {
            try {
                this.reportOnce();
            }
            catch (Exception e) {
                log.error("Exception in reporting loop", (Throwable)e);
            }
        }, this.interval, this.interval, this.intervalTimeUnit);
    }

    public void stop() throws Exception {
        this.executor.shutdown();
    }

    @VisibleForTesting
    void reportOnce() {
        this.additionalAttributes = this.additionalAttributesSupplier.get();
        if (this.additionalAttributes == null) {
            this.additionalAttributes = Collections.emptyMap();
        }
        this.metricRegistry.getGauges().forEach(this::reportGauge);
        this.metricRegistry.getCounters().forEach(this::reportCounter);
        this.metricRegistry.getMeters().forEach(this::reportMeter);
        this.metricRegistry.getHistograms().forEach(this::reportHistogram);
        this.metricRegistry.getTimers().forEach(this::reportTimer);
    }

    private void reportGauge(String name, Gauge gauge) {
        Metric metric = this.createMetric(name, "gauge").value(this.convert(gauge.getValue()));
        this.send(metric);
    }

    private void reportCounter(String name, Counter counter) {
        Metric metric = this.createMetric(name, "counter").value((double)counter.getCount());
        this.send(metric);
    }

    private void reportMeter(String name, Meter meter) {
        Metric metric = this.createMetric(name, "meter").attribute("unit", "n/s");
        this.reportMetered(metric, (Metered)meter);
    }

    private void reportMetered(Metric metric, Metered metered) {
        this.send(metric.attribute("stat", "1m").value(metered.getOneMinuteRate()));
        this.send(metric.attribute("stat", "5m").value(metered.getOneMinuteRate()));
    }

    private void reportHistogram(String name, Histogram histogram) {
        Metric metric = this.createMetric(name, "histogram");
        this.reportHistogram(metric, histogram.getSnapshot());
    }

    private void reportHistogram(Metric metric, Snapshot snapshot) {
        this.send(metric.attribute("stat", "min").value((double)snapshot.getMin()));
        this.send(metric.attribute("stat", "max").value((double)snapshot.getMax()));
        this.send(metric.attribute("stat", "mean").value(snapshot.getMean()));
        this.send(metric.attribute("stat", "stddev").value(snapshot.getStdDev()));
        this.send(metric.attribute("stat", "median").value(snapshot.getMedian()));
        this.send(metric.attribute("stat", "p75").value(snapshot.get75thPercentile()));
        this.send(metric.attribute("stat", "p99").value(snapshot.get99thPercentile()));
    }

    private void reportTimer(String name, Timer timer) {
        Metric metric = this.createMetric(name, "timer").attribute("unit", "ns");
        this.reportHistogram(metric, timer.getSnapshot());
        this.reportMetered(metric, (Metered)timer);
    }

    private Metric createMetric(String metricName, String metricType) {
        return FastForward.metric((String)this.key).attributes(this.additionalAttributes).attribute("helios_version", "0.9.54").attribute("metric_type", metricType).attribute("what", metricName);
    }

    private double convert(Object value) {
        if (value instanceof Number) {
            return ((Number)Number.class.cast(value)).doubleValue();
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? 1.0 : 0.0;
        }
        return 0.0;
    }

    private void send(Metric metric) {
        try {
            this.fastForward.send(metric);
        }
        catch (IOException e) {
            log.error("Error sending metric to FastForward", (Throwable)e);
        }
    }
}

