/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.servicescommon.statistics;

import com.codahale.metrics.Histogram;
import com.codahale.metrics.MetricRegistry;
import com.google.common.collect.Maps;
import com.spotify.helios.servicescommon.MasterRequestMetrics;
import com.spotify.helios.servicescommon.statistics.MasterMetrics;
import java.util.Map;

public class MasterMetricsImpl
implements MasterMetrics {
    private static final String TYPE = "master";
    private final Map<String, MasterRequestMetrics> requestMetrics = Maps.newConcurrentMap();
    private final Histogram jobsInJobListHist;
    private final Histogram eventsInJobHistoryHist;
    private final String group;
    private final MetricRegistry registry;

    public MasterMetricsImpl(String group, MetricRegistry registry) {
        this.group = group;
        this.registry = registry;
        this.eventsInJobHistoryHist = registry.histogram(MetricRegistry.name((String)group, (String[])new String[]{"master_events_in_job_history"}));
        this.jobsInJobListHist = registry.histogram(MetricRegistry.name((String)group, (String[])new String[]{"master_jobs_in_job_list"}));
    }

    @Override
    public void success(String name) {
        this.request(name).success();
    }

    @Override
    public void failure(String name) {
        this.request(name).failure();
    }

    @Override
    public void badRequest(String name) {
        this.request(name).userError();
    }

    private MasterRequestMetrics request(String name) {
        MasterRequestMetrics m = this.requestMetrics.get(name);
        if (m == null) {
            m = new MasterRequestMetrics(this.group, TYPE, name, this.registry);
            this.requestMetrics.put(name, m);
        }
        return m;
    }

    @Override
    public void clientVersion(String version) {
        String name = MetricRegistry.name((String)this.group, (String[])new String[]{"master_meter_client_version", version});
        this.registry.meter(name).mark();
    }

    @Override
    public void jobsInJobList(int count) {
        this.jobsInJobListHist.update(count);
    }

    @Override
    public void jobsHistoryEventSize(int count) {
        this.eventsInJobHistoryHist.update(count);
    }
}

