/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.servicescommon.statistics;

import com.codahale.metrics.JmxReporter;
import com.codahale.metrics.MetricRegistry;
import com.spotify.helios.servicescommon.statistics.MasterMetrics;
import com.spotify.helios.servicescommon.statistics.MasterMetricsImpl;
import com.spotify.helios.servicescommon.statistics.Metrics;
import com.spotify.helios.servicescommon.statistics.NoopMasterMetrics;
import com.spotify.helios.servicescommon.statistics.NoopSupervisorMetrics;
import com.spotify.helios.servicescommon.statistics.SupervisorMetrics;
import com.spotify.helios.servicescommon.statistics.SupervisorMetricsImpl;
import com.spotify.helios.servicescommon.statistics.ZooKeeperMetrics;
import com.spotify.helios.servicescommon.statistics.ZooKeeperMetricsImpl;

public class MetricsImpl
implements Metrics {
    private static final String GROUP = "helios";
    private final SupervisorMetrics supervisorMetrics;
    private final MasterMetrics masterMetrics;
    private final ZooKeeperMetrics zooKeeperMetrics;
    private final JmxReporter jmxReporter;

    public MetricsImpl(MetricRegistry registry, Type type) {
        this.masterMetrics = type == Type.MASTER ? new MasterMetricsImpl(GROUP, registry) : new NoopMasterMetrics();
        this.supervisorMetrics = type == Type.AGENT ? new SupervisorMetricsImpl(GROUP, registry) : new NoopSupervisorMetrics();
        this.zooKeeperMetrics = new ZooKeeperMetricsImpl(GROUP, registry);
        this.jmxReporter = JmxReporter.forRegistry((MetricRegistry)registry).build();
    }

    @Override
    public void start() {
        this.jmxReporter.start();
    }

    @Override
    public void stop() {
        this.jmxReporter.close();
    }

    @Override
    public MasterMetrics getMasterMetrics() {
        return this.masterMetrics;
    }

    @Override
    public SupervisorMetrics getSupervisorMetrics() {
        return this.supervisorMetrics;
    }

    @Override
    public ZooKeeperMetrics getZooKeeperMetrics() {
        return this.zooKeeperMetrics;
    }

    public static enum Type {
        MASTER,
        AGENT;

    }
}

