/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.servicescommon.statistics;

import com.codahale.metrics.Counter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;

public class RequestMetrics {
    private final Counter successCounter;
    private final Counter failureCounter;
    private final Counter userErrorCounter;
    private final Timer timer;

    public RequestMetrics(String group, String type, String requestName, MetricRegistry registry) {
        String prefix = MetricRegistry.name((String)group, (String[])new String[]{type, requestName});
        this.successCounter = registry.counter(prefix + "_successful");
        this.failureCounter = registry.counter(prefix + "_failed");
        this.userErrorCounter = registry.counter(prefix + "_failed");
        this.timer = registry.timer(prefix + "_latency");
    }

    public Timer.Context begin() {
        return this.timer.time();
    }

    public void success(Timer.Context context) {
        this.success();
        context.stop();
    }

    public void success() {
        this.successCounter.inc();
    }

    public void failure(Timer.Context context) {
        this.failure();
        context.stop();
    }

    public void failure() {
        this.failureCounter.inc();
    }

    public void userError(Timer.Context context) {
        this.userError();
        context.stop();
    }

    public void userError() {
        this.userErrorCounter.inc();
    }

    public Counter getSuccessCounter() {
        return this.successCounter;
    }

    public Counter getFailureCounter() {
        return this.failureCounter;
    }

    public Counter getUserErrorCounter() {
        return this.failureCounter;
    }

    public Timer getTimer() {
        return this.timer;
    }
}

