/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.servicescommon.statistics;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.spotify.helios.servicescommon.statistics.MeterRates;
import com.spotify.helios.servicescommon.statistics.MetricsContext;
import com.spotify.helios.servicescommon.statistics.MetricsContextImpl;
import com.spotify.helios.servicescommon.statistics.RequestMetrics;
import com.spotify.helios.servicescommon.statistics.SupervisorMetrics;

public class SupervisorMetricsImpl
implements SupervisorMetrics {
    private static final String TYPE = "agent_supervisor";
    private final RequestMetrics imagePull;
    private final Counter containerStartedCounter;
    private final Counter containersExitedCounter;
    private final Counter containersRunningCounter;
    private final Counter containersThrewExceptionCounter;
    private final Counter imageCacheHitCounter;
    private final Counter supervisorClosedCounter;
    private final Counter supervisorStartedCounter;
    private final Counter supervisorStoppedCounter;
    private final Counter supervisorRunCounter;
    private final Counter dockerTimeoutCounter;
    private final Meter containerStartedMeter;
    private final Meter containersExitedMeter;
    private final Meter containersRunningMeter;
    private final Meter containersThrewExceptionMeter;
    private final Meter dockerTimeoutMeter;
    private final Meter imageCacheHitMeter;
    private final Meter supervisorClosedMeter;
    private final Meter supervisorStartedMeter;
    private final Meter supervisorStoppedMeter;
    private final Meter supervisorRunMeter;

    public SupervisorMetricsImpl(String group, MetricRegistry registry) {
        String prefix = MetricRegistry.name((String)group, (String[])new String[]{TYPE}) + ".";
        this.containerStartedCounter = registry.counter(prefix + "container_started_counter");
        this.containersExitedCounter = registry.counter(prefix + "containers_exited_counter");
        this.containersRunningCounter = registry.counter(prefix + "containers_running_counter");
        this.containersThrewExceptionCounter = registry.counter(prefix + "containers_threw_exception_counter");
        this.imageCacheHitCounter = registry.counter(prefix + "image_cache_hit_counter");
        this.supervisorClosedCounter = registry.counter(prefix + "supervisor_closed_counter");
        this.supervisorStartedCounter = registry.counter(prefix + "supervisors_created_counter");
        this.supervisorStoppedCounter = registry.counter(prefix + "supervisor_stopped_counter");
        this.supervisorRunCounter = registry.counter(prefix + "supervisor_run_counter");
        this.dockerTimeoutCounter = registry.counter(prefix + "docker_timeout_counter");
        this.containerStartedMeter = registry.meter(prefix + "container_started_meter");
        this.containersExitedMeter = registry.meter(prefix + "containers_exited_meter");
        this.containersRunningMeter = registry.meter(prefix + "containers_running_meter");
        this.containersThrewExceptionMeter = registry.meter(prefix + "containers_threw_exception_meter");
        this.imageCacheHitMeter = registry.meter(prefix + "image_cache_hit_meter");
        this.supervisorClosedMeter = registry.meter(prefix + "supervisor_closed_meter");
        this.supervisorStartedMeter = registry.meter(prefix + "supervisors_created_meter");
        this.supervisorStoppedMeter = registry.meter(prefix + "supervisor_stopped_meter");
        this.supervisorRunMeter = registry.meter(prefix + "supervisor_run_meter");
        this.dockerTimeoutMeter = registry.meter(prefix + "docker_timeout_meter");
        this.imagePull = new RequestMetrics(group, TYPE, "image_pull", registry);
    }

    @Override
    public void supervisorStarted() {
        this.supervisorStartedCounter.inc();
        this.supervisorStartedMeter.mark();
    }

    @Override
    public void supervisorStopped() {
        this.supervisorStoppedCounter.inc();
        this.supervisorStoppedMeter.mark();
    }

    @Override
    public void supervisorClosed() {
        this.supervisorClosedCounter.inc();
        this.supervisorClosedMeter.mark();
    }

    @Override
    public void containersRunning() {
        this.containersRunningCounter.inc();
        this.containersRunningMeter.mark();
    }

    @Override
    public void containersExited() {
        this.containersExitedCounter.inc();
        this.containersExitedMeter.mark();
    }

    @Override
    public void containersThrewException() {
        this.containersThrewExceptionCounter.inc();
        this.containersThrewExceptionMeter.mark();
    }

    @Override
    public void containerStarted() {
        this.containerStartedCounter.inc();
        this.containerStartedMeter.mark();
    }

    @Override
    public MetricsContext containerPull() {
        return new MetricsContextImpl(this.imagePull);
    }

    @Override
    public void imageCacheHit() {
        this.imageCacheHitCounter.inc();
        this.imageCacheHitMeter.mark();
    }

    @Override
    public void imageCacheMiss() {
    }

    @Override
    public void dockerTimeout() {
        this.dockerTimeoutCounter.inc();
        this.dockerTimeoutMeter.mark();
    }

    @Override
    public MeterRates getDockerTimeoutRates() {
        return new MeterRates(this.dockerTimeoutMeter);
    }

    @Override
    public void supervisorRun() {
        this.supervisorRunCounter.inc();
        this.supervisorRunMeter.mark();
    }

    @Override
    public MeterRates getContainersThrewExceptionRates() {
        return new MeterRates(this.containersThrewExceptionMeter);
    }

    @Override
    public MeterRates getSupervisorRunRates() {
        return new MeterRates(this.supervisorRunMeter);
    }
}

