/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.servicescommon.statistics;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.spotify.helios.servicescommon.statistics.ZooKeeperMetrics;
import java.util.concurrent.TimeUnit;

public class ZooKeeperMetricsImpl
implements ZooKeeperMetrics {
    private static final String TYPE = "zookeeper";
    private final String prefix;
    private final Counter transientErrorCounter;
    private final Meter transientErrorMeter;
    private final MetricRegistry registry;

    public ZooKeeperMetricsImpl(String group, MetricRegistry registry) {
        this.prefix = MetricRegistry.name((String)group, (String[])new String[]{TYPE}) + ".";
        this.registry = registry;
        this.transientErrorCounter = registry.counter(this.prefix + "transient_error_count");
        this.transientErrorMeter = registry.meter(this.prefix + "transient_error_meter");
    }

    @Override
    public void zookeeperTransientError() {
        this.transientErrorCounter.inc();
        this.transientErrorMeter.mark();
    }

    @Override
    public void updateTimer(String name, long duration, TimeUnit timeUnit) {
        this.registry.timer(this.prefix + name).update(duration, timeUnit);
    }
}

