/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.RunnerScheduler;

public class Parallelized
extends BlockJUnit4ClassRunner {
    public Parallelized(Class<?> klass) throws Throwable {
        super(klass);
        this.setScheduler(new ThreadPoolScheduler());
    }

    private static class ThreadPoolScheduler
    implements RunnerScheduler {
        private ExecutorService executor;

        public ThreadPoolScheduler() {
            String threads = System.getProperty("junit.parallel.threads", "16");
            this.executor = Executors.newFixedThreadPool(Integer.parseInt(threads));
        }

        public void finished() {
            this.executor.shutdown();
            try {
                this.executor.awaitTermination(10L, TimeUnit.MINUTES);
            }
            catch (InterruptedException exc) {
                throw new RuntimeException(exc);
            }
        }

        public void schedule(Runnable childStatement) {
            this.executor.submit(childStatement);
        }
    }
}

