/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.collect.Range;
import com.google.common.util.concurrent.Uninterruptibles;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.junit.rules.ExternalResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemporaryPorts
extends ExternalResource {
    private static final Logger log = LoggerFactory.getLogger(TemporaryPorts.class);
    private static final int DEFAULT_START = 20000;
    private static final int DEFAULT_END = 32768;
    private static final int DEFAULT_RETRIES = 100;
    private static final Path DEFAULT_LOCK_DIRECTORY = Paths.get("/tmp/helios-test/ports/", new String[0]);
    private static final boolean DEFAULT_RELEASE = false;
    private final List<AllocatedPort> ports = Lists.newArrayList();
    private final int start;
    private final int end;
    private final boolean release;
    private final int retries;
    private final Path lockDirectory;
    private volatile boolean closed;

    private TemporaryPorts(Builder builder) {
        this.start = builder.start;
        this.end = builder.end;
        this.release = builder.release;
        this.retries = builder.retries;
        this.lockDirectory = (Path)Preconditions.checkNotNull((Object)builder.lockDirectory, (Object)"lockDirectory");
        try {
            Files.createDirectories(this.lockDirectory, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                TemporaryPorts.this.releasePorts();
            }
        });
    }

    protected synchronized void after() {
        this.closed = true;
        if (this.release) {
            this.releasePorts();
        }
    }

    private void releasePorts() {
        this.ports.forEach(AllocatedPort::release);
        this.ports.clear();
    }

    public synchronized AllocatedPort tryAcquire(String name, int port) {
        AllocatedPort allocatedPort = this.lock(port, name);
        if (allocatedPort == null) {
            return null;
        }
        this.ports.add(allocatedPort);
        return allocatedPort;
    }

    public synchronized int localPort(String name) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"closed");
        for (int i = 0; i < this.retries; ++i) {
            int port = this.randomPort();
            AllocatedPort allocatedPort = this.lock(port, name);
            if (allocatedPort == null) continue;
            if (this.available(port)) {
                log.debug("allocated port \"{}\": {}", (Object)name, (Object)port);
                this.ports.add(allocatedPort);
                return port;
            }
            allocatedPort.release();
        }
        throw new AllocationFailedException();
    }

    public synchronized Range<Integer> localPortRange(String name, int n) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"closed");
        for (int i = 0; i < this.retries; ++i) {
            int base = this.randomPort();
            ArrayList rangePorts = Lists.newArrayList();
            boolean successful = true;
            for (int j = 0; j < n; ++j) {
                int port = base + j;
                AllocatedPort allocatedPort = this.lock(port, name);
                if (allocatedPort == null) {
                    successful = false;
                    break;
                }
                rangePorts.add(allocatedPort);
                if (this.available(port)) continue;
                successful = false;
                break;
            }
            if (successful) {
                this.ports.addAll(rangePorts);
                return Range.closedOpen((Comparable)Integer.valueOf(base), (Comparable)Integer.valueOf(base + n));
            }
            rangePorts.forEach(AllocatedPort::release);
        }
        throw new AllocationFailedException();
    }

    private int randomPort() {
        return ThreadLocalRandom.current().nextInt(this.start, this.end);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean available(int port) {
        Socket s = new Socket();
        try {
            s.bind(new InetSocketAddress(InetAddress.getLoopbackAddress(), port));
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                s.close();
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
        for (int i = 0; i < 15; ++i) {
            Process p;
            try {
                p = Runtime.getRuntime().exec("lsof -i:" + port);
                p.waitFor();
            }
            catch (IOException | InterruptedException e) {
                throw Throwables.propagate((Throwable)e);
            }
            if (p.exitValue() == 1) {
                return true;
            }
            log.debug("waiting for port {} to become unused", (Object)port);
            Uninterruptibles.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.SECONDS);
        }
        return false;
    }

    private AllocatedPort lock(int port, String name) {
        Path path = this.lockDirectory.resolve(String.valueOf(port));
        try {
            FileChannel file = FileChannel.open(path, StandardOpenOption.CREATE, StandardOpenOption.WRITE);
            FileLock lock = file.tryLock();
            if (lock == null) {
                return null;
            }
            file.write(ByteBuffer.wrap(String.format("%d %s%n", port, name).getBytes(StandardCharsets.UTF_8)));
            file.force(true);
            return new AllocatedPort(port, path, file, lock);
        }
        catch (OverlappingFileLockException e) {
            return null;
        }
        catch (IOException e) {
            log.error("Failed to take port lock: {}", (Object)path, (Object)e);
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static TemporaryPorts create() {
        return TemporaryPorts.builder().build();
    }

    public static Builder builder() {
        return new Builder();
    }

    static /* synthetic */ Path access$800() {
        return DEFAULT_LOCK_DIRECTORY;
    }

    public static class Builder {
        private int start = 20000;
        private int end = 32768;
        private Path lockDirectory = TemporaryPorts.access$800();
        private boolean release = false;
        private int retries = 100;

        public int start() {
            return this.start;
        }

        public Builder start(int start) {
            this.start = start;
            return this;
        }

        public int end() {
            return this.end;
        }

        public Builder end(int end) {
            this.end = end;
            return this;
        }

        public Path lockDirectory() {
            return this.lockDirectory;
        }

        public void lockDirectory(Path lockDirectory) {
            this.lockDirectory = lockDirectory;
        }

        public boolean release() {
            return this.release;
        }

        public void release(boolean release) {
            this.release = release;
        }

        public int retries() {
            return this.retries;
        }

        public void retries(int retries) {
            this.retries = retries;
        }

        public TemporaryPorts build() {
            return new TemporaryPorts(this);
        }
    }

    public class AllocationFailedException
    extends RuntimeException {
    }

    public static class AllocatedPort {
        private final int port;
        private final Path path;
        private final FileChannel file;
        private final FileLock lock;

        private AllocatedPort(int port, Path path, FileChannel file, FileLock lock) {
            this.port = port;
            this.path = path;
            this.file = file;
            this.lock = lock;
        }

        public int port() {
            return this.port;
        }

        public void release() {
            if (!this.lock.isValid()) {
                log.debug("lock already released: {}", (Object)this.path);
                return;
            }
            try {
                this.lock.release();
            }
            catch (Exception e) {
                log.warn("caught exception releasing port lock: {}", (Object)this.path, (Object)e);
            }
            try {
                this.file.close();
            }
            catch (Exception e) {
                log.warn("caught exception closing port lock file: {}", (Object)this.path, (Object)e);
            }
            try {
                Files.deleteIfExists(this.path);
            }
            catch (Exception e) {
                log.warn("caught exception deleting port lock file: {}", (Object)this.path, (Object)e);
            }
        }
    }
}

