/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios;

import com.google.common.base.Throwables;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class Polling {
    public static <T> T await(long timeout, TimeUnit timeUnit, Callable<T> callable) throws Exception {
        long deadline = System.nanoTime() + timeUnit.toNanos(timeout);
        while (System.nanoTime() < deadline) {
            T value = callable.call();
            if (value != null) {
                return value;
            }
            Thread.sleep(500L);
        }
        String msg = String.format("The callable %s defined in %s failed to return anything after %d ms", callable.getClass().getName(), Thread.currentThread().getStackTrace()[2], timeUnit.toMillis(timeout));
        throw new TimeoutException(msg);
    }

    public static <T> T awaitUnchecked(long timeout, TimeUnit timeUnit, Callable<T> callable) throws TimeoutException {
        try {
            return Polling.await(timeout, timeUnit, callable);
        }
        catch (Throwable e) {
            Throwables.propagateIfInstanceOf((Throwable)e, TimeoutException.class);
            throw Throwables.propagate((Throwable)e);
        }
    }
}

