/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios;

import com.google.common.base.Throwables;
import com.google.common.io.Files;
import com.spotify.helios.Polling;
import com.spotify.helios.TemporaryPorts;
import com.spotify.helios.ZooKeeperTestManager;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.io.FileUtils;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.curator.test.TestingServer;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.server.auth.DigestAuthenticationProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperTestingServerManager
implements ZooKeeperTestManager {
    private static final Logger log = LoggerFactory.getLogger(ZooKeeperTestingServerManager.class);
    private static final String SUPER_USER = "super";
    private static final String SUPER_PASSWORD = "hunter2****";
    public final TemporaryPorts temporaryPorts = TemporaryPorts.create();
    private final int port = this.temporaryPorts.localPort("zookeeper");
    private final String endpoint = "127.0.0.1:" + this.port;
    private final File dataDir = Files.createTempDir();
    private CuratorFramework curator;
    private TestingServer server;

    public ZooKeeperTestingServerManager() {
        ExponentialBackoffRetry retryPolicy = new ExponentialBackoffRetry(1000, 3);
        CuratorFrameworkFactory.Builder builder = CuratorFrameworkFactory.builder().connectString(this.endpoint).retryPolicy((RetryPolicy)retryPolicy).authorization("digest", "super:hunter2****".getBytes());
        this.curator = builder.build();
        log.info("starting CuratorFramework connected to {}", (Object)this.endpoint);
        this.curator.start();
        this.start();
    }

    @Override
    public void ensure(String path) throws Exception {
        this.curator.newNamespaceAwareEnsurePath(path).ensure(this.curator.getZookeeperClient());
    }

    @Override
    public void close() throws InterruptedException {
        try {
            this.server.close();
        }
        catch (IOException e) {
            Throwables.propagate((Throwable)e);
        }
        this.stop();
        FileUtils.deleteQuietly((File)this.dataDir);
    }

    @Override
    public String connectString() {
        return this.endpoint;
    }

    @Override
    public CuratorFramework curatorWithSuperAuth() {
        return this.curator;
    }

    @Override
    public void awaitUp(long timeout, TimeUnit timeunit) throws TimeoutException {
        Polling.awaitUnchecked(timeout, timeunit, () -> {
            try {
                return this.curatorWithSuperAuth().usingNamespace(null).getChildren().forPath("/");
            }
            catch (Exception e) {
                return null;
            }
        });
    }

    @Override
    public void awaitDown(int timeout, TimeUnit timeunit) throws TimeoutException {
        Polling.awaitUnchecked(timeout, timeunit, () -> {
            try {
                this.curatorWithSuperAuth().usingNamespace(null).getChildren().forPath("/");
                return null;
            }
            catch (KeeperException.ConnectionLossException e) {
                return true;
            }
            catch (Exception e) {
                return null;
            }
        });
    }

    @Override
    public void start() {
        log.info("starting zookeeper TestingServer at port={}, dataDir={}", (Object)this.port, (Object)this.dataDir);
        try {
            this.server = new TestingServer(this.port, this.dataDir);
            this.awaitUp(2L, TimeUnit.MINUTES);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public void stop() throws InterruptedException {
        try {
            this.server.stop();
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public void backup(Path destination) {
        try {
            FileUtils.copyDirectory((File)this.dataDir, (File)destination.toFile());
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public void restore(Path source) {
        try {
            FileUtils.deleteDirectory((File)this.dataDir);
            FileUtils.copyDirectory((File)source.toFile(), (File)this.dataDir);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public void reset() {
        FileUtils.deleteQuietly((File)this.dataDir);
    }

    static {
        try {
            String superDigest = DigestAuthenticationProvider.generateDigest((String)"super:hunter2****");
            Field digestField = DigestAuthenticationProvider.class.getDeclaredField("superDigest");
            digestField.setAccessible(true);
            Field modifiersField = Field.class.getDeclaredField("modifiers");
            modifiersField.setAccessible(true);
            modifiersField.setInt(digestField, digestField.getModifiers() & 0xFFFFFFEF);
            digestField.set(null, superDigest);
        }
        catch (IllegalAccessException | NoSuchFieldException | NoSuchAlgorithmException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

