// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: tensorflow_metadata/proto/v0/problem_statement.proto

// Protobuf Java Version: 3.25.2
package org.tensorflow.metadata.v0;

/**
 * <pre>
 * Configuration for a top-K classification task.
 * In this problem type, there are n_classes possible label values, and the
 * model predicts n_predicted_labels labels.
 * The output is a sequence of n_predicted_labels labels, out of n_classes
 * possible classes. The order of the predicted output labels is determined
 * by the predictions_order field.
 * (*) MultiClassClassification is the same as TopKClassification with
 *     n_predicted_labels = 1.
 * (*) TopKClassification does NOT mean multi-class multi-label classification:
 *     e.g., the output contains a sequence of labels, all coming from the same
 *     label column in the data.
 * </pre>
 *
 * Protobuf type {@code tensorflow.metadata.v0.TopKClassification}
 */
public final class TopKClassification extends
    com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:tensorflow.metadata.v0.TopKClassification)
    TopKClassificationOrBuilder {
private static final long serialVersionUID = 0L;
  // Use TopKClassification.newBuilder() to construct.
  private TopKClassification(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private TopKClassification() {
    exampleWeight_ = "";
    predictionsOrder_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(
      UnusedPrivateParameter unused) {
    return new TopKClassification();
  }

  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return org.tensorflow.metadata.v0.ProblemStatementOuterClass.internal_static_tensorflow_metadata_v0_TopKClassification_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return org.tensorflow.metadata.v0.ProblemStatementOuterClass.internal_static_tensorflow_metadata_v0_TopKClassification_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            org.tensorflow.metadata.v0.TopKClassification.class, org.tensorflow.metadata.v0.TopKClassification.Builder.class);
  }

  /**
   * Protobuf enum {@code tensorflow.metadata.v0.TopKClassification.Order}
   */
  public enum Order
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <code>UNSPECIFIED = 0;</code>
     */
    UNSPECIFIED(0),
    /**
     * <pre>
     * Predictions are ordered from the most likely to least likely.
     * </pre>
     *
     * <code>SCORE_DESC = 1;</code>
     */
    SCORE_DESC(1),
    /**
     * <pre>
     * Predictions are ordered from the least likely to most likely.
     * </pre>
     *
     * <code>SCORE_ASC = 2;</code>
     */
    SCORE_ASC(2),
    UNRECOGNIZED(-1),
    ;

    /**
     * <code>UNSPECIFIED = 0;</code>
     */
    public static final int UNSPECIFIED_VALUE = 0;
    /**
     * <pre>
     * Predictions are ordered from the most likely to least likely.
     * </pre>
     *
     * <code>SCORE_DESC = 1;</code>
     */
    public static final int SCORE_DESC_VALUE = 1;
    /**
     * <pre>
     * Predictions are ordered from the least likely to most likely.
     * </pre>
     *
     * <code>SCORE_ASC = 2;</code>
     */
    public static final int SCORE_ASC_VALUE = 2;


    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Order valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Order forNumber(int value) {
      switch (value) {
        case 0: return UNSPECIFIED;
        case 1: return SCORE_DESC;
        case 2: return SCORE_ASC;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Order>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static final com.google.protobuf.Internal.EnumLiteMap<
        Order> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<Order>() {
            public Order findValueByNumber(int number) {
              return Order.forNumber(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return org.tensorflow.metadata.v0.TopKClassification.getDescriptor().getEnumTypes().get(0);
    }

    private static final Order[] VALUES = values();

    public static Order valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Order(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:tensorflow.metadata.v0.TopKClassification.Order)
  }

  private int labelIdCase_ = 0;
  @SuppressWarnings("serial")
  private java.lang.Object labelId_;
  public enum LabelIdCase
      implements com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    LABEL(1),
    LABEL_PATH(6),
    LABELID_NOT_SET(0);
    private final int value;
    private LabelIdCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static LabelIdCase valueOf(int value) {
      return forNumber(value);
    }

    public static LabelIdCase forNumber(int value) {
      switch (value) {
        case 1: return LABEL;
        case 6: return LABEL_PATH;
        case 0: return LABELID_NOT_SET;
        default: return null;
      }
    }
    public int getNumber() {
      return this.value;
    }
  };

  public LabelIdCase
  getLabelIdCase() {
    return LabelIdCase.forNumber(
        labelIdCase_);
  }

  public static final int LABEL_FIELD_NUMBER = 1;
  /**
   * <pre>
   * The name of the label. Assumes the label is a flat, top-level field.
   * </pre>
   *
   * <code>string label = 1;</code>
   * @return Whether the label field is set.
   */
  public boolean hasLabel() {
    return labelIdCase_ == 1;
  }
  /**
   * <pre>
   * The name of the label. Assumes the label is a flat, top-level field.
   * </pre>
   *
   * <code>string label = 1;</code>
   * @return The label.
   */
  public java.lang.String getLabel() {
    java.lang.Object ref = "";
    if (labelIdCase_ == 1) {
      ref = labelId_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (labelIdCase_ == 1) {
        labelId_ = s;
      }
      return s;
    }
  }
  /**
   * <pre>
   * The name of the label. Assumes the label is a flat, top-level field.
   * </pre>
   *
   * <code>string label = 1;</code>
   * @return The bytes for label.
   */
  public com.google.protobuf.ByteString
      getLabelBytes() {
    java.lang.Object ref = "";
    if (labelIdCase_ == 1) {
      ref = labelId_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      if (labelIdCase_ == 1) {
        labelId_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LABEL_PATH_FIELD_NUMBER = 6;
  /**
   * <pre>
   * A path can be used instead of a flat string if the label is nested.
   * </pre>
   *
   * <code>.tensorflow.metadata.v0.Path label_path = 6;</code>
   * @return Whether the labelPath field is set.
   */
  @java.lang.Override
  public boolean hasLabelPath() {
    return labelIdCase_ == 6;
  }
  /**
   * <pre>
   * A path can be used instead of a flat string if the label is nested.
   * </pre>
   *
   * <code>.tensorflow.metadata.v0.Path label_path = 6;</code>
   * @return The labelPath.
   */
  @java.lang.Override
  public org.tensorflow.metadata.v0.Path getLabelPath() {
    if (labelIdCase_ == 6) {
       return (org.tensorflow.metadata.v0.Path) labelId_;
    }
    return org.tensorflow.metadata.v0.Path.getDefaultInstance();
  }
  /**
   * <pre>
   * A path can be used instead of a flat string if the label is nested.
   * </pre>
   *
   * <code>.tensorflow.metadata.v0.Path label_path = 6;</code>
   */
  @java.lang.Override
  public org.tensorflow.metadata.v0.PathOrBuilder getLabelPathOrBuilder() {
    if (labelIdCase_ == 6) {
       return (org.tensorflow.metadata.v0.Path) labelId_;
    }
    return org.tensorflow.metadata.v0.Path.getDefaultInstance();
  }

  public static final int EXAMPLE_WEIGHT_FIELD_NUMBER = 2;
  @SuppressWarnings("serial")
  private volatile java.lang.Object exampleWeight_ = "";
  /**
   * <pre>
   * (optional) The weight column.
   * </pre>
   *
   * <code>string example_weight = 2;</code>
   * @return The exampleWeight.
   */
  @java.lang.Override
  public java.lang.String getExampleWeight() {
    java.lang.Object ref = exampleWeight_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      exampleWeight_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * (optional) The weight column.
   * </pre>
   *
   * <code>string example_weight = 2;</code>
   * @return The bytes for exampleWeight.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getExampleWeightBytes() {
    java.lang.Object ref = exampleWeight_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      exampleWeight_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int N_CLASSES_FIELD_NUMBER = 3;
  private long nClasses_ = 0L;
  /**
   * <pre>
   * (optional) The number of label classes. If unset, the solution provider
   * is expected to infer the number of classes from the data.
   * </pre>
   *
   * <code>uint64 n_classes = 3;</code>
   * @return The nClasses.
   */
  @java.lang.Override
  public long getNClasses() {
    return nClasses_;
  }

  public static final int N_PREDICTED_LABELS_FIELD_NUMBER = 4;
  private long nPredictedLabels_ = 0L;
  /**
   * <pre>
   * (optional) The number of class labels to predict. If unset, we assume 1.
   * </pre>
   *
   * <code>uint64 n_predicted_labels = 4;</code>
   * @return The nPredictedLabels.
   */
  @java.lang.Override
  public long getNPredictedLabels() {
    return nPredictedLabels_;
  }

  public static final int PREDICTIONS_ORDER_FIELD_NUMBER = 5;
  private int predictionsOrder_ = 0;
  /**
   * <code>.tensorflow.metadata.v0.TopKClassification.Order predictions_order = 5;</code>
   * @return The enum numeric value on the wire for predictionsOrder.
   */
  @java.lang.Override public int getPredictionsOrderValue() {
    return predictionsOrder_;
  }
  /**
   * <code>.tensorflow.metadata.v0.TopKClassification.Order predictions_order = 5;</code>
   * @return The predictionsOrder.
   */
  @java.lang.Override public org.tensorflow.metadata.v0.TopKClassification.Order getPredictionsOrder() {
    org.tensorflow.metadata.v0.TopKClassification.Order result = org.tensorflow.metadata.v0.TopKClassification.Order.forNumber(predictionsOrder_);
    return result == null ? org.tensorflow.metadata.v0.TopKClassification.Order.UNRECOGNIZED : result;
  }

  private byte memoizedIsInitialized = -1;
  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    if (labelIdCase_ == 1) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, labelId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(exampleWeight_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, exampleWeight_);
    }
    if (nClasses_ != 0L) {
      output.writeUInt64(3, nClasses_);
    }
    if (nPredictedLabels_ != 0L) {
      output.writeUInt64(4, nPredictedLabels_);
    }
    if (predictionsOrder_ != org.tensorflow.metadata.v0.TopKClassification.Order.UNSPECIFIED.getNumber()) {
      output.writeEnum(5, predictionsOrder_);
    }
    if (labelIdCase_ == 6) {
      output.writeMessage(6, (org.tensorflow.metadata.v0.Path) labelId_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (labelIdCase_ == 1) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, labelId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(exampleWeight_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, exampleWeight_);
    }
    if (nClasses_ != 0L) {
      size += com.google.protobuf.CodedOutputStream
        .computeUInt64Size(3, nClasses_);
    }
    if (nPredictedLabels_ != 0L) {
      size += com.google.protobuf.CodedOutputStream
        .computeUInt64Size(4, nPredictedLabels_);
    }
    if (predictionsOrder_ != org.tensorflow.metadata.v0.TopKClassification.Order.UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream
        .computeEnumSize(5, predictionsOrder_);
    }
    if (labelIdCase_ == 6) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(6, (org.tensorflow.metadata.v0.Path) labelId_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof org.tensorflow.metadata.v0.TopKClassification)) {
      return super.equals(obj);
    }
    org.tensorflow.metadata.v0.TopKClassification other = (org.tensorflow.metadata.v0.TopKClassification) obj;

    if (!getExampleWeight()
        .equals(other.getExampleWeight())) return false;
    if (getNClasses()
        != other.getNClasses()) return false;
    if (getNPredictedLabels()
        != other.getNPredictedLabels()) return false;
    if (predictionsOrder_ != other.predictionsOrder_) return false;
    if (!getLabelIdCase().equals(other.getLabelIdCase())) return false;
    switch (labelIdCase_) {
      case 1:
        if (!getLabel()
            .equals(other.getLabel())) return false;
        break;
      case 6:
        if (!getLabelPath()
            .equals(other.getLabelPath())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + EXAMPLE_WEIGHT_FIELD_NUMBER;
    hash = (53 * hash) + getExampleWeight().hashCode();
    hash = (37 * hash) + N_CLASSES_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
        getNClasses());
    hash = (37 * hash) + N_PREDICTED_LABELS_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
        getNPredictedLabels());
    hash = (37 * hash) + PREDICTIONS_ORDER_FIELD_NUMBER;
    hash = (53 * hash) + predictionsOrder_;
    switch (labelIdCase_) {
      case 1:
        hash = (37 * hash) + LABEL_FIELD_NUMBER;
        hash = (53 * hash) + getLabel().hashCode();
        break;
      case 6:
        hash = (37 * hash) + LABEL_PATH_FIELD_NUMBER;
        hash = (53 * hash) + getLabelPath().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static org.tensorflow.metadata.v0.TopKClassification parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static org.tensorflow.metadata.v0.TopKClassification parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static org.tensorflow.metadata.v0.TopKClassification parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static org.tensorflow.metadata.v0.TopKClassification parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static org.tensorflow.metadata.v0.TopKClassification parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static org.tensorflow.metadata.v0.TopKClassification parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static org.tensorflow.metadata.v0.TopKClassification parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static org.tensorflow.metadata.v0.TopKClassification parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  public static org.tensorflow.metadata.v0.TopKClassification parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }

  public static org.tensorflow.metadata.v0.TopKClassification parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static org.tensorflow.metadata.v0.TopKClassification parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static org.tensorflow.metadata.v0.TopKClassification parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(org.tensorflow.metadata.v0.TopKClassification prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * Configuration for a top-K classification task.
   * In this problem type, there are n_classes possible label values, and the
   * model predicts n_predicted_labels labels.
   * The output is a sequence of n_predicted_labels labels, out of n_classes
   * possible classes. The order of the predicted output labels is determined
   * by the predictions_order field.
   * (*) MultiClassClassification is the same as TopKClassification with
   *     n_predicted_labels = 1.
   * (*) TopKClassification does NOT mean multi-class multi-label classification:
   *     e.g., the output contains a sequence of labels, all coming from the same
   *     label column in the data.
   * </pre>
   *
   * Protobuf type {@code tensorflow.metadata.v0.TopKClassification}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:tensorflow.metadata.v0.TopKClassification)
      org.tensorflow.metadata.v0.TopKClassificationOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.tensorflow.metadata.v0.ProblemStatementOuterClass.internal_static_tensorflow_metadata_v0_TopKClassification_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.tensorflow.metadata.v0.ProblemStatementOuterClass.internal_static_tensorflow_metadata_v0_TopKClassification_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.tensorflow.metadata.v0.TopKClassification.class, org.tensorflow.metadata.v0.TopKClassification.Builder.class);
    }

    // Construct using org.tensorflow.metadata.v0.TopKClassification.newBuilder()
    private Builder() {

    }

    private Builder(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);

    }
    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (labelPathBuilder_ != null) {
        labelPathBuilder_.clear();
      }
      exampleWeight_ = "";
      nClasses_ = 0L;
      nPredictedLabels_ = 0L;
      predictionsOrder_ = 0;
      labelIdCase_ = 0;
      labelId_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return org.tensorflow.metadata.v0.ProblemStatementOuterClass.internal_static_tensorflow_metadata_v0_TopKClassification_descriptor;
    }

    @java.lang.Override
    public org.tensorflow.metadata.v0.TopKClassification getDefaultInstanceForType() {
      return org.tensorflow.metadata.v0.TopKClassification.getDefaultInstance();
    }

    @java.lang.Override
    public org.tensorflow.metadata.v0.TopKClassification build() {
      org.tensorflow.metadata.v0.TopKClassification result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public org.tensorflow.metadata.v0.TopKClassification buildPartial() {
      org.tensorflow.metadata.v0.TopKClassification result = new org.tensorflow.metadata.v0.TopKClassification(this);
      if (bitField0_ != 0) { buildPartial0(result); }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(org.tensorflow.metadata.v0.TopKClassification result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.exampleWeight_ = exampleWeight_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.nClasses_ = nClasses_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.nPredictedLabels_ = nPredictedLabels_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.predictionsOrder_ = predictionsOrder_;
      }
    }

    private void buildPartialOneofs(org.tensorflow.metadata.v0.TopKClassification result) {
      result.labelIdCase_ = labelIdCase_;
      result.labelId_ = this.labelId_;
      if (labelIdCase_ == 6 &&
          labelPathBuilder_ != null) {
        result.labelId_ = labelPathBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }
    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return super.setField(field, value);
    }
    @java.lang.Override
    public Builder clearField(
        com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }
    @java.lang.Override
    public Builder clearOneof(
        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }
    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }
    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }
    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof org.tensorflow.metadata.v0.TopKClassification) {
        return mergeFrom((org.tensorflow.metadata.v0.TopKClassification)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(org.tensorflow.metadata.v0.TopKClassification other) {
      if (other == org.tensorflow.metadata.v0.TopKClassification.getDefaultInstance()) return this;
      if (!other.getExampleWeight().isEmpty()) {
        exampleWeight_ = other.exampleWeight_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.getNClasses() != 0L) {
        setNClasses(other.getNClasses());
      }
      if (other.getNPredictedLabels() != 0L) {
        setNPredictedLabels(other.getNPredictedLabels());
      }
      if (other.predictionsOrder_ != 0) {
        setPredictionsOrderValue(other.getPredictionsOrderValue());
      }
      switch (other.getLabelIdCase()) {
        case LABEL: {
          labelIdCase_ = 1;
          labelId_ = other.labelId_;
          onChanged();
          break;
        }
        case LABEL_PATH: {
          mergeLabelPath(other.getLabelPath());
          break;
        }
        case LABELID_NOT_SET: {
          break;
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10: {
              java.lang.String s = input.readStringRequireUtf8();
              labelIdCase_ = 1;
              labelId_ = s;
              break;
            } // case 10
            case 18: {
              exampleWeight_ = input.readStringRequireUtf8();
              bitField0_ |= 0x00000004;
              break;
            } // case 18
            case 24: {
              nClasses_ = input.readUInt64();
              bitField0_ |= 0x00000008;
              break;
            } // case 24
            case 32: {
              nPredictedLabels_ = input.readUInt64();
              bitField0_ |= 0x00000010;
              break;
            } // case 32
            case 40: {
              predictionsOrder_ = input.readEnum();
              bitField0_ |= 0x00000020;
              break;
            } // case 40
            case 50: {
              input.readMessage(
                  getLabelPathFieldBuilder().getBuilder(),
                  extensionRegistry);
              labelIdCase_ = 6;
              break;
            } // case 50
            default: {
              if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                done = true; // was an endgroup tag
              }
              break;
            } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }
    private int labelIdCase_ = 0;
    private java.lang.Object labelId_;
    public LabelIdCase
        getLabelIdCase() {
      return LabelIdCase.forNumber(
          labelIdCase_);
    }

    public Builder clearLabelId() {
      labelIdCase_ = 0;
      labelId_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    /**
     * <pre>
     * The name of the label. Assumes the label is a flat, top-level field.
     * </pre>
     *
     * <code>string label = 1;</code>
     * @return Whether the label field is set.
     */
    @java.lang.Override
    public boolean hasLabel() {
      return labelIdCase_ == 1;
    }
    /**
     * <pre>
     * The name of the label. Assumes the label is a flat, top-level field.
     * </pre>
     *
     * <code>string label = 1;</code>
     * @return The label.
     */
    @java.lang.Override
    public java.lang.String getLabel() {
      java.lang.Object ref = "";
      if (labelIdCase_ == 1) {
        ref = labelId_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (labelIdCase_ == 1) {
          labelId_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * The name of the label. Assumes the label is a flat, top-level field.
     * </pre>
     *
     * <code>string label = 1;</code>
     * @return The bytes for label.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString
        getLabelBytes() {
      java.lang.Object ref = "";
      if (labelIdCase_ == 1) {
        ref = labelId_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        if (labelIdCase_ == 1) {
          labelId_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * The name of the label. Assumes the label is a flat, top-level field.
     * </pre>
     *
     * <code>string label = 1;</code>
     * @param value The label to set.
     * @return This builder for chaining.
     */
    public Builder setLabel(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      labelIdCase_ = 1;
      labelId_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The name of the label. Assumes the label is a flat, top-level field.
     * </pre>
     *
     * <code>string label = 1;</code>
     * @return This builder for chaining.
     */
    public Builder clearLabel() {
      if (labelIdCase_ == 1) {
        labelIdCase_ = 0;
        labelId_ = null;
        onChanged();
      }
      return this;
    }
    /**
     * <pre>
     * The name of the label. Assumes the label is a flat, top-level field.
     * </pre>
     *
     * <code>string label = 1;</code>
     * @param value The bytes for label to set.
     * @return This builder for chaining.
     */
    public Builder setLabelBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      checkByteStringIsUtf8(value);
      labelIdCase_ = 1;
      labelId_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
        org.tensorflow.metadata.v0.Path, org.tensorflow.metadata.v0.Path.Builder, org.tensorflow.metadata.v0.PathOrBuilder> labelPathBuilder_;
    /**
     * <pre>
     * A path can be used instead of a flat string if the label is nested.
     * </pre>
     *
     * <code>.tensorflow.metadata.v0.Path label_path = 6;</code>
     * @return Whether the labelPath field is set.
     */
    @java.lang.Override
    public boolean hasLabelPath() {
      return labelIdCase_ == 6;
    }
    /**
     * <pre>
     * A path can be used instead of a flat string if the label is nested.
     * </pre>
     *
     * <code>.tensorflow.metadata.v0.Path label_path = 6;</code>
     * @return The labelPath.
     */
    @java.lang.Override
    public org.tensorflow.metadata.v0.Path getLabelPath() {
      if (labelPathBuilder_ == null) {
        if (labelIdCase_ == 6) {
          return (org.tensorflow.metadata.v0.Path) labelId_;
        }
        return org.tensorflow.metadata.v0.Path.getDefaultInstance();
      } else {
        if (labelIdCase_ == 6) {
          return labelPathBuilder_.getMessage();
        }
        return org.tensorflow.metadata.v0.Path.getDefaultInstance();
      }
    }
    /**
     * <pre>
     * A path can be used instead of a flat string if the label is nested.
     * </pre>
     *
     * <code>.tensorflow.metadata.v0.Path label_path = 6;</code>
     */
    public Builder setLabelPath(org.tensorflow.metadata.v0.Path value) {
      if (labelPathBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        labelId_ = value;
        onChanged();
      } else {
        labelPathBuilder_.setMessage(value);
      }
      labelIdCase_ = 6;
      return this;
    }
    /**
     * <pre>
     * A path can be used instead of a flat string if the label is nested.
     * </pre>
     *
     * <code>.tensorflow.metadata.v0.Path label_path = 6;</code>
     */
    public Builder setLabelPath(
        org.tensorflow.metadata.v0.Path.Builder builderForValue) {
      if (labelPathBuilder_ == null) {
        labelId_ = builderForValue.build();
        onChanged();
      } else {
        labelPathBuilder_.setMessage(builderForValue.build());
      }
      labelIdCase_ = 6;
      return this;
    }
    /**
     * <pre>
     * A path can be used instead of a flat string if the label is nested.
     * </pre>
     *
     * <code>.tensorflow.metadata.v0.Path label_path = 6;</code>
     */
    public Builder mergeLabelPath(org.tensorflow.metadata.v0.Path value) {
      if (labelPathBuilder_ == null) {
        if (labelIdCase_ == 6 &&
            labelId_ != org.tensorflow.metadata.v0.Path.getDefaultInstance()) {
          labelId_ = org.tensorflow.metadata.v0.Path.newBuilder((org.tensorflow.metadata.v0.Path) labelId_)
              .mergeFrom(value).buildPartial();
        } else {
          labelId_ = value;
        }
        onChanged();
      } else {
        if (labelIdCase_ == 6) {
          labelPathBuilder_.mergeFrom(value);
        } else {
          labelPathBuilder_.setMessage(value);
        }
      }
      labelIdCase_ = 6;
      return this;
    }
    /**
     * <pre>
     * A path can be used instead of a flat string if the label is nested.
     * </pre>
     *
     * <code>.tensorflow.metadata.v0.Path label_path = 6;</code>
     */
    public Builder clearLabelPath() {
      if (labelPathBuilder_ == null) {
        if (labelIdCase_ == 6) {
          labelIdCase_ = 0;
          labelId_ = null;
          onChanged();
        }
      } else {
        if (labelIdCase_ == 6) {
          labelIdCase_ = 0;
          labelId_ = null;
        }
        labelPathBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * A path can be used instead of a flat string if the label is nested.
     * </pre>
     *
     * <code>.tensorflow.metadata.v0.Path label_path = 6;</code>
     */
    public org.tensorflow.metadata.v0.Path.Builder getLabelPathBuilder() {
      return getLabelPathFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * A path can be used instead of a flat string if the label is nested.
     * </pre>
     *
     * <code>.tensorflow.metadata.v0.Path label_path = 6;</code>
     */
    @java.lang.Override
    public org.tensorflow.metadata.v0.PathOrBuilder getLabelPathOrBuilder() {
      if ((labelIdCase_ == 6) && (labelPathBuilder_ != null)) {
        return labelPathBuilder_.getMessageOrBuilder();
      } else {
        if (labelIdCase_ == 6) {
          return (org.tensorflow.metadata.v0.Path) labelId_;
        }
        return org.tensorflow.metadata.v0.Path.getDefaultInstance();
      }
    }
    /**
     * <pre>
     * A path can be used instead of a flat string if the label is nested.
     * </pre>
     *
     * <code>.tensorflow.metadata.v0.Path label_path = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        org.tensorflow.metadata.v0.Path, org.tensorflow.metadata.v0.Path.Builder, org.tensorflow.metadata.v0.PathOrBuilder> 
        getLabelPathFieldBuilder() {
      if (labelPathBuilder_ == null) {
        if (!(labelIdCase_ == 6)) {
          labelId_ = org.tensorflow.metadata.v0.Path.getDefaultInstance();
        }
        labelPathBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            org.tensorflow.metadata.v0.Path, org.tensorflow.metadata.v0.Path.Builder, org.tensorflow.metadata.v0.PathOrBuilder>(
                (org.tensorflow.metadata.v0.Path) labelId_,
                getParentForChildren(),
                isClean());
        labelId_ = null;
      }
      labelIdCase_ = 6;
      onChanged();
      return labelPathBuilder_;
    }

    private java.lang.Object exampleWeight_ = "";
    /**
     * <pre>
     * (optional) The weight column.
     * </pre>
     *
     * <code>string example_weight = 2;</code>
     * @return The exampleWeight.
     */
    public java.lang.String getExampleWeight() {
      java.lang.Object ref = exampleWeight_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        exampleWeight_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * (optional) The weight column.
     * </pre>
     *
     * <code>string example_weight = 2;</code>
     * @return The bytes for exampleWeight.
     */
    public com.google.protobuf.ByteString
        getExampleWeightBytes() {
      java.lang.Object ref = exampleWeight_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        exampleWeight_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * (optional) The weight column.
     * </pre>
     *
     * <code>string example_weight = 2;</code>
     * @param value The exampleWeight to set.
     * @return This builder for chaining.
     */
    public Builder setExampleWeight(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      exampleWeight_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * (optional) The weight column.
     * </pre>
     *
     * <code>string example_weight = 2;</code>
     * @return This builder for chaining.
     */
    public Builder clearExampleWeight() {
      exampleWeight_ = getDefaultInstance().getExampleWeight();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * (optional) The weight column.
     * </pre>
     *
     * <code>string example_weight = 2;</code>
     * @param value The bytes for exampleWeight to set.
     * @return This builder for chaining.
     */
    public Builder setExampleWeightBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      checkByteStringIsUtf8(value);
      exampleWeight_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private long nClasses_ ;
    /**
     * <pre>
     * (optional) The number of label classes. If unset, the solution provider
     * is expected to infer the number of classes from the data.
     * </pre>
     *
     * <code>uint64 n_classes = 3;</code>
     * @return The nClasses.
     */
    @java.lang.Override
    public long getNClasses() {
      return nClasses_;
    }
    /**
     * <pre>
     * (optional) The number of label classes. If unset, the solution provider
     * is expected to infer the number of classes from the data.
     * </pre>
     *
     * <code>uint64 n_classes = 3;</code>
     * @param value The nClasses to set.
     * @return This builder for chaining.
     */
    public Builder setNClasses(long value) {

      nClasses_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * (optional) The number of label classes. If unset, the solution provider
     * is expected to infer the number of classes from the data.
     * </pre>
     *
     * <code>uint64 n_classes = 3;</code>
     * @return This builder for chaining.
     */
    public Builder clearNClasses() {
      bitField0_ = (bitField0_ & ~0x00000008);
      nClasses_ = 0L;
      onChanged();
      return this;
    }

    private long nPredictedLabels_ ;
    /**
     * <pre>
     * (optional) The number of class labels to predict. If unset, we assume 1.
     * </pre>
     *
     * <code>uint64 n_predicted_labels = 4;</code>
     * @return The nPredictedLabels.
     */
    @java.lang.Override
    public long getNPredictedLabels() {
      return nPredictedLabels_;
    }
    /**
     * <pre>
     * (optional) The number of class labels to predict. If unset, we assume 1.
     * </pre>
     *
     * <code>uint64 n_predicted_labels = 4;</code>
     * @param value The nPredictedLabels to set.
     * @return This builder for chaining.
     */
    public Builder setNPredictedLabels(long value) {

      nPredictedLabels_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * (optional) The number of class labels to predict. If unset, we assume 1.
     * </pre>
     *
     * <code>uint64 n_predicted_labels = 4;</code>
     * @return This builder for chaining.
     */
    public Builder clearNPredictedLabels() {
      bitField0_ = (bitField0_ & ~0x00000010);
      nPredictedLabels_ = 0L;
      onChanged();
      return this;
    }

    private int predictionsOrder_ = 0;
    /**
     * <code>.tensorflow.metadata.v0.TopKClassification.Order predictions_order = 5;</code>
     * @return The enum numeric value on the wire for predictionsOrder.
     */
    @java.lang.Override public int getPredictionsOrderValue() {
      return predictionsOrder_;
    }
    /**
     * <code>.tensorflow.metadata.v0.TopKClassification.Order predictions_order = 5;</code>
     * @param value The enum numeric value on the wire for predictionsOrder to set.
     * @return This builder for chaining.
     */
    public Builder setPredictionsOrderValue(int value) {
      predictionsOrder_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     * <code>.tensorflow.metadata.v0.TopKClassification.Order predictions_order = 5;</code>
     * @return The predictionsOrder.
     */
    @java.lang.Override
    public org.tensorflow.metadata.v0.TopKClassification.Order getPredictionsOrder() {
      org.tensorflow.metadata.v0.TopKClassification.Order result = org.tensorflow.metadata.v0.TopKClassification.Order.forNumber(predictionsOrder_);
      return result == null ? org.tensorflow.metadata.v0.TopKClassification.Order.UNRECOGNIZED : result;
    }
    /**
     * <code>.tensorflow.metadata.v0.TopKClassification.Order predictions_order = 5;</code>
     * @param value The predictionsOrder to set.
     * @return This builder for chaining.
     */
    public Builder setPredictionsOrder(org.tensorflow.metadata.v0.TopKClassification.Order value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000020;
      predictionsOrder_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     * <code>.tensorflow.metadata.v0.TopKClassification.Order predictions_order = 5;</code>
     * @return This builder for chaining.
     */
    public Builder clearPredictionsOrder() {
      bitField0_ = (bitField0_ & ~0x00000020);
      predictionsOrder_ = 0;
      onChanged();
      return this;
    }
    @java.lang.Override
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:tensorflow.metadata.v0.TopKClassification)
  }

  // @@protoc_insertion_point(class_scope:tensorflow.metadata.v0.TopKClassification)
  private static final org.tensorflow.metadata.v0.TopKClassification DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new org.tensorflow.metadata.v0.TopKClassification();
  }

  public static org.tensorflow.metadata.v0.TopKClassification getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<TopKClassification>
      PARSER = new com.google.protobuf.AbstractParser<TopKClassification>() {
    @java.lang.Override
    public TopKClassification parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      Builder builder = newBuilder();
      try {
        builder.mergeFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(builder.buildPartial());
      } catch (com.google.protobuf.UninitializedMessageException e) {
        throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e)
            .setUnfinishedMessage(builder.buildPartial());
      }
      return builder.buildPartial();
    }
  };

  public static com.google.protobuf.Parser<TopKClassification> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<TopKClassification> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public org.tensorflow.metadata.v0.TopKClassification getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

