/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.metrics.example;

import com.codahale.metrics.Metric;
import com.spotify.metrics.core.MetricId;
import com.spotify.metrics.core.SemanticMetricRegistry;
import com.spotify.metrics.ffwd.FastForwardReporter;
import com.spotify.metrics.jvm.CpuGaugeSet;
import com.spotify.metrics.jvm.FileDescriptorGaugeSet;
import com.spotify.metrics.jvm.GarbageCollectorMetricSet;
import com.spotify.metrics.jvm.MemoryUsageGaugeSet;
import com.spotify.metrics.jvm.ThreadStatesMetricSet;
import java.util.concurrent.TimeUnit;

public class JvmExample {
    private static final MetricId APP_PREFIX = MetricId.build((String[])new String[]{"jvm-example"});
    private static final SemanticMetricRegistry registry = new SemanticMetricRegistry();

    public static void main(String[] args) throws Exception {
        registry.register(MetricId.build((String[])new String[]{"jvm-memory"}), (Metric)new MemoryUsageGaugeSet());
        registry.register(MetricId.build((String[])new String[]{"jvm-gc"}), (Metric)new GarbageCollectorMetricSet());
        registry.register(MetricId.build((String[])new String[]{"jvm-threads"}), (Metric)new ThreadStatesMetricSet());
        registry.register(MetricId.build((String[])new String[]{"jvm-cpu"}), (Metric)CpuGaugeSet.create());
        registry.register(MetricId.build((String[])new String[]{"jvm-fd-ratio"}), (Metric)new FileDescriptorGaugeSet());
        FastForwardReporter reporter = FastForwardReporter.forRegistry((SemanticMetricRegistry)registry).prefix(APP_PREFIX).schedule(TimeUnit.SECONDS, 5L).build();
        reporter.start();
        System.out.println("Sending jvm metrics...");
        System.in.read();
        reporter.stop();
    }
}

