/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.metrics.example;

import com.codahale.metrics.Meter;
import com.spotify.metrics.core.MetricId;
import com.spotify.metrics.core.SemanticMetricRegistry;
import com.spotify.metrics.ffwd.FastForwardReporter;
import java.util.concurrent.TimeUnit;

public class DynamicMetricExample {
    private static final MetricId APP_PREFIX = MetricId.build((String[])new String[]{"dynamic-metric-example"});
    private static final SemanticMetricRegistry registry = new SemanticMetricRegistry();

    public static void main(String[] args) throws Exception {
        MetricId base = MetricId.build((String[])new String[]{"current-thing"});
        FastForwardReporter reporter = FastForwardReporter.forRegistry((SemanticMetricRegistry)registry).prefix(APP_PREFIX).schedule(TimeUnit.SECONDS, 5L).build();
        reporter.start();
        String[] things = new String[]{"shoe", "bucket", "chair"};
        for (int i = 0; i < things.length; ++i) {
            String thing = things[i];
            Thread.sleep(1000L);
            Meter meter = registry.meter(base.tagged("thing", thing).tagged("index", Integer.toString(i)));
            meter.mark((long)(10 * i));
        }
        System.out.println("Sending dynamic metrics...");
        System.in.read();
        reporter.stop();
    }
}

