/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.metrics.example;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.Timer;
import com.spotify.metrics.core.MetricId;
import com.spotify.metrics.core.SemanticMetricRegistry;
import com.spotify.metrics.ffwd.FastForwardReporter;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class MetricTypesExample {
    private static final MetricId APP_PREFIX = MetricId.build((String[])new String[]{"metric-types-example"});
    private static final SemanticMetricRegistry registry = new SemanticMetricRegistry();

    private static void reportGauge() {
        registry.register(APP_PREFIX.tagged("what", "job-queue-length"), (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                int queueLength = 10;
                return 10;
            }
        });
    }

    private static void reportCounter() {
        Counter counter = registry.counter(APP_PREFIX.tagged("what", "job-count"));
        counter.inc();
        counter.inc();
        counter.dec();
    }

    private static void reportMeter() {
        Meter meter = registry.meter(APP_PREFIX.tagged("what", "incoming-requests").tagged("endpoint", "/v1/list"));
        meter.mark();
    }

    private static void reportHistogram() {
        Histogram histogram = registry.histogram(APP_PREFIX.tagged("what", "response-size").tagged("endpoint", "/v1/content"));
        long responseSize = 1000L;
        histogram.update(1000L);
    }

    private static void reportTimer() {
        Timer timer = registry.timer(APP_PREFIX.tagged("what", "incoming-request-time").tagged("endpoint", "/v1/get_stuff"));
        Timer.Context context = timer.time();
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        context.stop();
    }

    public static void main(String[] args) throws IOException {
        FastForwardReporter reporter = FastForwardReporter.forRegistry((SemanticMetricRegistry)registry).schedule(TimeUnit.SECONDS, 5L).build();
        reporter.start();
        MetricTypesExample.reportGauge();
        MetricTypesExample.reportCounter();
        MetricTypesExample.reportMeter();
        MetricTypesExample.reportHistogram();
        MetricTypesExample.reportTimer();
        System.out.println("Sending metrics...");
        System.in.read();
        reporter.stop();
    }
}

