/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.missinglink.maven;

import com.google.common.base.Joiner;
import com.google.common.base.Stopwatch;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.io.Files;
import com.spotify.missinglink.ArtifactLoader;
import com.spotify.missinglink.ClassLoader;
import com.spotify.missinglink.Conflict;
import com.spotify.missinglink.ConflictChecker;
import com.spotify.missinglink.Java9ModuleLoader;
import com.spotify.missinglink.datamodel.ArtifactBuilder;
import com.spotify.missinglink.datamodel.ArtifactName;
import com.spotify.missinglink.datamodel.ClassTypeDescriptor;
import com.spotify.missinglink.datamodel.DeclaredClass;
import com.spotify.missinglink.datamodel.Dependency;
import com.spotify.missinglink.maven.IgnoredPackage;
import com.spotify.missinglink.maven.MavenArtifactName;
import com.spotify.missinglink.maven.Scope;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Exclusion;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="check", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, defaultPhase=LifecyclePhase.PROCESS_CLASSES)
public class CheckMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(property="missinglink.skip")
    protected boolean skip = false;
    @Parameter(defaultValue="false", property="failOnConflicts")
    protected boolean failOnConflicts;
    @Parameter(property="verbose", defaultValue="false")
    protected boolean verbose;
    @Parameter(property="missinglink.includeCategories")
    protected List<String> includeCategories = new ArrayList<String>();
    @Parameter(property="missinglink.includeScopes", defaultValue="compile,test")
    protected List<Scope> includeScopes = new ArrayList<Scope>();
    @Parameter
    protected List<Exclusion> excludeDependencies = new ArrayList<Exclusion>();
    @Parameter
    protected List<IgnoredPackage> ignoreSourcePackages = new ArrayList<IgnoredPackage>();
    @Parameter
    protected List<IgnoredPackage> ignoreDestinationPackages = new ArrayList<IgnoredPackage>();
    @Parameter(property="misslink.bootClasspath")
    protected String bootClasspath;
    protected ArtifactLoader artifactLoader = new ArtifactLoader();
    protected ConflictChecker conflictChecker = new ConflictChecker();

    public void execute() throws MojoExecutionException, MojoFailureException {
        Set<Conflict.ConflictCategory> categoriesToInclude;
        if (this.skip) {
            this.getLog().info((CharSequence)"skipping plugin execution since missinglink.skip=true");
            return;
        }
        Consumer<String> log = this.verbose ? msg -> this.getLog().info((CharSequence)msg) : msg -> this.getLog().debug((CharSequence)msg);
        this.logDependencies(log);
        try {
            categoriesToInclude = this.includeCategories.stream().map(Conflict.ConflictCategory::valueOf).collect(Collectors.toSet());
        }
        catch (IllegalArgumentException e) {
            this.getLog().error((Throwable)e);
            throw new MojoExecutionException("Invalid value(s) for 'includeCategories': " + this.includeCategories + ". Valid choices are: " + Joiner.on((String)", ").join((Object[])Conflict.ConflictCategory.values()));
        }
        Collection<Conflict> conflicts = this.loadArtifactsAndCheckConflicts();
        int initialCount = conflicts.size();
        conflicts = this.filterConflicts(conflicts, categoriesToInclude);
        if (conflicts.isEmpty()) {
            this.getLog().info((CharSequence)"No conflicts found");
        } else {
            String warning = conflicts.size() + " conflicts found!";
            if (initialCount != conflicts.size()) {
                warning = warning + " (" + initialCount + " conflicts were found before applying filters)";
            }
            this.getLog().warn((CharSequence)warning);
            this.outputConflicts(conflicts);
            if (this.failOnConflicts) {
                String message = conflicts.size() + " class/method conflicts found between source code in this project and the runtime dependencies from the Maven project. Look above for specific descriptions of each conflict";
                throw new MojoFailureException(message);
            }
        }
    }

    private void logDependencies(Consumer<String> log) {
        ArrayList mavenDependencies = Lists.newArrayList((Iterable)this.project.getArtifacts());
        Collections.sort(mavenDependencies, Ordering.usingToString());
        log.accept("Project has " + mavenDependencies.size() + " dependencies");
        mavenDependencies.stream().map(art -> "Dependency: " + art.toString()).forEach(log);
    }

    private Collection<Conflict> filterConflicts(Collection<Conflict> conflicts, Set<Conflict.ConflictCategory> categoriesToInclude) {
        Predicate<Conflict> predicate;
        if (!categoriesToInclude.isEmpty()) {
            this.getLog().debug((CharSequence)("Only including conflicts from categories: " + Joiner.on((String)", ").join(categoriesToInclude)));
            conflicts = this.filterConflictsBy(conflicts, categoriesToInclude::contains, num -> num + " conflicts removed based on includeCategories=" + Joiner.on((String)", ").join(this.includeCategories) + ". Run plugin again without the 'includeCategories' parameter to see all conflicts that were found.");
        }
        if (!this.ignoreSourcePackages.isEmpty()) {
            this.getLog().debug((CharSequence)("Ignoring source packages: " + Joiner.on((String)", ").join(this.ignoreSourcePackages)));
            predicate = conflict -> !this.packageIsIgnored(this.ignoreSourcePackages, conflict.dependency().fromClass());
            conflicts = this.filterConflictsBy(conflicts, predicate, num -> num + " conflicts found in ignored source packages. Run plugin again without the 'ignoreSourcePackages' parameter to see all conflicts that were found.");
        }
        if (!this.ignoreDestinationPackages.isEmpty()) {
            this.getLog().debug((CharSequence)("Ignoring destination packages: " + Joiner.on((String)", ").join(this.ignoreDestinationPackages)));
            predicate = conflict -> !this.packageIsIgnored(this.ignoreDestinationPackages, conflict.dependency().targetClass());
            conflicts = this.filterConflictsBy(conflicts, predicate, num -> num + " conflicts found in ignored destination packages. Run plugin again without the 'ignoreDestinationPackages' parameter to see all conflicts that were found.");
        }
        return conflicts;
    }

    private Collection<Conflict> filterConflictsBy(Collection<Conflict> conflicts, Predicate<Conflict> predicate, Function<Integer, String> logMessage) {
        Set<Conflict> filteredConflicts = conflicts.stream().filter(predicate).collect(Collectors.toSet());
        if (filteredConflicts.size() != conflicts.size()) {
            int diff = conflicts.size() - filteredConflicts.size();
            this.getLog().warn((CharSequence)logMessage.apply(diff));
        }
        return filteredConflicts;
    }

    private boolean packageIsIgnored(Collection<IgnoredPackage> ignoredPackages, ClassTypeDescriptor classTypeDescriptor) {
        String className = classTypeDescriptor.getClassName().replace('/', '.');
        String conflictPackageName = className.substring(0, className.lastIndexOf(46));
        return ignoredPackages.stream().anyMatch(p -> {
            String ignoredPackageName = p.getPackage();
            return conflictPackageName.equals(ignoredPackageName) || p.isIgnoreSubpackages() && conflictPackageName.startsWith(ignoredPackageName + ".");
        });
    }

    private Collection<Conflict> loadArtifactsAndCheckConflicts() {
        List<Artifact> projectDeps = this.project.getArtifacts().stream().filter(artifact -> this.includeScopes.contains((Object)Scope.valueOf(artifact.getScope()))).collect(Collectors.toList());
        this.getLog().debug((CharSequence)("project dependencies: " + projectDeps.stream().map(this::mavenCoordinates).collect(Collectors.toList())));
        Stopwatch stopwatch = Stopwatch.createStarted();
        ImmutableList<com.spotify.missinglink.datamodel.Artifact> runtimeProjectArtifacts = this.constructArtifacts(projectDeps);
        stopwatch.stop();
        this.getLog().debug((CharSequence)("constructing runtime artifacts took: " + CheckMojo.asMillis(stopwatch) + " ms"));
        String bootstrapClasspath = this.bootClassPathToUse();
        stopwatch.reset().start();
        List<com.spotify.missinglink.datamodel.Artifact> bootstrapArtifacts = this.loadBootstrapArtifacts(bootstrapClasspath);
        stopwatch.stop();
        this.getLog().debug((CharSequence)("constructing bootstrap artifacts took: " + CheckMojo.asMillis(stopwatch) + " ms"));
        ImmutableList allArtifacts = ImmutableList.builder().addAll(runtimeProjectArtifacts).addAll(bootstrapArtifacts).build();
        ImmutableList runtimeArtifactsAfterExclusions = ImmutableList.copyOf((Collection)runtimeProjectArtifacts.stream().filter(artifact -> !this.isExcluded((com.spotify.missinglink.datamodel.Artifact)artifact)).collect(Collectors.toSet()));
        com.spotify.missinglink.datamodel.Artifact projectArtifact = this.toArtifact(this.project.getBuild().getOutputDirectory());
        if (projectArtifact.classes().isEmpty()) {
            this.getLog().warn((CharSequence)"No classes found in project build directory - did you run 'mvn compile' first?");
        }
        stopwatch.reset().start();
        this.getLog().debug((CharSequence)("Checking for conflicts starting from " + projectArtifact.name().name()));
        this.getLog().debug((CharSequence)"Artifacts included in the project: ");
        for (com.spotify.missinglink.datamodel.Artifact artifact2 : runtimeArtifactsAfterExclusions) {
            this.getLog().debug((CharSequence)("    " + artifact2.name().name()));
        }
        ImmutableList conflicts = this.conflictChecker.check(projectArtifact, (List)runtimeArtifactsAfterExclusions, (List)allArtifacts);
        stopwatch.stop();
        this.getLog().debug((CharSequence)("conflict checking took: " + CheckMojo.asMillis(stopwatch) + " ms"));
        this.getLog().debug((CharSequence)(conflicts.size() + " total conflicts found"));
        return conflicts;
    }

    private List<com.spotify.missinglink.datamodel.Artifact> loadBootstrapArtifacts(String bootstrapClasspath) {
        if (bootstrapClasspath == null) {
            return Java9ModuleLoader.getJava9ModuleArtifacts((s, ex) -> this.getLog().warn((CharSequence)s, (Throwable)ex));
        }
        return this.constructArtifacts((Iterable<String>)Arrays.asList(bootstrapClasspath.split(System.getProperty("path.separator"))));
    }

    private String bootClassPathToUse() {
        if (this.bootClasspath != null) {
            this.getLog().debug((CharSequence)("using configured boot classpath: " + this.bootClasspath));
            return this.bootClasspath;
        }
        String bootClasspath = System.getProperty("sun.boot.class.path");
        this.getLog().debug((CharSequence)("derived bootclasspath: " + bootClasspath));
        return bootClasspath;
    }

    private String mavenCoordinates(Artifact dep) {
        return dep.getGroupId() + ":" + dep.getArtifactId() + ":" + dep.getVersion() + ":" + dep.getScope();
    }

    private boolean isExcluded(com.spotify.missinglink.datamodel.Artifact artifact) {
        if (artifact.name() instanceof MavenArtifactName) {
            MavenArtifactName name = (MavenArtifactName)artifact.name();
            return this.excludeDependencies.stream().anyMatch(excl -> excl.getGroupId().equals(name.groupId()) && excl.getArtifactId().equals(name.artifactId()));
        }
        return false;
    }

    private static long asMillis(Stopwatch stopwatch) {
        return stopwatch.elapsed(TimeUnit.MILLISECONDS);
    }

    private void outputConflicts(Collection<Conflict> conflicts) {
        EnumMap<Conflict.ConflictCategory, String> descriptions = new EnumMap<Conflict.ConflictCategory, String>(Conflict.ConflictCategory.class);
        descriptions.put(Conflict.ConflictCategory.CLASS_NOT_FOUND, "Class being called not found");
        descriptions.put(Conflict.ConflictCategory.METHOD_SIGNATURE_NOT_FOUND, "Method being called not found");
        Map<Conflict.ConflictCategory, List<Conflict>> byCategory = conflicts.stream().collect(Collectors.groupingBy(Conflict::category));
        byCategory.forEach((category, conflictsInCategory) -> {
            String desc = descriptions.getOrDefault(category, category.name().replace('_', ' '));
            this.getLog().warn((CharSequence)"");
            this.getLog().warn((CharSequence)("Category: " + desc));
            Map<ArtifactName, List<Conflict>> byArtifact = conflictsInCategory.stream().collect(Collectors.groupingBy(Conflict::usedBy));
            byArtifact.forEach((artifactName, conflictsInArtifact) -> {
                this.getLog().warn((CharSequence)("  In artifact: " + artifactName.name()));
                Map<ClassTypeDescriptor, List<Conflict>> byClassName = conflictsInArtifact.stream().collect(Collectors.groupingBy(c -> c.dependency().fromClass()));
                byClassName.forEach((classDesc, conflictsInClass) -> {
                    this.getLog().warn((CharSequence)("    In class: " + classDesc.toString()));
                    conflictsInClass.stream().forEach(c -> {
                        Dependency dep = c.dependency();
                        this.getLog().warn((CharSequence)("      In method:  " + dep.fromMethod().prettyWithoutReturnType() + this.optionalLineNumber(dep.fromLineNumber())));
                        this.getLog().warn((CharSequence)("      " + dep.describe()));
                        this.getLog().warn((CharSequence)("      Problem: " + c.reason()));
                        if (c.existsIn() != ConflictChecker.UNKNOWN_ARTIFACT_NAME) {
                            this.getLog().warn((CharSequence)("      Found in: " + c.existsIn().name()));
                        }
                        this.getLog().warn((CharSequence)"      --------");
                    });
                });
            });
        });
    }

    private String optionalLineNumber(int lineNumber) {
        return lineNumber != 0 ? ":" + lineNumber : "";
    }

    private com.spotify.missinglink.datamodel.Artifact toArtifact(String outputDirectory) {
        return new ArtifactBuilder().name(new ArtifactName("project")).classes(Files.fileTreeTraverser().breadthFirstTraversal((Object)new File(outputDirectory)).filter(f -> f.getName().endsWith(".class")).transform(this::loadClass).uniqueIndex(DeclaredClass::className)).build();
    }

    private DeclaredClass loadClass(File f) {
        try {
            return ClassLoader.load((InputStream)new FileInputStream(f));
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private ImmutableList<com.spotify.missinglink.datamodel.Artifact> constructArtifacts(Iterable<String> entries) {
        List list = StreamSupport.stream(entries.spliterator(), false).distinct().filter(this::filterValidClasspathEntries).map(this::filepathToArtifact).collect(Collectors.toList());
        return ImmutableList.copyOf(list);
    }

    private boolean filterValidClasspathEntries(String element) {
        return this.filterValid(new File(element));
    }

    private boolean filterValid(File file) {
        if (file == null) {
            return false;
        }
        boolean isJarFile = file.isFile() && file.getName().endsWith(".jar");
        boolean isClassDirectory = file.isDirectory();
        return isClassDirectory || isJarFile;
    }

    private boolean filterValidClasspathEntries(Artifact artifact) {
        return this.filterValid(artifact.getFile());
    }

    private ImmutableList<com.spotify.missinglink.datamodel.Artifact> constructArtifacts(List<Artifact> mavenDeps) {
        List list = mavenDeps.stream().filter(this::filterValidClasspathEntries).map(this::mavenDepToArtifact).collect(Collectors.toList());
        return ImmutableList.copyOf(list);
    }

    private com.spotify.missinglink.datamodel.Artifact filepathToArtifact(String path) {
        this.getLog().debug((CharSequence)("loading artifact for path: " + path));
        return this.doArtifactLoad(() -> this.artifactLoader.load(new File(path)));
    }

    private com.spotify.missinglink.datamodel.Artifact mavenDepToArtifact(Artifact dep) {
        File path = dep.getFile();
        this.getLog().debug((CharSequence)("loading artifact for path: " + path));
        MavenArtifactName name = new MavenArtifactName(dep.getGroupId(), dep.getArtifactId(), dep.getVersion());
        return this.doArtifactLoad(() -> this.artifactLoader.load((ArtifactName)name, path));
    }

    private com.spotify.missinglink.datamodel.Artifact doArtifactLoad(ArtifactSupplier supplier) {
        com.spotify.missinglink.datamodel.Artifact artifact;
        Stopwatch stopwatch = Stopwatch.createStarted();
        try {
            artifact = supplier.load();
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
        stopwatch.stop();
        this.getLog().debug((CharSequence)("artifact loading took " + CheckMojo.asMillis(stopwatch) + " ms"));
        return artifact;
    }

    @FunctionalInterface
    private static interface ArtifactSupplier {
        public com.spotify.missinglink.datamodel.Artifact load() throws IOException;
    }
}

