/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.scio.avro.types;

import com.google.common.base.Charsets;
import com.google.common.hash.Hashing;
import com.google.common.io.Files;
import com.spotify.scio.avro.types.MacroUtil$;
import com.spotify.scio.avro.types.SchemaUtil$;
import com.spotify.scio.avro.types.TypeProvider$;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileStream;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.io.DatumReader;
import org.apache.beam.sdk.io.FileSystems;
import org.apache.beam.sdk.io.fs.MatchResult;
import org.apache.beam.sdk.io.fs.ResourceId;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.Tuple9;
import scala.UninitializedFieldError;
import scala.collection.GenTraversable;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.api.Constants;
import scala.reflect.api.Exprs;
import scala.reflect.api.Names;
import scala.reflect.api.Trees;
import scala.reflect.macros.blackbox.Context;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.sys.package$;
import scala.util.Try;
import scala.util.Try$;
import scala.util.matching.Regex;

public final class TypeProvider$ {
    public static final TypeProvider$ MODULE$;
    private final Logger logger;
    private volatile boolean bitmap$init$0;

    static {
        new TypeProvider$();
    }

    private Logger logger() {
        if (this.bitmap$init$0) {
            return this.logger;
        }
        throw new UninitializedFieldError("Uninitialized field: TypeProvider.scala: 45");
    }

    public Exprs.Expr<Object> schemaImpl(Context c, Seq<Exprs.Expr<Object>> annottees) {
        Seq<Exprs.Expr<Object>> seq = annottees;
        String schemaString = (String)this.extractStrings(c, "Missing schema").head();
        Schema schema = new Schema.Parser().parse(schemaString);
        return this.schemaToType(c, schema, seq);
    }

    public Exprs.Expr<Object> schemaFileImpl(Context c, Seq<Exprs.Expr<Object>> annottees) {
        Seq<Exprs.Expr<Object>> seq = annottees;
        String file = ((String)this.extractStrings(c, "Missing file").head()).trim().replaceAll("\n", "");
        Try fileInputStream = Try$.MODULE$.apply((Function0)new Serializable(file){
            public static final long serialVersionUID = 0L;
            private final String file$1;

            public final InputStream apply() {
                return TypeProvider$.MODULE$.com$spotify$scio$avro$types$TypeProvider$$readFromFileSystem(this.file$1);
            }
            {
                this.file$1 = file$1;
            }
        }).recover((PartialFunction)new Serializable(file){
            public static final long serialVersionUID = 0L;
            private final String file$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                Object object = A1 != null ? TypeProvider$.MODULE$.com$spotify$scio$avro$types$TypeProvider$$readFromUrl(this.file$1) : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = throwable != null;
                return bl;
            }
            {
                this.file$1 = file$1;
            }
        });
        if (fileInputStream.isFailure()) {
            throw new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error reading schema file ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{file})));
        }
        Schema schema = new Schema.Parser().parse((InputStream)fileInputStream.get());
        return this.schemaToType(c, schema, seq);
    }

    public InputStream com$spotify$scio$avro$types$TypeProvider$$readFromFileSystem(String file) {
        MatchResult files = FileSystems.match((String)file);
        Predef$.MODULE$.assume(files.metadata().size() == 1, (Function0)new Serializable(file, files){
            public static final long serialVersionUID = 0L;
            private final String file$2;
            private final MatchResult files$1;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"File argument '", "' must match exactly one file. "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.file$2}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"We've matched ", " files."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.files$1.metadata().size())}))).toString();
            }
            {
                this.file$2 = file$2;
                this.files$1 = files$1;
            }
        });
        return Channels.newInputStream(FileSystems.open((ResourceId)((MatchResult.Metadata)files.metadata().get(0)).resourceId()));
    }

    public InputStream com$spotify$scio$avro$types$TypeProvider$$readFromUrl(String file) {
        return new URL(file).openStream();
    }

    public Exprs.Expr<Object> pathImpl(Context c, Seq<Exprs.Expr<Object>> annottees) {
        Seq<Exprs.Expr<Object>> seq = annottees;
        String path = (String)this.extractStrings(c, "Missing path").head();
        Schema schema = this.schemaFromGcsFolder(path);
        return this.schemaToType(c, schema, seq);
    }

    private Schema schemaFromGcsFolder(String path) {
        DataFileStream reader;
        Option option;
        block9: {
            Some some;
            String p;
            block8: {
                block7: {
                    p = path.trim().replaceAll("\n", "");
                    this.emitWarningIfGcsGlobPath(p);
                    option = this.matchResult$1(FileSystems.match((String)p));
                    if (!(option instanceof Some)) break block7;
                    Some some2 = (Some)option;
                    ResourceId x = (ResourceId)some2.x();
                    some = new Some((Object)x);
                    break block8;
                }
                if (!None$.MODULE$.equals(option)) break block9;
                some = this.matchResult$1(FileSystems.match((String)p.replaceFirst("/?$", "/*.avro")));
            }
            Some r = some;
            Predef$.MODULE$.require(r.isDefined(), (Function0)new Serializable(p){
                public static final long serialVersionUID = 0L;
                private final String p$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to match Avro file from path '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.p$1}));
                }
                {
                    this.p$1 = p$1;
                }
            });
            ResourceId avroFile = (ResourceId)r.get();
            this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Reading Avro schema from file '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{avroFile})));
            reader = null;
            reader = new DataFileStream(Channels.newInputStream(FileSystems.open((ResourceId)avroFile)), (DatumReader)new GenericDatumReader());
            return reader.getSchema();
        }
        throw new MatchError((Object)option);
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    private void emitWarningIfGcsGlobPath(String path) {
        String string;
        Regex gcsGlobPathPattern = new StringOps(Predef$.MODULE$.augmentString("(gs://[^\\[*?]*)[\\[*?].*")).r();
        Option option = gcsGlobPathPattern.unapplySeq((CharSequence)(string = path));
        if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0) {
            String pathPrefix = (String)((LinearSeqOptimized)option.get()).apply(0);
            this.logger().warn(new StringBuilder().append((Object)"Matching GCS wildcards may be inefficient if there are many files that ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"share the prefix '", "'."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{pathPrefix}))).toString());
            this.logger().warn(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Macro expansion will be slow and might not even finish before hitting "})).s((Seq)Nil$.MODULE$)).append((Object)"compiler GC limit.").toString());
            this.logger().warn("Consider using a more specific path glob.");
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public Exprs.Expr<Object> toSchemaImpl(Context c, Seq<Exprs.Expr<Object>> annottees) {
        Object object;
        Option<Tuple9<Trees.ModifiersApi, Names.TypeNameApi, List<Trees.TypeDefApi>, Trees.ModifiersApi, List<Trees.ValDefApi>, List<Trees.TreeApi>, List<Trees.TreeApi>, Trees.ValDefApi, List<Trees.TreeApi>>> option;
        List list;
        Some some;
        Seq<Exprs.Expr<Object>> seq = annottees;
        this.checkMacroEnclosed(c);
        Seq seq2 = (Seq)seq.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Trees.TreeApi apply(Exprs.Expr<Object> x$2) {
                return x$2.tree();
            }
        }, Seq$.MODULE$.canBuildFrom());
        if (seq2 instanceof List && !(some = List$.MODULE$.unapplySeq((Seq)(list = (List)seq2))).isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(1) == 0 && !(option = new Object(c){
            private final Context c$1;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public Option<Tuple9<Trees.ModifiersApi, Names.TypeNameApi, List<Trees.TypeDefApi>, Trees.ModifiersApi, List<Trees.ValDefApi>, List<Trees.TreeApi>, List<Trees.TreeApi>, Trees.ValDefApi, List<Trees.TreeApi>>> unapply(Object tree) {
                Object object = tree;
                Option option = this.c$1.universe().TreeTag().unapply(object);
                if (option.isEmpty()) return None$.MODULE$;
                Trees.TreeApi treeApi = (Trees.TreeApi)option.get();
                Option option2 = this.c$1.universe().internal().reificationSupport().SyntacticClassDef().unapply(treeApi);
                if (option2.isEmpty()) return None$.MODULE$;
                Trees.ModifiersApi qq$3f751485$macro$63 = (Trees.ModifiersApi)((Tuple9)option2.get())._1();
                Names.TypeNameApi qq$3f751485$macro$64 = (Names.TypeNameApi)((Tuple9)option2.get())._2();
                List qq$3f751485$macro$65 = (List)((Tuple9)option2.get())._3();
                Trees.ModifiersApi qq$3f751485$macro$66 = (Trees.ModifiersApi)((Tuple9)option2.get())._4();
                List list = (List)((Tuple9)option2.get())._5();
                List qq$3f751485$macro$68 = (List)((Tuple9)option2.get())._6();
                List qq$3f751485$macro$69 = (List)((Tuple9)option2.get())._7();
                Trees.ValDefApi qq$3f751485$macro$70 = (Trees.ValDefApi)((Tuple9)option2.get())._8();
                List qq$3f751485$macro$71 = (List)((Tuple9)option2.get())._9();
                if (!(list instanceof .colon.colon)) return None$.MODULE$;
                .colon.colon colon2 = (.colon.colon)list;
                List qq$3f751485$macro$67 = (List)colon2.head();
                List list2 = colon2.tl$1();
                if (!Nil$.MODULE$.equals(list2)) return None$.MODULE$;
                return new Some((Object)new Tuple9((Object)qq$3f751485$macro$63, (Object)qq$3f751485$macro$64, (Object)qq$3f751485$macro$65, (Object)qq$3f751485$macro$66, (Object)qq$3f751485$macro$67, (Object)qq$3f751485$macro$68, (Object)qq$3f751485$macro$69, (Object)qq$3f751485$macro$70, (Object)qq$3f751485$macro$71));
            }
            {
                this.c$1 = c$1;
            }
        }.unapply(object = ((LinearSeqOptimized)some.get()).apply(0))).isEmpty()) {
            Trees.ModifiersApi mods = (Trees.ModifiersApi)((Tuple9)option.get())._1();
            Names.TypeNameApi name = (Names.TypeNameApi)((Tuple9)option.get())._2();
            List fields = (List)((Tuple9)option.get())._5();
            List parents = (List)((Tuple9)option.get())._7();
            List body = (List)((Tuple9)option.get())._9();
            if (mods.hasFlag(c.universe().Flag().CASE())) {
                Set set = ((TraversableOnce)parents.map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply(Trees.TreeApi x$3) {
                        return x$3.toString();
                    }
                }, List$.MODULE$.canBuildFrom())).toSet();
                GenTraversable genTraversable = Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"scala.Product", "scala.Serializable"}));
                if (!(set != null ? !set.equals(genTraversable) : genTraversable != null)) {
                    Trees.TreeApi treeApi;
                    List<Trees.TreeApi> docs = this.getRecordDocs(c, (Seq<Trees.TreeApi>)list);
                    Seq docMethod = Option$.MODULE$.option2Iterable(docs.headOption().map((Function1)new Serializable(c){
                        public static final long serialVersionUID = 0L;
                        private final Context c$1;

                        public final Trees.DefDefApi apply(Trees.TreeApi d) {
                            return this.c$1.universe().internal().reificationSupport().SyntacticDefDef().apply(this.c$1.universe().Modifiers().apply(this.c$1.universe().internal().reificationSupport().FlagsRepr().apply(2L), (Names.NameApi)this.c$1.universe().TypeName().apply(""), (List)Nil$.MODULE$), this.c$1.universe().TermName().apply("doc"), (List)Nil$.MODULE$, (List)Nil$.MODULE$, (Trees.TreeApi)this.c$1.universe().internal().reificationSupport().SyntacticSelectType().apply((Trees.TreeApi)this.c$1.universe().internal().reificationSupport().SyntacticSelectTerm().apply((Trees.TreeApi)this.c$1.universe().internal().reificationSupport().SyntacticSelectTerm().apply((Trees.TreeApi)this.c$1.universe().internal().reificationSupport().SyntacticTermIdent().apply(this.c$1.universe().TermName().apply("_root_"), false), this.c$1.universe().TermName().apply("java")), this.c$1.universe().TermName().apply("lang")), this.c$1.universe().TypeName().apply("String")), d);
                        }
                        {
                            this.c$1 = c$1;
                        }
                    })).toSeq();
                    Seq docTrait = (Seq)docMethod.map((Function1)new Serializable(c){
                        public static final long serialVersionUID = 0L;
                        private final Context c$1;

                        public final Trees.SelectApi apply(Trees.DefDefApi x$4) {
                            return this.c$1.universe().internal().reificationSupport().SyntacticSelectType().apply(MacroUtil$.MODULE$.p(this.c$1, MacroUtil$.MODULE$.ScioAvroType()), this.c$1.universe().TypeName().apply("HasAvroDoc"));
                        }
                        {
                            this.c$1 = c$1;
                        }
                    }, Seq$.MODULE$.canBuildFrom());
                    Seq fnTrait = fields.size() <= 22 ? (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Trees.TreeApi[]{c.universe().internal().reificationSupport().SyntacticAppliedType().apply((Trees.TreeApi)c.universe().internal().reificationSupport().SyntacticTypeIdent().apply(c.universe().TypeName().apply(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Function", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)fields.size())})))), (List)((List)fields.map((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final Trees.TreeApi apply(Trees.ValDefApi x$5) {
                            return (Trees.TreeApi)x$5.children().head();
                        }
                    }, List$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Trees.IdentApi[]{c.universe().internal().reificationSupport().SyntacticTypeIdent().apply(name)})), List$.MODULE$.canBuildFrom()))})) : (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
                    Seq schemaMethod = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Trees.DefDefApi[]{c.universe().internal().reificationSupport().SyntacticDefDef().apply(c.universe().Modifiers().apply(c.universe().internal().reificationSupport().FlagsRepr().apply(2L), (Names.NameApi)c.universe().TypeName().apply(""), (List)Nil$.MODULE$), c.universe().TermName().apply("schema"), (List)Nil$.MODULE$, (List)Nil$.MODULE$, (Trees.TreeApi)c.universe().internal().reificationSupport().SyntacticSelectType().apply(MacroUtil$.MODULE$.p(c, MacroUtil$.MODULE$.ApacheAvro()), c.universe().TypeName().apply("Schema")), c.universe().internal().reificationSupport().SyntacticTypeApplied().apply((Trees.TreeApi)c.universe().internal().reificationSupport().SyntacticSelectTerm().apply(MacroUtil$.MODULE$.p(c, MacroUtil$.MODULE$.ScioAvroType()), c.universe().TermName().apply("schemaOf")), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Trees.IdentApi[]{c.universe().internal().reificationSupport().SyntacticTypeIdent().apply(name)}))))}));
                    Trees.TreeApi caseClassTree = this.caseClass(c, mods, name, (Seq<Trees.TreeApi>)fields, (Seq<Trees.TreeApi>)body);
                    if (this.shouldDumpClassesForPlugin()) {
                        this.dumpCodeForScalaPlugin(c, (Seq<Trees.TreeApi>)((Seq)Seq$.MODULE$.empty()), caseClassTree, name.toString());
                    }
                    Trees.TreeApi r = treeApi = c.universe().internal().reificationSupport().SyntacticBlock().apply(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Trees.TreeApi[]{caseClassTree, this.companion(c, name, (Seq<Trees.TreeApi>)((Seq)docTrait.$plus$plus((GenTraversableOnce)fnTrait, Seq$.MODULE$.canBuildFrom())), (Seq<Trees.TreeApi>)((Seq)schemaMethod.$plus$plus((GenTraversableOnce)docMethod, Seq$.MODULE$.canBuildFrom())), (Seq<Trees.TreeApi>)fields)})));
                    return c.Expr(r, c.universe().WeakTypeTag().Any());
                }
                throw c.abort(c.enclosingPosition(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid annotation, don't extend the case class ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{list})));
            }
        }
        throw c.abort(c.enclosingPosition(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid annotation ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{seq2})));
    }

    private Exprs.Expr<Object> schemaToType(Context c, Schema schema, Seq<Exprs.Expr<Object>> annottees) {
        Object object;
        Option<Tuple9<Trees.ModifiersApi, Names.TypeNameApi, List<Trees.TypeDefApi>, Trees.ModifiersApi, List<Trees.ValDefApi>, List<Trees.TreeApi>, List<Trees.TreeApi>, Trees.ValDefApi, List<Trees.TreeApi>>> option;
        List list;
        Some some;
        Seq<Exprs.Expr<Object>> seq = annottees;
        this.checkMacroEnclosed(c);
        Seq seq2 = (Seq)seq.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Trees.TreeApi apply(Exprs.Expr<Object> x$15) {
                return x$15.tree();
            }
        }, Seq$.MODULE$.canBuildFrom());
        if (seq2 instanceof List && !(some = List$.MODULE$.unapplySeq((Seq)(list = (List)seq2))).isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(1) == 0 && !(option = new Object(c){
            private final Context c$3;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public Option<Tuple9<Trees.ModifiersApi, Names.TypeNameApi, List<Trees.TypeDefApi>, Trees.ModifiersApi, List<Trees.ValDefApi>, List<Trees.TreeApi>, List<Trees.TreeApi>, Trees.ValDefApi, List<Trees.TreeApi>>> unapply(Object tree) {
                Object object = tree;
                Option option = this.c$3.universe().TreeTag().unapply(object);
                if (option.isEmpty()) return None$.MODULE$;
                Trees.TreeApi treeApi = (Trees.TreeApi)option.get();
                Option option2 = this.c$3.universe().internal().reificationSupport().SyntacticClassDef().unapply(treeApi);
                if (option2.isEmpty()) return None$.MODULE$;
                Trees.ModifiersApi qq$6d7eed21$macro$93 = (Trees.ModifiersApi)((Tuple9)option2.get())._1();
                Names.TypeNameApi qq$6d7eed21$macro$94 = (Names.TypeNameApi)((Tuple9)option2.get())._2();
                List qq$6d7eed21$macro$95 = (List)((Tuple9)option2.get())._3();
                Trees.ModifiersApi qq$6d7eed21$macro$96 = (Trees.ModifiersApi)((Tuple9)option2.get())._4();
                List list = (List)((Tuple9)option2.get())._5();
                List qq$6d7eed21$macro$98 = (List)((Tuple9)option2.get())._6();
                List qq$6d7eed21$macro$99 = (List)((Tuple9)option2.get())._7();
                Trees.ValDefApi qq$6d7eed21$macro$100 = (Trees.ValDefApi)((Tuple9)option2.get())._8();
                List qq$6d7eed21$macro$101 = (List)((Tuple9)option2.get())._9();
                if (!(list instanceof .colon.colon)) return None$.MODULE$;
                .colon.colon colon2 = (.colon.colon)list;
                List qq$6d7eed21$macro$97 = (List)colon2.head();
                List list2 = colon2.tl$1();
                if (!Nil$.MODULE$.equals(list2)) return None$.MODULE$;
                return new Some((Object)new Tuple9((Object)qq$6d7eed21$macro$93, (Object)qq$6d7eed21$macro$94, (Object)qq$6d7eed21$macro$95, (Object)qq$6d7eed21$macro$96, (Object)qq$6d7eed21$macro$97, (Object)qq$6d7eed21$macro$98, (Object)qq$6d7eed21$macro$99, (Object)qq$6d7eed21$macro$100, (Object)qq$6d7eed21$macro$101));
            }
            {
                this.c$3 = c$3;
            }
        }.unapply(object = ((LinearSeqOptimized)some.get()).apply(0))).isEmpty()) {
            Trees.ModifiersApi mods = (Trees.ModifiersApi)((Tuple9)option.get())._1();
            Names.TypeNameApi name = (Names.TypeNameApi)((Tuple9)option.get())._2();
            List cfields = (List)((Tuple9)option.get())._5();
            List parents = (List)((Tuple9)option.get())._7();
            if (BoxesRunTime.equals((Object)mods.flags(), (Object)c.universe().NoFlags())) {
                Set set = ((TraversableOnce)parents.map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply(Trees.TreeApi x$16) {
                        return x$16.toString();
                    }
                }, List$.MODULE$.canBuildFrom())).toSet();
                GenTraversable genTraversable = Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"scala.AnyRef"}));
                if (!(set != null ? !set.equals(genTraversable) : genTraversable != null)) {
                    if (cfields.nonEmpty()) {
                        throw c.abort(c.enclosingPosition(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid annotation, don't provide class fields ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{list})));
                    }
                    Tuple2 tuple2 = this.extractFields$1(name.toString(), schema, c);
                    if (tuple2 != null) {
                        Trees.TreeApi treeApi;
                        Tuple2 tuple22;
                        Seq fields = (Seq)tuple2._1();
                        Seq recordClasses = (Seq)tuple2._2();
                        Tuple2 tuple23 = tuple22 = new Tuple2((Object)fields, (Object)recordClasses);
                        Seq fields2 = (Seq)tuple23._1();
                        Seq recordClasses2 = (Seq)tuple23._2();
                        List<Trees.TreeApi> docs = this.getRecordDocs(c, (Seq<Trees.TreeApi>)list);
                        Seq docMethod = Option$.MODULE$.option2Iterable(docs.headOption().map((Function1)new Serializable(c){
                            public static final long serialVersionUID = 0L;
                            private final Context c$3;

                            public final Trees.DefDefApi apply(Trees.TreeApi d) {
                                return this.c$3.universe().internal().reificationSupport().SyntacticDefDef().apply(this.c$3.universe().Modifiers().apply(this.c$3.universe().internal().reificationSupport().FlagsRepr().apply(2L), (Names.NameApi)this.c$3.universe().TypeName().apply(""), (List)Nil$.MODULE$), this.c$3.universe().TermName().apply("doc"), (List)Nil$.MODULE$, (List)Nil$.MODULE$, (Trees.TreeApi)this.c$3.universe().internal().reificationSupport().SyntacticSelectType().apply((Trees.TreeApi)this.c$3.universe().internal().reificationSupport().SyntacticSelectTerm().apply((Trees.TreeApi)this.c$3.universe().internal().reificationSupport().SyntacticSelectTerm().apply((Trees.TreeApi)this.c$3.universe().internal().reificationSupport().SyntacticTermIdent().apply(this.c$3.universe().TermName().apply("_root_"), false), this.c$3.universe().TermName().apply("java")), this.c$3.universe().TermName().apply("lang")), this.c$3.universe().TypeName().apply("String")), d);
                            }
                            {
                                this.c$3 = c$3;
                            }
                        })).toSeq();
                        Seq docTrait = (Seq)docMethod.map((Function1)new Serializable(c){
                            public static final long serialVersionUID = 0L;
                            private final Context c$3;

                            public final Trees.SelectApi apply(Trees.DefDefApi x$18) {
                                return this.c$3.universe().internal().reificationSupport().SyntacticSelectType().apply(MacroUtil$.MODULE$.p(this.c$3, MacroUtil$.MODULE$.ScioAvroType()), this.c$3.universe().TypeName().apply("HasAvroDoc"));
                            }
                            {
                                this.c$3 = c$3;
                            }
                        }, Seq$.MODULE$.canBuildFrom());
                        Seq schemaMethod = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Trees.DefDefApi[]{c.universe().internal().reificationSupport().SyntacticDefDef().apply(c.universe().Modifiers().apply(c.universe().internal().reificationSupport().FlagsRepr().apply(2L), (Names.NameApi)c.universe().TypeName().apply(""), (List)Nil$.MODULE$), c.universe().TermName().apply("schema"), (List)Nil$.MODULE$, (List)Nil$.MODULE$, (Trees.TreeApi)c.universe().internal().reificationSupport().SyntacticSelectType().apply(MacroUtil$.MODULE$.p(c, MacroUtil$.MODULE$.ApacheAvro()), c.universe().TypeName().apply("Schema")), c.universe().internal().reificationSupport().SyntacticApplied().apply((Trees.TreeApi)c.universe().internal().reificationSupport().SyntacticSelectTerm().apply(c.universe().internal().reificationSupport().SyntacticNew().apply((List)Nil$.MODULE$, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Trees.SelectApi[]{c.universe().internal().reificationSupport().SyntacticSelectType().apply((Trees.TreeApi)c.universe().internal().reificationSupport().SyntacticSelectTerm().apply(MacroUtil$.MODULE$.p(c, MacroUtil$.MODULE$.ApacheAvro()), c.universe().TermName().apply("Schema")), c.universe().TypeName().apply("Parser"))})), (Trees.TreeApi)c.universe().noSelfType(), (List)Nil$.MODULE$), c.universe().TermName().apply("parse")), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new List[]{List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Trees.TreeApi[]{c.universe().Liftable().liftString().apply((Object)schema.toString())}))}))))}));
                        Trees.TreeApi caseClassTree = this.caseClass(c, mods, name, (Seq<Trees.TreeApi>)fields2, (Seq<Trees.TreeApi>)Nil$.MODULE$);
                        if (this.shouldDumpClassesForPlugin()) {
                            this.dumpCodeForScalaPlugin(c, (Seq<Trees.TreeApi>)recordClasses2, caseClassTree, name.toString());
                        }
                        Trees.TreeApi r = treeApi = c.universe().internal().reificationSupport().SyntacticBlock().apply((List)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Trees.TreeApi[]{caseClassTree, this.companion(c, name, (Seq<Trees.TreeApi>)docTrait, (Seq<Trees.TreeApi>)((Seq)schemaMethod.$plus$plus((GenTraversableOnce)docMethod, Seq$.MODULE$.canBuildFrom())), (Seq<Trees.TreeApi>)fields2)})).$plus$plus((GenTraversableOnce)recordClasses2.toList(), List$.MODULE$.canBuildFrom()));
                        return c.Expr(r, c.universe().WeakTypeTag().Any());
                    }
                    throw new MatchError((Object)tuple2);
                }
                throw c.abort(c.enclosingPosition(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid annotation, don't extend the case class ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{list})));
            }
        }
        throw c.abort(c.enclosingPosition(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid annotation ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{seq2})));
    }

    private Trees.TreeApi caseClass(Context c, Trees.ModifiersApi mods, Names.TypeNameApi name, Seq<Trees.TreeApi> fields, Seq<Trees.TreeApi> body) {
        Trees.ModifiersApi modifiersApi = mods;
        Names.TypeNameApi typeNameApi = name;
        Seq<Trees.TreeApi> seq = fields;
        Seq<Trees.TreeApi> seq2 = body;
        Trees.ModifiersApi caseMods = c.universe().Modifiers().apply(c.universe().Flag().CASE(), c.universe().typeNames().EMPTY(), modifiersApi.annotations());
        return c.universe().internal().reificationSupport().SyntacticClassDef().apply(caseMods, typeNameApi, (List)Nil$.MODULE$, c.universe().NoMods(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new List[]{seq.toList()})), (List)Nil$.MODULE$, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Trees.SelectApi[]{c.universe().internal().reificationSupport().SyntacticSelectType().apply(MacroUtil$.MODULE$.p(c, MacroUtil$.MODULE$.ScioAvroType()), c.universe().TypeName().apply("HasAvroAnnotation"))})), (Trees.TreeApi)c.universe().noSelfType(), seq2.toList());
    }

    private Trees.TreeApi companion(Context c, Names.TypeNameApi name, Seq<Trees.TreeApi> traits, Seq<Trees.TreeApi> methods, Seq<Trees.TreeApi> fields) {
        Seq seq;
        Names.TypeNameApi typeNameApi = name;
        Seq<Trees.TreeApi> seq2 = traits;
        Seq<Trees.TreeApi> seq3 = methods;
        Seq<Trees.TreeApi> seq4 = fields;
        if (seq4.size() > 1 && seq4.size() <= 22) {
            Object overrideFlag = seq2.exists((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Trees.TreeApi x$19) {
                    return x$19.toString().contains("Function");
                }
            }) ? c.universe().Flag().OVERRIDE() : c.universe().NoFlags();
            seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Trees.DefDefApi[]{c.universe().internal().reificationSupport().SyntacticDefDef().apply(c.universe().Modifiers().apply(c.universe().addFlagOps(c.universe().NoFlags()).$bar(overrideFlag), (Names.NameApi)c.universe().TypeName().apply(""), (List)Nil$.MODULE$), c.universe().TermName().apply("tupled"), (List)Nil$.MODULE$, (List)Nil$.MODULE$, (Trees.TreeApi)c.universe().internal().reificationSupport().SyntacticEmptyTypeTree().apply(), (Trees.TreeApi)c.universe().internal().reificationSupport().SyntacticSelectTerm().apply((Trees.TreeApi)c.universe().Typed().apply((Trees.TreeApi)c.universe().internal().reificationSupport().SyntacticSelectTerm().apply((Trees.TreeApi)c.universe().internal().reificationSupport().SyntacticTermIdent().apply(c.universe().TermName().apply(typeNameApi.toString()), false), c.universe().TermName().apply("apply")), (Trees.TreeApi)c.universe().internal().reificationSupport().SyntacticFunction().apply((List)Nil$.MODULE$, c.universe().EmptyTree())), c.universe().TermName().apply("tupled")))}));
        } else {
            seq = (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
        }
        Seq tupledMethod = seq;
        return c.universe().internal().reificationSupport().SyntacticObjectDef().apply(c.universe().NoMods(), c.universe().TermName().apply(typeNameApi.toString()), (List)Nil$.MODULE$, (List)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Trees.TreeApi[]{c.universe().internal().reificationSupport().SyntacticAppliedType().apply((Trees.TreeApi)c.universe().internal().reificationSupport().SyntacticSelectType().apply(MacroUtil$.MODULE$.p(c, MacroUtil$.MODULE$.ScioAvroType()), c.universe().TypeName().apply("HasAvroSchema")), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Trees.IdentApi[]{c.universe().internal().reificationSupport().SyntacticTypeIdent().apply(typeNameApi)})))})).$plus$plus((GenTraversableOnce)seq2.toList(), List$.MODULE$.canBuildFrom()), (Trees.TreeApi)c.universe().noSelfType(), (List)((List)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Trees.DefDefApi[]{c.universe().internal().reificationSupport().SyntacticDefDef().apply(c.universe().Modifiers().apply(c.universe().internal().reificationSupport().FlagsRepr().apply(2L), (Names.NameApi)c.universe().TypeName().apply(""), (List)Nil$.MODULE$), c.universe().TermName().apply("toPrettyString"), (List)Nil$.MODULE$, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new List[]{List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Trees.ValDefApi[]{c.universe().internal().reificationSupport().SyntacticValDef().apply(c.universe().Modifiers().apply(c.universe().internal().reificationSupport().FlagsRepr().apply(0x2002000L), (Names.NameApi)c.universe().TypeName().apply(""), (List)Nil$.MODULE$), c.universe().TermName().apply("indent"), (Trees.TreeApi)c.universe().internal().reificationSupport().SyntacticTypeIdent().apply(c.universe().TypeName().apply("Int")), (Trees.TreeApi)c.universe().Literal().apply(c.universe().Constant().apply((Object)BoxesRunTime.boxToInteger((int)0))))}))})), (Trees.TreeApi)c.universe().internal().reificationSupport().SyntacticTypeIdent().apply(c.universe().TypeName().apply("String")), c.universe().internal().reificationSupport().SyntacticApplied().apply((Trees.TreeApi)c.universe().internal().reificationSupport().SyntacticSelectTerm().apply(MacroUtil$.MODULE$.p(c, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".types.SchemaUtil"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{MacroUtil$.MODULE$.ScioAvro()}))), c.universe().TermName().apply("toPrettyString")), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new List[]{List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Trees.RefTreeApi[]{c.universe().internal().reificationSupport().SyntacticSelectTerm().apply((Trees.TreeApi)c.universe().internal().reificationSupport().SyntacticSelectTerm().apply((Trees.TreeApi)c.universe().This().apply(c.universe().TypeName().apply("")), c.universe().TermName().apply("getClass")), c.universe().TermName().apply("getName")), c.universe().internal().reificationSupport().SyntacticSelectTerm().apply((Trees.TreeApi)c.universe().This().apply(c.universe().TypeName().apply("")), c.universe().TermName().apply("schema")), c.universe().internal().reificationSupport().SyntacticTermIdent().apply(c.universe().TermName().apply("indent"), false)}))})))), c.universe().internal().reificationSupport().SyntacticDefDef().apply(c.universe().Modifiers().apply(c.universe().internal().reificationSupport().FlagsRepr().apply(2L), (Names.NameApi)c.universe().TypeName().apply(""), (List)Nil$.MODULE$), c.universe().TermName().apply("fromGenericRecord"), (List)Nil$.MODULE$, (List)Nil$.MODULE$, c.universe().internal().reificationSupport().SyntacticFunctionType().apply(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Trees.SelectApi[]{c.universe().internal().reificationSupport().SyntacticSelectType().apply((Trees.TreeApi)c.universe().internal().reificationSupport().SyntacticSelectTerm().apply(MacroUtil$.MODULE$.p(c, MacroUtil$.MODULE$.ApacheAvro()), c.universe().TermName().apply("generic")), c.universe().TypeName().apply("GenericRecord"))})), (Trees.TreeApi)c.universe().internal().reificationSupport().SyntacticTypeIdent().apply(typeNameApi)), c.universe().internal().reificationSupport().SyntacticTypeApplied().apply((Trees.TreeApi)c.universe().internal().reificationSupport().SyntacticSelectTerm().apply(MacroUtil$.MODULE$.p(c, MacroUtil$.MODULE$.ScioAvroType()), c.universe().TermName().apply("fromGenericRecord")), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Trees.IdentApi[]{c.universe().internal().reificationSupport().SyntacticTypeIdent().apply(typeNameApi)})))), c.universe().internal().reificationSupport().SyntacticDefDef().apply(c.universe().Modifiers().apply(c.universe().internal().reificationSupport().FlagsRepr().apply(2L), (Names.NameApi)c.universe().TypeName().apply(""), (List)Nil$.MODULE$), c.universe().TermName().apply("toGenericRecord"), (List)Nil$.MODULE$, (List)Nil$.MODULE$, c.universe().internal().reificationSupport().SyntacticFunctionType().apply(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Trees.IdentApi[]{c.universe().internal().reificationSupport().SyntacticTypeIdent().apply(typeNameApi)})), (Trees.TreeApi)c.universe().internal().reificationSupport().SyntacticSelectType().apply((Trees.TreeApi)c.universe().internal().reificationSupport().SyntacticSelectTerm().apply(MacroUtil$.MODULE$.p(c, MacroUtil$.MODULE$.ApacheAvro()), c.universe().TermName().apply("generic")), c.universe().TypeName().apply("GenericRecord"))), c.universe().internal().reificationSupport().SyntacticTypeApplied().apply((Trees.TreeApi)c.universe().internal().reificationSupport().SyntacticSelectTerm().apply(MacroUtil$.MODULE$.p(c, MacroUtil$.MODULE$.ScioAvroType()), c.universe().TermName().apply("toGenericRecord")), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Trees.IdentApi[]{c.universe().internal().reificationSupport().SyntacticTypeIdent().apply(typeNameApi)}))))})).$plus$plus((GenTraversableOnce)tupledMethod.toList(), List$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)seq3.toList(), List$.MODULE$.canBuildFrom()));
    }

    private List<String> extractStrings(Context c, String errorMessage) {
        Trees.TreeApi treeApi = c.macroApplication();
        Option option = c.universe().ApplyTag().unapply((Object)treeApi);
        if (!option.isEmpty()) {
            Trees.ApplyApi applyApi = (Trees.ApplyApi)option.get();
            Option option2 = c.universe().Apply().unapply(applyApi);
            if (!option2.isEmpty()) {
                Object object = ((Tuple2)option2.get())._1();
                Option option3 = c.universe().SelectTag().unapply(object);
                if (!option3.isEmpty()) {
                    Trees.SelectApi selectApi = (Trees.SelectApi)option3.get();
                    Option option4 = c.universe().Select().unapply(selectApi);
                    if (!option4.isEmpty()) {
                        Object object2 = ((Tuple2)option4.get())._1();
                        Option option5 = c.universe().ApplyTag().unapply(object2);
                        if (!option5.isEmpty()) {
                            List xs;
                            Trees.ApplyApi applyApi2 = (Trees.ApplyApi)option5.get();
                            Option option6 = c.universe().Apply().unapply(applyApi2);
                            if (!option6.isEmpty() && (xs = (List)((Tuple2)option6.get())._2()) instanceof List) {
                                List list = xs;
                                List args = (List)list.map((Function1)new Serializable(c, errorMessage){
                                    public static final long serialVersionUID = 0L;
                                    private final Context c$2;
                                    private final String errorMessage$1;

                                    public final String apply(Trees.TreeApi tree) {
                                        return TypeProvider$.MODULE$.com$spotify$scio$avro$types$TypeProvider$$str$1(tree, this.c$2, this.errorMessage$1);
                                    }
                                    {
                                        this.c$2 = c$2;
                                        this.errorMessage$1 = errorMessage$1;
                                    }
                                }, List$.MODULE$.canBuildFrom());
                                if (args.isEmpty()) {
                                    throw c.abort(c.enclosingPosition(), errorMessage);
                                }
                                List list2 = args;
                                return list2;
                            }
                        }
                    }
                }
            }
        }
        throw c.abort(c.enclosingPosition(), errorMessage);
    }

    private void checkMacroEnclosed(Context c) {
        if (c.internal().enclosingOwner().isClass()) {
            return;
        }
        throw c.abort(c.enclosingPosition(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"@AvroType declaration must be inside a class or object."})).s((Seq)Nil$.MODULE$));
    }

    private List<Trees.TreeApi> getRecordDocs(Context c, Seq<Trees.TreeApi> tree) {
        Seq<Trees.TreeApi> seq = tree;
        return (List)((List)((Trees.ClassDefApi)seq.head()).mods().annotations().filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Trees.TreeApi x$20) {
                return ((Trees.TreeApi)x$20.children().head()).toString().matches("^new doc");
            }
        })).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Trees.TreeApi apply(Trees.TreeApi x$21) {
                return (Trees.TreeApi)((IterableLike)x$21.children().tail()).head();
            }
        }, List$.MODULE$.canBuildFrom());
    }

    private boolean shouldDumpClassesForPlugin() {
        return package$.MODULE$.props().apply((Object)"bigquery.plugin.disable.dump") == null || !new StringOps(Predef$.MODULE$.augmentString((String)package$.MODULE$.props().apply((Object)"bigquery.plugin.disable.dump"))).toBoolean();
    }

    private Path getBQClassCacheDir() {
        return package$.MODULE$.props().apply((Object)"bigquery.class.cache.directory") == null ? Paths.get((String)package$.MODULE$.props().apply((Object)"java.io.tmpdir"), new String[0]).resolve((String)package$.MODULE$.props().apply((Object)"user.name")).resolve("bigquery-classes") : Paths.get((String)package$.MODULE$.props().apply((Object)"bigquery.class.cache.directory"), new String[0]);
    }

    private Seq<String> pShowCode(Context c, Seq<Trees.TreeApi> records, Trees.TreeApi caseClass) {
        Seq<Trees.TreeApi> seq = records;
        Trees.TreeApi treeApi = caseClass;
        return (Seq)((TraversableLike)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Trees.TreeApi[]{treeApi}))).$plus$plus(seq, Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(c){
            public static final long serialVersionUID = 0L;
            public final Context c$4;

            public final String apply(Trees.TreeApi x0$1) {
                String string;
                Trees.TreeApi treeApi = x0$1;
                Option<Tuple3<Names.TypeNameApi, List<Trees.ValDefApi>, List<Trees.TreeApi>>> option = new Object(this){
                    private final /* synthetic */ anonfun.pShowCode.1 $outer;

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public Option<Tuple3<Names.TypeNameApi, List<Trees.ValDefApi>, List<Trees.TreeApi>>> unapply(Object tree) {
                        Object object = tree;
                        Option option = this.$outer.c$4.universe().TreeTag().unapply(object);
                        if (option.isEmpty()) return None$.MODULE$;
                        Trees.TreeApi treeApi = (Trees.TreeApi)option.get();
                        Option option2 = this.$outer.c$4.universe().internal().reificationSupport().SyntacticClassDef().unapply(treeApi);
                        if (option2.isEmpty()) return None$.MODULE$;
                        Object object2 = ((Tuple9)option2.get())._1();
                        Names.TypeNameApi qq$17b03743$macro$133 = (Names.TypeNameApi)((Tuple9)option2.get())._2();
                        List list = (List)((Tuple9)option2.get())._3();
                        Trees.ModifiersApi modifiersApi = (Trees.ModifiersApi)((Tuple9)option2.get())._4();
                        List list2 = (List)((Tuple9)option2.get())._5();
                        List list3 = (List)((Tuple9)option2.get())._6();
                        List list4 = (List)((Tuple9)option2.get())._7();
                        Trees.ValDefApi valDefApi = (Trees.ValDefApi)((Tuple9)option2.get())._8();
                        List qq$17b03743$macro$135 = (List)((Tuple9)option2.get())._9();
                        Option option3 = this.$outer.c$4.universe().ModifiersTag().unapply(object2);
                        if (option3.isEmpty()) return None$.MODULE$;
                        Trees.ModifiersApi modifiersApi2 = (Trees.ModifiersApi)option3.get();
                        Option option4 = this.$outer.c$4.universe().Modifiers().unapply(modifiersApi2);
                        if (option4.isEmpty()) return None$.MODULE$;
                        Object object3 = ((Tuple3)option4.get())._1();
                        Object object4 = ((Tuple3)option4.get())._2();
                        List list5 = (List)((Tuple3)option4.get())._3();
                        if (!(object3 instanceof Long)) return None$.MODULE$;
                        long l = BoxesRunTime.unboxToLong((Object)object3);
                        Some some = this.$outer.c$4.universe().internal().reificationSupport().FlagsRepr().unapply(l);
                        if (some.isEmpty()) return None$.MODULE$;
                        long l2 = BoxesRunTime.unboxToLong((Object)some.get());
                        if (2048L != l2) return None$.MODULE$;
                        Option option5 = this.$outer.c$4.universe().TypeNameTag().unapply(object4);
                        if (option5.isEmpty()) return None$.MODULE$;
                        Names.TypeNameApi typeNameApi = (Names.TypeNameApi)option5.get();
                        Option option6 = this.$outer.c$4.universe().TypeName().unapply(typeNameApi);
                        if (option6.isEmpty()) return None$.MODULE$;
                        String string = (String)option6.get();
                        if (!"".equals(string)) return None$.MODULE$;
                        if (!Nil$.MODULE$.equals(list5)) return None$.MODULE$;
                        if (!Nil$.MODULE$.equals(list)) return None$.MODULE$;
                        Trees.ModifiersApi modifiersApi3 = this.$outer.c$4.universe().NoMods();
                        Trees.ModifiersApi modifiersApi4 = modifiersApi;
                        if (modifiersApi3 == null) {
                            if (modifiersApi4 != null) {
                                return None$.MODULE$;
                            }
                        } else if (!modifiersApi3.equals(modifiersApi4)) return None$.MODULE$;
                        if (!(list2 instanceof .colon.colon)) return None$.MODULE$;
                        .colon.colon colon2 = (.colon.colon)list2;
                        List qq$17b03743$macro$134 = (List)colon2.head();
                        List list6 = colon2.tl$1();
                        if (!Nil$.MODULE$.equals(list6)) return None$.MODULE$;
                        if (!Nil$.MODULE$.equals(list3)) return None$.MODULE$;
                        if (!(list4 instanceof .colon.colon)) return None$.MODULE$;
                        .colon.colon colon3 = (.colon.colon)list4;
                        Object object5 = colon3.head();
                        List list7 = colon3.tl$1();
                        Option option7 = this.$outer.c$4.universe().TreeTag().unapply(object5);
                        if (option7.isEmpty()) return None$.MODULE$;
                        Trees.TreeApi treeApi2 = (Trees.TreeApi)option7.get();
                        Option option8 = this.$outer.c$4.universe().internal().reificationSupport().ScalaDot().unapply(treeApi2);
                        if (option8.isEmpty()) return None$.MODULE$;
                        Object object6 = option8.get();
                        Option option9 = this.$outer.c$4.universe().TypeNameTag().unapply(object6);
                        if (option9.isEmpty()) return None$.MODULE$;
                        Names.TypeNameApi typeNameApi2 = (Names.TypeNameApi)option9.get();
                        Option option10 = this.$outer.c$4.universe().TypeName().unapply(typeNameApi2);
                        if (option10.isEmpty()) return None$.MODULE$;
                        String string2 = (String)option10.get();
                        if (!"Product".equals(string2)) return None$.MODULE$;
                        if (!(list7 instanceof .colon.colon)) return None$.MODULE$;
                        .colon.colon colon4 = (.colon.colon)list7;
                        Object object7 = colon4.head();
                        List list8 = colon4.tl$1();
                        Option option11 = this.$outer.c$4.universe().TreeTag().unapply(object7);
                        if (option11.isEmpty()) return None$.MODULE$;
                        Trees.TreeApi treeApi3 = (Trees.TreeApi)option11.get();
                        Option option12 = this.$outer.c$4.universe().internal().reificationSupport().ScalaDot().unapply(treeApi3);
                        if (option12.isEmpty()) return None$.MODULE$;
                        Object object8 = option12.get();
                        Option option13 = this.$outer.c$4.universe().TypeNameTag().unapply(object8);
                        if (option13.isEmpty()) return None$.MODULE$;
                        Names.TypeNameApi typeNameApi3 = (Names.TypeNameApi)option13.get();
                        Option option14 = this.$outer.c$4.universe().TypeName().unapply(typeNameApi3);
                        if (option14.isEmpty()) return None$.MODULE$;
                        String string3 = (String)option14.get();
                        if (!"Serializable".equals(string3)) return None$.MODULE$;
                        if (!Nil$.MODULE$.equals(list8)) return None$.MODULE$;
                        Trees.ValDefApi valDefApi2 = this.$outer.c$4.universe().noSelfType();
                        Trees.ValDefApi valDefApi3 = valDefApi;
                        if (valDefApi2 == null) {
                            if (valDefApi3 == null) return new Some((Object)new Tuple3((Object)qq$17b03743$macro$133, (Object)qq$17b03743$macro$134, (Object)qq$17b03743$macro$135));
                            return None$.MODULE$;
                        } else {
                            if (!valDefApi2.equals(valDefApi3)) return None$.MODULE$;
                            return new Some((Object)new Tuple3((Object)qq$17b03743$macro$133, (Object)qq$17b03743$macro$134, (Object)qq$17b03743$macro$135));
                        }
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }.unapply(treeApi);
                if (option.isEmpty()) {
                    Option<Tuple4<Names.TypeNameApi, List<Trees.ValDefApi>, Trees.TreeApi, List<Trees.TreeApi>>> option2 = new Object(this){
                        private final /* synthetic */ anonfun.pShowCode.1 $outer;

                        /*
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        public Option<Tuple4<Names.TypeNameApi, List<Trees.ValDefApi>, Trees.TreeApi, List<Trees.TreeApi>>> unapply(Object tree) {
                            Object object = tree;
                            Option option = this.$outer.c$4.universe().TreeTag().unapply(object);
                            if (option.isEmpty()) return None$.MODULE$;
                            Trees.TreeApi treeApi = (Trees.TreeApi)option.get();
                            Option option2 = this.$outer.c$4.universe().internal().reificationSupport().SyntacticClassDef().unapply(treeApi);
                            if (option2.isEmpty()) return None$.MODULE$;
                            Object object2 = ((Tuple9)option2.get())._1();
                            Names.TypeNameApi qq$ba9d6ddb$macro$136 = (Names.TypeNameApi)((Tuple9)option2.get())._2();
                            List list = (List)((Tuple9)option2.get())._3();
                            Trees.ModifiersApi modifiersApi = (Trees.ModifiersApi)((Tuple9)option2.get())._4();
                            List list2 = (List)((Tuple9)option2.get())._5();
                            List list3 = (List)((Tuple9)option2.get())._6();
                            List list4 = (List)((Tuple9)option2.get())._7();
                            Trees.ValDefApi valDefApi = (Trees.ValDefApi)((Tuple9)option2.get())._8();
                            List qq$ba9d6ddb$macro$139 = (List)((Tuple9)option2.get())._9();
                            Option option3 = this.$outer.c$4.universe().ModifiersTag().unapply(object2);
                            if (option3.isEmpty()) return None$.MODULE$;
                            Trees.ModifiersApi modifiersApi2 = (Trees.ModifiersApi)option3.get();
                            Option option4 = this.$outer.c$4.universe().Modifiers().unapply(modifiersApi2);
                            if (option4.isEmpty()) return None$.MODULE$;
                            Object object3 = ((Tuple3)option4.get())._1();
                            Object object4 = ((Tuple3)option4.get())._2();
                            List list5 = (List)((Tuple3)option4.get())._3();
                            if (!(object3 instanceof Long)) return None$.MODULE$;
                            long l = BoxesRunTime.unboxToLong((Object)object3);
                            Some some = this.$outer.c$4.universe().internal().reificationSupport().FlagsRepr().unapply(l);
                            if (some.isEmpty()) return None$.MODULE$;
                            long l2 = BoxesRunTime.unboxToLong((Object)some.get());
                            if (2048L != l2) return None$.MODULE$;
                            Option option5 = this.$outer.c$4.universe().TypeNameTag().unapply(object4);
                            if (option5.isEmpty()) return None$.MODULE$;
                            Names.TypeNameApi typeNameApi = (Names.TypeNameApi)option5.get();
                            Option option6 = this.$outer.c$4.universe().TypeName().unapply(typeNameApi);
                            if (option6.isEmpty()) return None$.MODULE$;
                            String string = (String)option6.get();
                            if (!"".equals(string)) return None$.MODULE$;
                            if (!Nil$.MODULE$.equals(list5)) return None$.MODULE$;
                            if (!Nil$.MODULE$.equals(list)) return None$.MODULE$;
                            Trees.ModifiersApi modifiersApi3 = this.$outer.c$4.universe().NoMods();
                            Trees.ModifiersApi modifiersApi4 = modifiersApi;
                            if (modifiersApi3 == null) {
                                if (modifiersApi4 != null) {
                                    return None$.MODULE$;
                                }
                            } else if (!modifiersApi3.equals(modifiersApi4)) return None$.MODULE$;
                            if (!(list2 instanceof .colon.colon)) return None$.MODULE$;
                            .colon.colon colon2 = (.colon.colon)list2;
                            List qq$ba9d6ddb$macro$137 = (List)colon2.head();
                            List list6 = colon2.tl$1();
                            if (!Nil$.MODULE$.equals(list6)) return None$.MODULE$;
                            if (!Nil$.MODULE$.equals(list3)) return None$.MODULE$;
                            if (!(list4 instanceof .colon.colon)) return None$.MODULE$;
                            .colon.colon colon3 = (.colon.colon)list4;
                            Trees.TreeApi qq$ba9d6ddb$macro$138 = (Trees.TreeApi)colon3.head();
                            List list7 = colon3.tl$1();
                            if (!(list7 instanceof .colon.colon)) return None$.MODULE$;
                            .colon.colon colon4 = (.colon.colon)list7;
                            Object object5 = colon4.head();
                            List list8 = colon4.tl$1();
                            Option option7 = this.$outer.c$4.universe().TreeTag().unapply(object5);
                            if (option7.isEmpty()) return None$.MODULE$;
                            Trees.TreeApi treeApi2 = (Trees.TreeApi)option7.get();
                            Option option8 = this.$outer.c$4.universe().internal().reificationSupport().ScalaDot().unapply(treeApi2);
                            if (option8.isEmpty()) return None$.MODULE$;
                            Object object6 = option8.get();
                            Option option9 = this.$outer.c$4.universe().TypeNameTag().unapply(object6);
                            if (option9.isEmpty()) return None$.MODULE$;
                            Names.TypeNameApi typeNameApi2 = (Names.TypeNameApi)option9.get();
                            Option option10 = this.$outer.c$4.universe().TypeName().unapply(typeNameApi2);
                            if (option10.isEmpty()) return None$.MODULE$;
                            String string2 = (String)option10.get();
                            if (!"Product".equals(string2)) return None$.MODULE$;
                            if (!(list8 instanceof .colon.colon)) return None$.MODULE$;
                            .colon.colon colon5 = (.colon.colon)list8;
                            Object object7 = colon5.head();
                            List list9 = colon5.tl$1();
                            Option option11 = this.$outer.c$4.universe().TreeTag().unapply(object7);
                            if (option11.isEmpty()) return None$.MODULE$;
                            Trees.TreeApi treeApi3 = (Trees.TreeApi)option11.get();
                            Option option12 = this.$outer.c$4.universe().internal().reificationSupport().ScalaDot().unapply(treeApi3);
                            if (option12.isEmpty()) return None$.MODULE$;
                            Object object8 = option12.get();
                            Option option13 = this.$outer.c$4.universe().TypeNameTag().unapply(object8);
                            if (option13.isEmpty()) return None$.MODULE$;
                            Names.TypeNameApi typeNameApi3 = (Names.TypeNameApi)option13.get();
                            Option option14 = this.$outer.c$4.universe().TypeName().unapply(typeNameApi3);
                            if (option14.isEmpty()) return None$.MODULE$;
                            String string3 = (String)option14.get();
                            if (!"Serializable".equals(string3)) return None$.MODULE$;
                            if (!Nil$.MODULE$.equals(list9)) return None$.MODULE$;
                            Trees.ValDefApi valDefApi2 = this.$outer.c$4.universe().noSelfType();
                            Trees.ValDefApi valDefApi3 = valDefApi;
                            if (valDefApi2 == null) {
                                if (valDefApi3 == null) return new Some((Object)new Tuple4((Object)qq$ba9d6ddb$macro$136, (Object)qq$ba9d6ddb$macro$137, (Object)qq$ba9d6ddb$macro$138, (Object)qq$ba9d6ddb$macro$139));
                                return None$.MODULE$;
                            } else {
                                if (!valDefApi2.equals(valDefApi3)) return None$.MODULE$;
                                return new Some((Object)new Tuple4((Object)qq$ba9d6ddb$macro$136, (Object)qq$ba9d6ddb$macro$137, (Object)qq$ba9d6ddb$macro$138, (Object)qq$ba9d6ddb$macro$139));
                            }
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    }.unapply(treeApi);
                    if (option2.isEmpty()) {
                        string = "";
                    } else {
                        Names.TypeNameApi name = (Names.TypeNameApi)((Tuple4)option2.get())._1();
                        List fields = (List)((Tuple4)option2.get())._2();
                        Trees.TreeApi annotation = (Trees.TreeApi)((Tuple4)option2.get())._3();
                        string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"case class ", "(", ") extends ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name, ((TraversableOnce)fields.map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anonfun.pShowCode.1 $outer;

                            public final String apply(Trees.ValDefApi x0$3) {
                                Option option;
                                block3: {
                                    Trees.ValDefApi valDefApi;
                                    block2: {
                                        valDefApi = x0$3;
                                        Option option2 = this.$outer.c$4.universe().ValDefTag().unapply((Object)valDefApi);
                                        if (option2.isEmpty()) break block2;
                                        Trees.ValDefApi valDefApi2 = (Trees.ValDefApi)option2.get();
                                        option = this.$outer.c$4.universe().ValDef().unapply(valDefApi2);
                                        if (!option.isEmpty()) break block3;
                                    }
                                    throw new MatchError((Object)valDefApi);
                                }
                                Names.TermNameApi fname = (Names.TermNameApi)((Tuple4)option.get())._2();
                                Trees.TreeApi ftpt = (Trees.TreeApi)((Tuple4)option.get())._3();
                                String string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " : ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{SchemaUtil$.MODULE$.escapeNameIfReserved(fname.toString()), ftpt}));
                                return string;
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        }, List$.MODULE$.canBuildFrom())).mkString(", "), annotation}));
                    }
                } else {
                    Names.TypeNameApi name = (Names.TypeNameApi)((Tuple3)option.get())._1();
                    List fields = (List)((Tuple3)option.get())._2();
                    string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"case class ", "(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name, ((TraversableOnce)fields.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.pShowCode.1 $outer;

                        public final String apply(Trees.ValDefApi x0$2) {
                            Option option;
                            block3: {
                                Trees.ValDefApi valDefApi;
                                block2: {
                                    valDefApi = x0$2;
                                    Option option2 = this.$outer.c$4.universe().ValDefTag().unapply((Object)valDefApi);
                                    if (option2.isEmpty()) break block2;
                                    Trees.ValDefApi valDefApi2 = (Trees.ValDefApi)option2.get();
                                    option = this.$outer.c$4.universe().ValDef().unapply(valDefApi2);
                                    if (!option.isEmpty()) break block3;
                                }
                                throw new MatchError((Object)valDefApi);
                            }
                            Names.TermNameApi fname = (Names.TermNameApi)((Tuple4)option.get())._2();
                            Trees.TreeApi ftpt = (Trees.TreeApi)((Tuple4)option.get())._3();
                            String string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " : ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{SchemaUtil$.MODULE$.escapeNameIfReserved(fname.toString()), ftpt}));
                            return string;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    }, List$.MODULE$.canBuildFrom())).mkString(", ")}));
                }
                return string;
            }
            {
                this.c$4 = c$4;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    private String genHashForMacro(String owner, String srcFile) {
        return Hashing.murmur3_32().newHasher().putString((CharSequence)owner, Charsets.UTF_8).putString((CharSequence)srcFile, Charsets.UTF_8).hash().toString();
    }

    private void dumpCodeForScalaPlugin(Context c, Seq<Trees.TreeApi> records, Trees.TreeApi caseClassTree, String name) {
        Seq<Trees.TreeApi> seq = records;
        Trees.TreeApi treeApi = caseClassTree;
        String owner = c.internal().enclosingOwner().fullName();
        String srcFile = c.macroApplication().pos().source().file().canonicalPath();
        String hash = this.genHashForMacro(owner, srcFile);
        String prettyCode = this.pShowCode(c, seq, treeApi).mkString("\n");
        Path classCacheDir = this.getBQClassCacheDir();
        File genSrcFile = classCacheDir.resolve(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-", ".scala"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name, hash}))).toFile();
        this.logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Will dump generated ", " of ", " from ", " to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name, owner, srcFile, genSrcFile})));
        Files.createParentDirs((File)genSrcFile);
        Files.write((CharSequence)prettyCode, (File)genSrcFile, (Charset)Charsets.UTF_8);
    }

    private void registerFileSystemRegistrars() {
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        FileSystems.setDefaultPipelineOptions((PipelineOptions)PipelineOptionsFactory.create());
    }

    private final Option matchResult$1(MatchResult r) {
        MatchResult.Metadata last;
        MatchResult.Status status = r.status();
        MatchResult.Status status2 = MatchResult.Status.OK;
        return !(status != null ? !status.equals(status2) : status2 != null) && !r.metadata().isEmpty() ? ((last = (MatchResult.Metadata)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(r.metadata()).asScala()).maxBy((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(MatchResult.Metadata x$1) {
                return x$1.resourceId().toString();
            }
        }, (Ordering)Ordering.String$.MODULE$)).sizeBytes() > 0L ? new Some((Object)last.resourceId()) : None$.MODULE$) : None$.MODULE$;
    }

    private final Tuple2 getField$1(String className, String fieldName, Schema fieldSchema, Context c$3) {
        Schema.Type type;
        block17: {
            Tuple2 tuple2;
            block18: {
                Tuple2 tuple22;
                block5: {
                    Tuple2 tuple23;
                    block15: {
                        Tuple2 tuple24;
                        block16: {
                            Tuple2 tuple25;
                            block13: {
                                Tuple2 tuple26;
                                block14: {
                                    Tuple2 tuple27;
                                    block12: {
                                        block11: {
                                            block10: {
                                                block9: {
                                                    block8: {
                                                        block7: {
                                                            block6: {
                                                                block2: {
                                                                    block3: {
                                                                        Tuple2 tuple28;
                                                                        block4: {
                                                                            Tuple2 tuple29;
                                                                            type = fieldSchema.getType();
                                                                            if (!Schema.Type.UNION.equals(type)) break block2;
                                                                            Buffer unionTypes = (Buffer)((SeqLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(fieldSchema.getTypes()).asScala()).map((Function1)new Serializable(){
                                                                                public static final long serialVersionUID = 0L;

                                                                                public final Schema.Type apply(Schema x$6) {
                                                                                    return x$6.getType();
                                                                                }
                                                                            }, Buffer$.MODULE$.canBuildFrom())).distinct();
                                                                            if (unionTypes.size() != 2 || !unionTypes.contains((Object)Schema.Type.NULL)) break block3;
                                                                            tuple28 = this.getField$1(className, fieldName, (Schema)((IterableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(fieldSchema.getTypes()).asScala()).filter((Function1)new Serializable(){
                                                                                public static final long serialVersionUID = 0L;

                                                                                public final boolean apply(Schema x$7) {
                                                                                    Schema.Type type = x$7.getType();
                                                                                    Schema.Type type2 = Schema.Type.NULL;
                                                                                    return type != null ? !type.equals(type2) : type2 != null;
                                                                                }
                                                                            })).head(), c$3);
                                                                            if (tuple28 == null) break block4;
                                                                            Trees.TreeApi field = (Trees.TreeApi)tuple28._1();
                                                                            Seq recordClasses = (Seq)tuple28._2();
                                                                            Tuple2 tuple210 = tuple29 = new Tuple2((Object)field, (Object)recordClasses);
                                                                            Trees.TreeApi field2 = (Trees.TreeApi)tuple210._1();
                                                                            Seq recordClasses2 = (Seq)tuple210._2();
                                                                            tuple22 = new Tuple2((Object)c$3.universe().internal().reificationSupport().SyntacticAppliedType().apply((Trees.TreeApi)c$3.universe().internal().reificationSupport().SyntacticSelectType().apply((Trees.TreeApi)c$3.universe().internal().reificationSupport().SyntacticSelectTerm().apply((Trees.TreeApi)c$3.universe().internal().reificationSupport().SyntacticTermIdent().apply(c$3.universe().TermName().apply("_root_"), false), c$3.universe().TermName().apply("scala")), c$3.universe().TypeName().apply("Option")), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Trees.TreeApi[]{field2}))), (Object)recordClasses2);
                                                                            break block5;
                                                                        }
                                                                        throw new MatchError((Object)tuple28);
                                                                    }
                                                                    throw c$3.abort(c$3.enclosingPosition(), new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"type: ", " is not supported. "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fieldSchema.getType()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Union type needs to contain exactly one 'null' type and one non null type."})).s((Seq)Nil$.MODULE$)).toString());
                                                                }
                                                                if (!Schema.Type.BOOLEAN.equals(type)) break block6;
                                                                tuple22 = new Tuple2((Object)c$3.universe().internal().reificationSupport().SyntacticSelectType().apply((Trees.TreeApi)c$3.universe().internal().reificationSupport().SyntacticSelectTerm().apply((Trees.TreeApi)c$3.universe().internal().reificationSupport().SyntacticTermIdent().apply(c$3.universe().TermName().apply("_root_"), false), c$3.universe().TermName().apply("scala")), c$3.universe().TypeName().apply("Boolean")), (Object)Nil$.MODULE$);
                                                                break block5;
                                                            }
                                                            if (!Schema.Type.LONG.equals(type)) break block7;
                                                            tuple22 = new Tuple2((Object)c$3.universe().internal().reificationSupport().SyntacticSelectType().apply((Trees.TreeApi)c$3.universe().internal().reificationSupport().SyntacticSelectTerm().apply((Trees.TreeApi)c$3.universe().internal().reificationSupport().SyntacticTermIdent().apply(c$3.universe().TermName().apply("_root_"), false), c$3.universe().TermName().apply("scala")), c$3.universe().TypeName().apply("Long")), (Object)Nil$.MODULE$);
                                                            break block5;
                                                        }
                                                        if (!Schema.Type.DOUBLE.equals(type)) break block8;
                                                        tuple22 = new Tuple2((Object)c$3.universe().internal().reificationSupport().SyntacticSelectType().apply((Trees.TreeApi)c$3.universe().internal().reificationSupport().SyntacticSelectTerm().apply((Trees.TreeApi)c$3.universe().internal().reificationSupport().SyntacticTermIdent().apply(c$3.universe().TermName().apply("_root_"), false), c$3.universe().TermName().apply("scala")), c$3.universe().TypeName().apply("Double")), (Object)Nil$.MODULE$);
                                                        break block5;
                                                    }
                                                    if (!Schema.Type.INT.equals(type)) break block9;
                                                    tuple22 = new Tuple2((Object)c$3.universe().internal().reificationSupport().SyntacticSelectType().apply((Trees.TreeApi)c$3.universe().internal().reificationSupport().SyntacticSelectTerm().apply((Trees.TreeApi)c$3.universe().internal().reificationSupport().SyntacticTermIdent().apply(c$3.universe().TermName().apply("_root_"), false), c$3.universe().TermName().apply("scala")), c$3.universe().TypeName().apply("Int")), (Object)Nil$.MODULE$);
                                                    break block5;
                                                }
                                                if (!Schema.Type.FLOAT.equals(type)) break block10;
                                                tuple22 = new Tuple2((Object)c$3.universe().internal().reificationSupport().SyntacticSelectType().apply((Trees.TreeApi)c$3.universe().internal().reificationSupport().SyntacticSelectTerm().apply((Trees.TreeApi)c$3.universe().internal().reificationSupport().SyntacticTermIdent().apply(c$3.universe().TermName().apply("_root_"), false), c$3.universe().TermName().apply("scala")), c$3.universe().TypeName().apply("Float")), (Object)Nil$.MODULE$);
                                                break block5;
                                            }
                                            boolean bl = Schema.Type.STRING.equals(type) ? true : Schema.Type.ENUM.equals(type);
                                            if (!bl) break block11;
                                            tuple22 = new Tuple2((Object)c$3.universe().internal().reificationSupport().SyntacticSelectType().apply((Trees.TreeApi)c$3.universe().internal().reificationSupport().SyntacticSelectTerm().apply((Trees.TreeApi)c$3.universe().internal().reificationSupport().SyntacticSelectTerm().apply((Trees.TreeApi)c$3.universe().internal().reificationSupport().SyntacticTermIdent().apply(c$3.universe().TermName().apply("_root_"), false), c$3.universe().TermName().apply("java")), c$3.universe().TermName().apply("lang")), c$3.universe().TypeName().apply("String")), (Object)Nil$.MODULE$);
                                            break block5;
                                        }
                                        if (!Schema.Type.BYTES.equals(type)) break block12;
                                        tuple22 = new Tuple2((Object)c$3.universe().internal().reificationSupport().SyntacticSelectType().apply((Trees.TreeApi)c$3.universe().internal().reificationSupport().SyntacticSelectTerm().apply((Trees.TreeApi)c$3.universe().internal().reificationSupport().SyntacticSelectTerm().apply((Trees.TreeApi)c$3.universe().internal().reificationSupport().SyntacticSelectTerm().apply((Trees.TreeApi)c$3.universe().internal().reificationSupport().SyntacticTermIdent().apply(c$3.universe().TermName().apply("_root_"), false), c$3.universe().TermName().apply("com")), c$3.universe().TermName().apply("google")), c$3.universe().TermName().apply("protobuf")), c$3.universe().TypeName().apply("ByteString")), (Object)Nil$.MODULE$);
                                        break block5;
                                    }
                                    if (!Schema.Type.ARRAY.equals(type)) break block13;
                                    tuple26 = this.getField$1(className, fieldName, fieldSchema.getElementType(), c$3);
                                    if (tuple26 == null) break block14;
                                    Trees.TreeApi field = (Trees.TreeApi)tuple26._1();
                                    Seq generatedCaseClasses = (Seq)tuple26._2();
                                    Tuple2 tuple211 = tuple27 = new Tuple2((Object)field, (Object)generatedCaseClasses);
                                    Trees.TreeApi field3 = (Trees.TreeApi)tuple211._1();
                                    Seq generatedCaseClasses2 = (Seq)tuple211._2();
                                    tuple22 = new Tuple2((Object)c$3.universe().internal().reificationSupport().SyntacticAppliedType().apply((Trees.TreeApi)c$3.universe().internal().reificationSupport().SyntacticSelectType().apply((Trees.TreeApi)c$3.universe().internal().reificationSupport().SyntacticSelectTerm().apply((Trees.TreeApi)c$3.universe().internal().reificationSupport().SyntacticTermIdent().apply(c$3.universe().TermName().apply("_root_"), false), c$3.universe().TermName().apply("scala")), c$3.universe().TypeName().apply("List")), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Trees.TreeApi[]{field3}))), (Object)generatedCaseClasses2);
                                    break block5;
                                }
                                throw new MatchError((Object)tuple26);
                            }
                            if (!Schema.Type.MAP.equals(type)) break block15;
                            tuple24 = this.getField$1(className, fieldName, fieldSchema.getValueType(), c$3);
                            if (tuple24 == null) break block16;
                            Trees.TreeApi fieldType = (Trees.TreeApi)tuple24._1();
                            Seq recordCaseClasses = (Seq)tuple24._2();
                            Tuple2 tuple212 = tuple25 = new Tuple2((Object)fieldType, (Object)recordCaseClasses);
                            Trees.TreeApi fieldType2 = (Trees.TreeApi)tuple212._1();
                            Seq recordCaseClasses2 = (Seq)tuple212._2();
                            tuple22 = new Tuple2((Object)c$3.universe().internal().reificationSupport().SyntacticAppliedType().apply((Trees.TreeApi)c$3.universe().internal().reificationSupport().SyntacticSelectType().apply((Trees.TreeApi)c$3.universe().internal().reificationSupport().SyntacticSelectTerm().apply((Trees.TreeApi)c$3.universe().internal().reificationSupport().SyntacticSelectTerm().apply((Trees.TreeApi)c$3.universe().internal().reificationSupport().SyntacticTermIdent().apply(c$3.universe().TermName().apply("_root_"), false), c$3.universe().TermName().apply("scala")), c$3.universe().TermName().apply("collection")), c$3.universe().TypeName().apply("Map")), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Trees.TreeApi[]{c$3.universe().internal().reificationSupport().SyntacticSelectType().apply((Trees.TreeApi)c$3.universe().internal().reificationSupport().SyntacticSelectTerm().apply((Trees.TreeApi)c$3.universe().internal().reificationSupport().SyntacticSelectTerm().apply((Trees.TreeApi)c$3.universe().internal().reificationSupport().SyntacticTermIdent().apply(c$3.universe().TermName().apply("_root_"), false), c$3.universe().TermName().apply("java")), c$3.universe().TermName().apply("lang")), c$3.universe().TypeName().apply("String")), fieldType2}))), (Object)recordCaseClasses2);
                            break block5;
                        }
                        throw new MatchError((Object)tuple24);
                    }
                    if (!Schema.Type.RECORD.equals(type)) break block17;
                    String nestedClassName = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "$", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{className, fieldSchema.getName()}));
                    tuple2 = this.extractFields$1(nestedClassName, fieldSchema, c$3);
                    if (tuple2 == null) break block18;
                    Seq fields = (Seq)tuple2._1();
                    Seq recordClasses = (Seq)tuple2._2();
                    Tuple2 tuple213 = tuple23 = new Tuple2((Object)fields, (Object)recordClasses);
                    Seq fields2 = (Seq)tuple213._1();
                    Seq recordClasses3 = (Seq)tuple213._2();
                    tuple22 = new Tuple2((Object)c$3.universe().Ident().apply((Names.NameApi)c$3.universe().TypeName().apply(nestedClassName)), ((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Trees.ClassDefApi[]{c$3.universe().internal().reificationSupport().SyntacticClassDef().apply(c$3.universe().Modifiers().apply(c$3.universe().internal().reificationSupport().FlagsRepr().apply(2048L), (Names.NameApi)c$3.universe().TypeName().apply(""), (List)Nil$.MODULE$), c$3.universe().TypeName().apply(nestedClassName), (List)Nil$.MODULE$, c$3.universe().NoMods(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new List[]{fields2.toList()})), (List)Nil$.MODULE$, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Trees.TreeApi[]{c$3.universe().internal().reificationSupport().ScalaDot().apply((Names.NameApi)c$3.universe().TypeName().apply("Product")), c$3.universe().internal().reificationSupport().ScalaDot().apply((Names.NameApi)c$3.universe().TypeName().apply("Serializable"))})), (Trees.TreeApi)c$3.universe().noSelfType(), (List)Nil$.MODULE$)}))).$plus$plus((GenTraversableOnce)recordClasses3, Seq$.MODULE$.canBuildFrom()));
                }
                return tuple22;
            }
            throw new MatchError((Object)tuple2);
        }
        throw c$3.abort(c$3.enclosingPosition(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"type: ", " not supported"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{type})));
    }

    public final Tuple2 com$spotify$scio$avro$types$TypeProvider$$extractField$1(String className, String fieldName, Schema fieldSchema, Context c$3) {
        Tuple2 tuple2 = this.getField$1(className, SchemaUtil$.MODULE$.unescapeNameIfReserved(fieldName), fieldSchema, c$3);
        if (tuple2 != null) {
            Tuple2 tuple22;
            Trees.TreeApi fieldType = (Trees.TreeApi)tuple2._1();
            Seq recordClasses = (Seq)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)fieldType, (Object)recordClasses);
            Trees.TreeApi fieldType2 = (Trees.TreeApi)tuple23._1();
            Seq recordClasses2 = (Seq)tuple23._2();
            Schema.Type type = fieldSchema.getType();
            Tuple2 tuple24 = Schema.Type.UNION.equals(type) ? new Tuple2((Object)c$3.universe().internal().reificationSupport().SyntacticValDef().apply(c$3.universe().NoMods(), c$3.universe().TermName().apply(fieldName), fieldType2, (Trees.TreeApi)c$3.universe().internal().reificationSupport().SyntacticTermIdent().apply(c$3.universe().TermName().apply("None"), false)), (Object)recordClasses2) : new Tuple2((Object)c$3.universe().Typed().apply((Trees.TreeApi)c$3.universe().internal().reificationSupport().SyntacticTermIdent().apply(c$3.universe().TermName().apply(fieldName), false), fieldType2), (Object)recordClasses2);
            return tuple24;
        }
        throw new MatchError((Object)tuple2);
    }

    private final Tuple2 extractFields$1(String className, Schema schema, Context c$3) {
        Buffer f = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(schema.getFields()).asScala()).map((Function1)new Serializable(c$3, className){
            public static final long serialVersionUID = 0L;
            private final Context c$3;
            private final String className$1;

            public final Tuple2<Trees.TreeApi, Seq<Trees.TreeApi>> apply(Schema.Field f) {
                return TypeProvider$.MODULE$.com$spotify$scio$avro$types$TypeProvider$$extractField$1(this.className$1, f.name(), f.schema(), this.c$3);
            }
            {
                this.c$3 = c$3;
                this.className$1 = className$1;
            }
        }, Buffer$.MODULE$.canBuildFrom());
        return new Tuple2(f.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Trees.TreeApi apply(Tuple2<Trees.TreeApi, Seq<Trees.TreeApi>> x$13) {
                return (Trees.TreeApi)x$13._1();
            }
        }, Buffer$.MODULE$.canBuildFrom()), f.flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Seq<Trees.TreeApi> apply(Tuple2<Trees.TreeApi, Seq<Trees.TreeApi>> x$14) {
                return (Seq)x$14._2();
            }
        }, Buffer$.MODULE$.canBuildFrom()));
    }

    public final String com$spotify$scio$avro$types$TypeProvider$$str$1(Trees.TreeApi tree, Context c$2, String errorMessage$1) {
        block4: {
            String string;
            block3: {
                String string2;
                Object s;
                Option option;
                Trees.TreeApi treeApi;
                block2: {
                    String string3;
                    Object s2;
                    treeApi = tree;
                    Option option2 = c$2.universe().LiteralTag().unapply((Object)treeApi);
                    if (option2.isEmpty()) break block2;
                    Trees.LiteralApi literalApi = (Trees.LiteralApi)option2.get();
                    Option option3 = c$2.universe().Literal().unapply(literalApi);
                    if (option3.isEmpty()) break block2;
                    Object object = option3.get();
                    Option option4 = c$2.universe().ConstantTag().unapply(object);
                    if (option4.isEmpty()) break block2;
                    Constants.ConstantApi constantApi = (Constants.ConstantApi)option4.get();
                    Option option5 = c$2.universe().Constant().unapply(constantApi);
                    if (option5.isEmpty() || !((s2 = option5.get()) instanceof String)) break block2;
                    string = string3 = (String)s2;
                    break block3;
                }
                if ((option = c$2.universe().SelectTag().unapply((Object)treeApi)).isEmpty()) break block4;
                Trees.SelectApi selectApi = (Trees.SelectApi)option.get();
                Option option6 = c$2.universe().Select().unapply(selectApi);
                if (option6.isEmpty()) break block4;
                Object object = ((Tuple2)option6.get())._1();
                Object object2 = ((Tuple2)option6.get())._2();
                Option option7 = c$2.universe().LiteralTag().unapply(object);
                if (option7.isEmpty()) break block4;
                Trees.LiteralApi literalApi = (Trees.LiteralApi)option7.get();
                Option option8 = c$2.universe().Literal().unapply(literalApi);
                if (option8.isEmpty()) break block4;
                Object object3 = option8.get();
                Option option9 = c$2.universe().ConstantTag().unapply(object3);
                if (option9.isEmpty()) break block4;
                Constants.ConstantApi constantApi = (Constants.ConstantApi)option9.get();
                Option option10 = c$2.universe().Constant().unapply(constantApi);
                if (option10.isEmpty() || !((s = option10.get()) instanceof String)) break block4;
                String string4 = (String)s;
                Option option11 = c$2.universe().TermNameTag().unapply(object2);
                if (option11.isEmpty()) break block4;
                Names.TermNameApi termNameApi = (Names.TermNameApi)option11.get();
                Option option12 = c$2.universe().TermName().unapply(termNameApi);
                if (option12.isEmpty() || !"stripMargin".equals(string2 = (String)option12.get())) break block4;
                string = new StringOps(Predef$.MODULE$.augmentString(string4)).stripMargin();
            }
            return string;
        }
        throw c$2.abort(c$2.enclosingPosition(), errorMessage$1);
    }

    private TypeProvider$() {
        MODULE$ = this;
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.bitmap$init$0 = true;
        this.registerFileSystemRegistrars();
    }
}

