/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.scio.bigquery;

import com.google.api.services.bigquery.model.TableReference;
import com.google.common.primitives.Longs;
import com.spotify.scio.bigquery.BigQueryClient;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryHelpers;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.UninitializedFieldError;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Builder;
import scala.math.Ordering;

public final class BigQueryPartitionUtil$ {
    public static BigQueryPartitionUtil$ MODULE$;
    private final String PROJECT_ID_REGEXP;
    private final String DATASET_REGEXP;
    private final String TABLE_REGEXP;
    private final String DATASET_TABLE_REGEXP_LEGACY;
    private final String DATASET_TABLE_REGEXP_STANDARD;
    private final Pattern QUERY_TABLE_SPEC_LEGACY;
    private final Pattern QUERY_TABLE_SPEC_STANDARD;
    private volatile byte bitmap$init$0;

    static {
        new BigQueryPartitionUtil$();
    }

    private String PROJECT_ID_REGEXP() {
        if ((byte)(this.bitmap$init$0 & 1) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/neville/src/spotify/scio/scio-bigquery/src/main/scala/com/spotify/scio/bigquery/BigQueryPartitionUtil.scala: 30");
        }
        return this.PROJECT_ID_REGEXP;
    }

    private String DATASET_REGEXP() {
        if ((byte)(this.bitmap$init$0 & 2) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/neville/src/spotify/scio/scio-bigquery/src/main/scala/com/spotify/scio/bigquery/BigQueryPartitionUtil.scala: 31");
        }
        return this.DATASET_REGEXP;
    }

    private String TABLE_REGEXP() {
        if ((byte)(this.bitmap$init$0 & 4) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/neville/src/spotify/scio/scio-bigquery/src/main/scala/com/spotify/scio/bigquery/BigQueryPartitionUtil.scala: 32");
        }
        return this.TABLE_REGEXP;
    }

    private String DATASET_TABLE_REGEXP_LEGACY() {
        if ((byte)(this.bitmap$init$0 & 8) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/neville/src/spotify/scio/scio-bigquery/src/main/scala/com/spotify/scio/bigquery/BigQueryPartitionUtil.scala: 33");
        }
        return this.DATASET_TABLE_REGEXP_LEGACY;
    }

    private String DATASET_TABLE_REGEXP_STANDARD() {
        if ((byte)(this.bitmap$init$0 & 0x10) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/neville/src/spotify/scio/scio-bigquery/src/main/scala/com/spotify/scio/bigquery/BigQueryPartitionUtil.scala: 35");
        }
        return this.DATASET_TABLE_REGEXP_STANDARD;
    }

    private Pattern QUERY_TABLE_SPEC_LEGACY() {
        if ((byte)(this.bitmap$init$0 & 0x20) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/neville/src/spotify/scio/scio-bigquery/src/main/scala/com/spotify/scio/bigquery/BigQueryPartitionUtil.scala: 37");
        }
        return this.QUERY_TABLE_SPEC_LEGACY;
    }

    private Pattern QUERY_TABLE_SPEC_STANDARD() {
        if ((byte)(this.bitmap$init$0 & 0x40) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/neville/src/spotify/scio/scio-bigquery/src/main/scala/com/spotify/scio/bigquery/BigQueryPartitionUtil.scala: 39");
        }
        return this.QUERY_TABLE_SPEC_STANDARD;
    }

    private Map<String, TableReference> extractTables(String sqlQuery) {
        Builder b = Predef$.MODULE$.Map().newBuilder();
        Matcher m1 = this.QUERY_TABLE_SPEC_LEGACY().matcher(sqlQuery);
        while (m1.find()) {
            String t = m1.group(0);
            b.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(2).append("[").append(t).append("]").toString()), (Object)BigQueryHelpers.parseTableSpec((String)t)));
        }
        Matcher m2 = this.QUERY_TABLE_SPEC_STANDARD().matcher(sqlQuery);
        while (m2.find()) {
            String t = m2.group(0);
            b.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(2).append("`").append(t).append("`").toString()), (Object)BigQueryHelpers.parseTableSpec((String)t.replaceFirst("\\.", ":"))));
        }
        return (Map)b.result();
    }

    public Set<String> com$spotify$scio$bigquery$BigQueryPartitionUtil$$getPartitions(BigQueryClient bq, TableReference tableRef) {
        String prefix = new StringOps(Predef$.MODULE$.augmentString(tableRef.getTableId())).split('$')[0];
        return (Set)((TraversableOnce)((TraversableLike)bq.getTables(tableRef.getProjectId(), tableRef.getDatasetId()).filter((Function1)new Serializable(prefix){
            public static final long serialVersionUID = 0L;
            private final String prefix$1;

            public final boolean apply(TableReference x$1) {
                return x$1.getTableId().startsWith(this.prefix$1);
            }
            {
                this.prefix$1 = prefix$1;
            }
        })).map((Function1)new Serializable(prefix){
            public static final long serialVersionUID = 0L;
            private final String prefix$1;

            public final String apply(TableReference x$2) {
                return x$2.getTableId().substring(this.prefix$1.length());
            }
            {
                this.prefix$1 = prefix$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).toSet().filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String e) {
                return Longs.tryParse((String)e) != null;
            }
        });
    }

    public String latestQuery(BigQueryClient bq, String sqlQuery) {
        String string;
        Map tables = (Map)this.extractTables(sqlQuery).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, TableReference> x$3) {
                return ((TableReference)x$3._2()).getTableId().endsWith("$LATEST");
            }
        });
        if (tables.isEmpty()) {
            string = sqlQuery;
        } else {
            Set overlaps = (Set)((TraversableOnce)tables.map((Function1)new Serializable(bq){
                public static final long serialVersionUID = 0L;
                private final BigQueryClient bq$1;

                public final Set<String> apply(Tuple2<String, TableReference> t) {
                    return BigQueryPartitionUtil$.MODULE$.com$spotify$scio$bigquery$BigQueryPartitionUtil$$getPartitions(this.bq$1, (TableReference)t._2());
                }
                {
                    this.bq$1 = bq$1;
                }
            }, Iterable$.MODULE$.canBuildFrom())).reduce((Function2)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Set<String> apply(Set<String> x$4, Set<String> x$5) {
                    return (Set)x$4.intersect(x$5);
                }
            });
            Predef$.MODULE$.require(overlaps.nonEmpty(), (Function0)new Serializable(tables){
                public static final long serialVersionUID = 0L;
                private final Map tables$1;

                public final String apply() {
                    return new StringBuilder(40).append("Cannot find latest common partition for ").append(this.tables$1.keys().mkString(", ")).toString();
                }
                {
                    this.tables$1 = tables$1;
                }
            });
            String latest = (String)overlaps.max((Ordering)Ordering.String$.MODULE$);
            string = (String)tables.foldLeft((Object)sqlQuery, (Function2)new Serializable(latest){
                public static final long serialVersionUID = 0L;
                private final String latest$1;

                public final String apply(String x0$1, Tuple2<String, TableReference> x1$1) {
                    Tuple2 tuple2;
                    String q;
                    block3: {
                        Tuple2 tuple22;
                        block2: {
                            tuple22 = new Tuple2((Object)x0$1, x1$1);
                            if (tuple22 == null) break block2;
                            q = (String)tuple22._1();
                            tuple2 = (Tuple2)tuple22._2();
                            if (tuple2 != null) break block3;
                        }
                        throw new MatchError((Object)tuple22);
                    }
                    String spec = (String)tuple2._1();
                    String string = q.replace(spec, spec.replace("$LATEST", this.latest$1));
                    return string;
                }
                {
                    this.latest$1 = latest$1;
                }
            });
        }
        return string;
    }

    public String latestTable(BigQueryClient bq, String tableSpec) {
        String string;
        TableReference ref = BigQueryHelpers.parseTableSpec((String)tableSpec);
        if (ref.getTableId().endsWith("$LATEST")) {
            Set<String> partitions = this.com$spotify$scio$bigquery$BigQueryPartitionUtil$$getPartitions(bq, ref);
            Predef$.MODULE$.require(partitions.nonEmpty(), (Function0)new Serializable(tableSpec){
                public static final long serialVersionUID = 0L;
                private final String tableSpec$1;

                public final String apply() {
                    return new StringBuilder(33).append("Cannot find latest partition for ").append(this.tableSpec$1).toString();
                }
                {
                    this.tableSpec$1 = tableSpec$1;
                }
            });
            string = tableSpec.replace("$LATEST", (CharSequence)partitions.max((Ordering)Ordering.String$.MODULE$));
        } else {
            string = tableSpec;
        }
        return string;
    }

    private BigQueryPartitionUtil$() {
        MODULE$ = this;
        this.PROJECT_ID_REGEXP = "[a-z][-a-z0-9:.]{4,61}[a-z0-9]";
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
        this.DATASET_REGEXP = "[-\\w.]{1,1024}";
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
        this.TABLE_REGEXP = "[-\\w$@]{1,1024}($LATEST)?";
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 4);
        this.DATASET_TABLE_REGEXP_LEGACY = new StringBuilder(40).append("((?<PROJECT>").append(this.PROJECT_ID_REGEXP()).append("):)?(?<DATASET>").append(this.DATASET_REGEXP()).append(")\\.(?<TABLE>").append(this.TABLE_REGEXP()).append(")").toString();
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 8);
        this.DATASET_TABLE_REGEXP_STANDARD = new StringBuilder(40).append("((?<PROJECT>").append(this.PROJECT_ID_REGEXP()).append(").)?(?<DATASET>").append(this.DATASET_REGEXP()).append(")\\.(?<TABLE>").append(this.TABLE_REGEXP()).append(")").toString();
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 0x10);
        this.QUERY_TABLE_SPEC_LEGACY = Pattern.compile(new StringBuilder(13).append("(?<=\\[)").append(this.DATASET_TABLE_REGEXP_LEGACY()).append("(?=\\])").toString());
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 0x20);
        this.QUERY_TABLE_SPEC_STANDARD = Pattern.compile(new StringBuilder(13).append("(?<=\\`)").append(this.DATASET_TABLE_REGEXP_STANDARD()).append("(?=\\`)").toString());
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 0x40);
    }
}

