/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.scio.bigquery.client;

import com.google.api.services.bigquery.model.Job;
import com.google.api.services.bigquery.model.JobStatistics;
import com.spotify.scio.bigquery.client.BigQueryJob;
import com.spotify.scio.bigquery.client.ExtractJob;
import com.spotify.scio.bigquery.client.LoadJob;
import com.spotify.scio.bigquery.client.QueryJob;
import org.apache.commons.io.FileUtils;
import org.joda.time.Period;
import org.joda.time.ReadablePeriod;
import org.joda.time.format.PeriodFormatter;
import org.joda.time.format.PeriodFormatterBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.UninitializedFieldError;
import scala.collection.TraversableOnce;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;

public final class JobOps$ {
    public static JobOps$ MODULE$;
    private final Logger com$spotify$scio$bigquery$client$JobOps$$Logger;
    private final PeriodFormatter PeriodFormatter;
    private volatile byte bitmap$init$0;

    static {
        new JobOps$();
    }

    public Logger com$spotify$scio$bigquery$client$JobOps$$Logger() {
        if ((byte)(this.bitmap$init$0 & 1) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/scio/scio/scio-google-cloud-platform/src/main/scala/com/spotify/scio/bigquery/client/JobOps.scala: 32");
        }
        return this.com$spotify$scio$bigquery$client$JobOps$$Logger;
    }

    private PeriodFormatter PeriodFormatter() {
        if ((byte)(this.bitmap$init$0 & 2) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/scio/scio/scio-google-cloud-platform/src/main/scala/com/spotify/scio/bigquery/client/JobOps.scala: 34");
        }
        return this.PeriodFormatter;
    }

    public void com$spotify$scio$bigquery$client$JobOps$$logJobStatistics(BigQueryJob bqJob, Job job) {
        JobStatistics stats = job.getStatistics();
        this.com$spotify$scio$bigquery$client$JobOps$$Logger().info(new StringBuilder(10).append(bqJob.show()).append(" completed").toString());
        BigQueryJob bigQueryJob = bqJob;
        if (bigQueryJob instanceof ExtractJob) {
            Long destinationFileCount = (Long)((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(stats.getExtract().getDestinationUriFileCounts()).asScala()).reduce((Function2)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Long apply(Long x$1, Long x$2) {
                    return Predef$.MODULE$.long2Long(Predef$.MODULE$.Long2long(x$1) + Predef$.MODULE$.Long2long(x$2));
                }
            });
            this.com$spotify$scio$bigquery$client$JobOps$$Logger().info(new StringBuilder(30).append("Total destination file count: ").append(destinationFileCount).toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (bigQueryJob instanceof LoadJob) {
            String inputFileBytes = FileUtils.byteCountToDisplaySize((long)Predef$.MODULE$.Long2long(stats.getLoad().getInputFileBytes()));
            String outputBytes = FileUtils.byteCountToDisplaySize((long)Predef$.MODULE$.Long2long(stats.getLoad().getOutputBytes()));
            Long outputRows = stats.getLoad().getOutputRows();
            this.com$spotify$scio$bigquery$client$JobOps$$Logger().info(new StringBuilder(49).append("Input file bytes: ").append(inputFileBytes).append(", output bytes: ").append(outputBytes).append(", ").append("output rows: ").append(outputRows).toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (bigQueryJob instanceof QueryJob) {
            QueryJob queryJob = (QueryJob)bigQueryJob;
            this.com$spotify$scio$bigquery$client$JobOps$$Logger().info(new StringBuilder(9).append("Query: `").append(queryJob.query()).append("`").toString());
            String bytes = FileUtils.byteCountToDisplaySize((long)Predef$.MODULE$.Long2long(stats.getQuery().getTotalBytesProcessed()));
            Boolean cacheHit = stats.getQuery().getCacheHit();
            this.com$spotify$scio$bigquery$client$JobOps$$Logger().info(new StringBuilder(36).append("Total bytes processed: ").append(bytes).append(", cache hit: ").append(cacheHit).toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)bigQueryJob);
        }
        String elapsed = this.PeriodFormatter().print((ReadablePeriod)new Period(Predef$.MODULE$.Long2long(stats.getEndTime()) - Predef$.MODULE$.Long2long(stats.getCreationTime())));
        String pending = this.PeriodFormatter().print((ReadablePeriod)new Period(Predef$.MODULE$.Long2long(stats.getStartTime()) - Predef$.MODULE$.Long2long(stats.getCreationTime())));
        String execution = this.PeriodFormatter().print((ReadablePeriod)new Period(Predef$.MODULE$.Long2long(stats.getEndTime()) - Predef$.MODULE$.Long2long(stats.getStartTime())));
        this.com$spotify$scio$bigquery$client$JobOps$$Logger().info(new StringBuilder(33).append("Elapsed: ").append(elapsed).append(", pending: ").append(pending).append(", execution: ").append(execution).toString());
    }

    private JobOps$() {
        MODULE$ = this;
        this.com$spotify$scio$bigquery$client$JobOps$$Logger = LoggerFactory.getLogger(this.getClass());
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
        this.PeriodFormatter = new PeriodFormatterBuilder().appendHours().appendSuffix("h").appendMinutes().appendSuffix("m").appendSecondsWithOptionalMillis().appendSuffix("s").toFormatter();
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
    }
}

