/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.scio.bigquery.client;

import com.google.api.services.bigquery.model.ErrorProto;
import com.google.api.services.bigquery.model.Job;
import com.google.api.services.bigquery.model.JobReference;
import com.spotify.scio.bigquery.client.BigQuery;
import com.spotify.scio.bigquery.client.BigQueryJob;
import com.spotify.scio.bigquery.client.JobOps$;
import java.io.IOException;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001Q<a\u0001D\u0007\t\u000259bAB\r\u000e\u0011\u0003i!\u0004C\u0003\"\u0003\u0011\u00051\u0005C\u0004%\u0003\t\u0007I\u0011B\u0013\t\r9\n\u0001\u0015!\u0003'\u0011\u001dy\u0013A1A\u0005\nABaaO\u0001!\u0002\u0013\t\u0004\"\u0002\u001f\u0002\t\u0013id!B\r\u000e\u00055)\u0006\u0002\u0003\b\t\u0005\u0003\u0005\u000b\u0011\u0002,\t\u000b\u0005BA\u0011\u00016\t\u000b5DA\u0011\u00018\u0002\r){'m\u00149t\u0015\tqq\"\u0001\u0004dY&,g\u000e\u001e\u0006\u0003!E\t\u0001BY5hcV,'/\u001f\u0006\u0003%M\tAa]2j_*\u0011A#F\u0001\bgB|G/\u001b4z\u0015\u00051\u0012aA2p[B\u0011\u0001$A\u0007\u0002\u001b\t1!j\u001c2PaN\u001c\"!A\u000e\u0011\u0005qyR\"A\u000f\u000b\u0003y\tQa]2bY\u0006L!\u0001I\u000f\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}\r\u0001A#A\f\u0002\r1{wmZ3s+\u00051\u0003CA\u0014-\u001b\u0005A#BA\u0015+\u0003\u0015\u0019HN\u001a\u001bk\u0015\u0005Y\u0013aA8sO&\u0011Q\u0006\u000b\u0002\u0007\u0019><w-\u001a:\u0002\u000f1{wmZ3sA\u0005y\u0001+\u001a:j_\u00124uN]7biR,'/F\u00012!\t\u0011\u0014(D\u00014\u0015\t!T'\u0001\u0004g_Jl\u0017\r\u001e\u0006\u0003m]\nA\u0001^5nK*\u0011\u0001HK\u0001\u0005U>$\u0017-\u0003\u0002;g\ty\u0001+\u001a:j_\u00124uN]7biR,'/\u0001\tQKJLw\u000e\u001a$pe6\fG\u000f^3sA\u0005\u0001Bn\\4K_\n\u001cF/\u0019;jgRL7m\u001d\u000b\u0004}\u00053\u0005C\u0001\u000f@\u0013\t\u0001UD\u0001\u0003V]&$\b\"\u0002\"\b\u0001\u0004\u0019\u0015!\u00022r\u0015>\u0014\u0007C\u0001\rE\u0013\t)UBA\u0006CS\u001e\fV/\u001a:z\u0015>\u0014\u0007\"B$\b\u0001\u0004A\u0015a\u00016pEB\u0011\u0011jU\u0007\u0002\u0015*\u00111\nT\u0001\u0006[>$W\r\u001c\u0006\u0003!5S!AT(\u0002\u0011M,'O^5dKNT!\u0001U)\u0002\u0007\u0005\u0004\u0018N\u0003\u0002S+\u00051qm\\8hY\u0016L!\u0001\u0016&\u0003\u0007){'m\u0005\u0002\t7A\u0011qk\u001a\b\u00031\u0016t!!\u00173\u000f\u0005i\u001bgBA.c\u001d\ta\u0016M\u0004\u0002^A6\taL\u0003\u0002`E\u00051AH]8pizJ\u0011AF\u0005\u0003)UI!AE\n\n\u0005A\t\u0012B\u0001\b\u0010\u0013\t1W\"\u0001\u0005CS\u001e\fV/\u001a:z\u0013\tA\u0017N\u0001\u0004DY&,g\u000e\u001e\u0006\u0003M6!\"a\u001b7\u0011\u0005aA\u0001\"\u0002\b\u000b\u0001\u00041\u0016aC<bSR4uN\u001d&pEN$\"AP8\t\u000bA\\\u0001\u0019A9\u0002\t)|'m\u001d\t\u00049I\u001c\u0015BA:\u001e\u0005)a$/\u001a9fCR,GM\u0010")
public final class JobOps {
    public final BigQuery.Client com$spotify$scio$bigquery$client$JobOps$$client;

    public void waitForJobs(Seq<BigQueryJob> jobs) {
        int numTotal = jobs.size();
        Seq pendingJobs = (Seq)jobs.flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Iterable<Tuple2<BigQueryJob, JobReference>> apply(BigQueryJob job) {
                Iterable iterable;
                Option<JobReference> option = job.jobReference();
                if (option instanceof Some) {
                    Some some = (Some)option;
                    JobReference reference = (JobReference)some.value();
                    iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)new Tuple2((Object)job, (Object)reference)));
                } else if (None$.MODULE$.equals(option)) {
                    iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                } else {
                    throw new MatchError(option);
                }
                return iterable;
            }
        }, Seq$.MODULE$.canBuildFrom());
        while (pendingJobs.nonEmpty()) {
            Seq remainingJobs;
            pendingJobs = remainingJobs = (Seq)pendingJobs.filter((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ JobOps $outer;

                public final boolean apply(Tuple2<BigQueryJob, JobReference> x0$1) {
                    boolean bl;
                    Tuple2<BigQueryJob, JobReference> tuple2 = x0$1;
                    if (tuple2 != null) {
                        BigQueryJob bqJob = (BigQueryJob)tuple2._1();
                        JobReference jobReference = (JobReference)tuple2._2();
                        String jobId = jobReference.getJobId();
                        try {
                            Job poll = (Job)this.$outer.com$spotify$scio$bigquery$client$JobOps$$client.underlying().jobs().get(this.$outer.com$spotify$scio$bigquery$client$JobOps$$client.project(), jobId).setLocation(jobReference.getLocation()).execute();
                            ErrorProto error = poll.getStatus().getErrorResult();
                            if (error != null) {
                                throw new RuntimeException(new StringBuilder(20).append(bqJob.show()).append(" failed with error: ").append(error).toString());
                            }
                            String string = poll.getStatus().getState();
                            String string2 = "DONE";
                            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                                JobOps$.MODULE$.com$spotify$scio$bigquery$client$JobOps$$logJobStatistics(bqJob, poll);
                                bl = false;
                            } else {
                                bl = true;
                            }
                        }
                        catch (IOException e) {
                            JobOps$.MODULE$.com$spotify$scio$bigquery$client$JobOps$$Logger().warn(new StringBuilder(38).append("BigQuery request failed: id: ").append(jobId).append(", error: ").append(e).toString());
                            bl = true;
                        }
                    } else {
                        throw new MatchError(tuple2);
                    }
                    boolean bl2 = bl;
                    return bl2;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            int numDone = numTotal - pendingJobs.size();
            JobOps$.MODULE$.com$spotify$scio$bigquery$client$JobOps$$Logger().info(new StringBuilder(23).append("Job: ").append(numDone).append(" out of ").append(numTotal).append(" completed").toString());
            if (!pendingJobs.nonEmpty()) continue;
            Thread.sleep(10000L);
        }
    }

    public JobOps(BigQuery.Client client) {
        this.com$spotify$scio$bigquery$client$JobOps$$client = client;
    }
}

