/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.scio.bigquery.types;

import com.google.api.services.bigquery.model.TableFieldSchema;
import com.google.api.services.bigquery.model.TableSchema;
import com.spotify.scio.bigquery.types.NameProvider$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.UninitializedFieldError;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;

public final class SchemaUtil$ {
    public static SchemaUtil$ MODULE$;
    private final Seq<String> scalaReservedWords;
    private volatile boolean bitmap$init$0;

    static {
        new SchemaUtil$();
    }

    public String toPrettyString(TableSchema schema2, String name, int indent) {
        return new StringBuilder(22).append("@BigQueryType.toTable\n").append(this.getCaseClass(schema2.getFields(), name, indent)).toString();
    }

    private Tuple2<String, Seq<String>> getRawType(TableFieldSchema tfs, int indent) {
        Tuple2 tuple2;
        String string;
        String string2 = tfs.getType();
        if ("BOOLEAN".equals(string2)) {
            string = "Boolean";
        } else {
            boolean bl = "INTEGER".equals(string2) ? true : "INT64".equals(string2);
            if (bl) {
                string = "Long";
            } else {
                boolean bl2 = "FLOAT".equals(string2) ? true : "FLOAT64".equals(string2);
                if (bl2) {
                    string = "Double";
                } else if ("STRING".equals(string2)) {
                    string = "String";
                } else if ("NUMERIC".equals(string2)) {
                    string = "BigDecimal";
                } else if ("BYTES".equals(string2)) {
                    string = "ByteString";
                } else if ("TIMESTAMP".equals(string2)) {
                    string = "Instant";
                } else if ("DATE".equals(string2)) {
                    string = "LocalDate";
                } else if ("TIME".equals(string2)) {
                    string = "LocalTime";
                } else if ("DATETIME".equals(string2)) {
                    string = "LocalDateTime";
                } else {
                    boolean bl3 = "RECORD".equals(string2) ? true : "STRUCT".equals(string2);
                    if (bl3) {
                        string = NameProvider$.MODULE$.getUniqueName(tfs.getName());
                    } else {
                        throw new IllegalArgumentException(new StringBuilder(20).append("Type: ").append(string2).append(" not supported").toString());
                    }
                }
            }
        }
        String name = string;
        String string3 = tfs.getType();
        String string4 = "RECORD";
        if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
            String nested = this.getCaseClass(tfs.getFields(), name, indent);
            tuple2 = new Tuple2((Object)name, (Object)new .colon.colon((Object)nested, (List)Nil$.MODULE$));
        } else {
            tuple2 = new Tuple2((Object)name, (Object)Nil$.MODULE$);
        }
        return tuple2;
    }

    public Tuple2<String, Seq<String>> com$spotify$scio$bigquery$types$SchemaUtil$$getFieldType(TableFieldSchema tfs, int indent) {
        String string;
        Tuple2<String, Seq<String>> tuple2 = this.getRawType(tfs, indent);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String rawType = (String)tuple2._1();
        Seq nested = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)rawType, (Object)nested);
        Tuple2 tuple23 = tuple22;
        String rawType2 = (String)tuple23._1();
        Seq nested2 = (Seq)tuple23._2();
        String string2 = tfs.getMode();
        boolean bl = "NULLABLE".equals(string2) ? true : string2 == null;
        if (bl) {
            string = new StringBuilder(8).append("Option[").append(rawType2).append("]").toString();
        } else if ("REQUIRED".equals(string2)) {
            string = rawType2;
        } else if ("REPEATED".equals(string2)) {
            string = new StringBuilder(6).append("List[").append(rawType2).append("]").toString();
        } else {
            throw new MatchError((Object)string2);
        }
        String fieldType = string;
        return new Tuple2((Object)fieldType, (Object)nested2);
    }

    private String getCaseClass(java.util.List<TableFieldSchema> fields, String name, int indent) {
        String string;
        Buffer xs = (Buffer)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(fields).asScala()).map((Function1)new Serializable(indent){
            public static final long serialVersionUID = 0L;
            private final int indent$1;

            public final Tuple2<String, Seq<String>> apply(TableFieldSchema f) {
                Tuple2<String, Seq<String>> tuple2 = SchemaUtil$.MODULE$.com$spotify$scio$bigquery$types$SchemaUtil$$getFieldType(f, this.indent$1);
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                String fieldType = (String)tuple2._1();
                Seq nested = (Seq)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)fieldType, (Object)nested);
                Tuple2 tuple23 = tuple22;
                String fieldType2 = (String)tuple23._1();
                Seq nested2 = (Seq)tuple23._2();
                return new Tuple2((Object)new StringBuilder(2).append(SchemaUtil$.MODULE$.escapeNameIfReserved(f.getName())).append(": ").append(fieldType2).toString(), (Object)nested2);
            }
            {
                this.indent$1 = indent$1;
            }
        }, Buffer$.MODULE$.canBuildFrom());
        Buffer lines = (Buffer)xs.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<String, Seq<String>> x$3) {
                return (String)x$3._1();
            }
        }, Buffer$.MODULE$.canBuildFrom());
        Buffer nested = (Buffer)xs.flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Seq<String> apply(Tuple2<String, Seq<String>> x$4) {
                return (Seq)x$4._2();
            }
        }, Buffer$.MODULE$.canBuildFrom());
        scala.collection.mutable.StringBuilder sb = new scala.collection.mutable.StringBuilder();
        sb.append(new StringBuilder(12).append("case class ").append(name).append("(").toString());
        Object object = indent > 0 ? sb.append("\n") : BoxedUnit.UNIT;
        if (indent > 0) {
            String w = new StringOps(Predef$.MODULE$.augmentString(" ")).$times(indent);
            string = ((TraversableOnce)lines.map((Function1)new Serializable(w){
                public static final long serialVersionUID = 0L;
                private final String w$1;

                public final String apply(String x$5) {
                    return new StringBuilder(0).append(this.w$1).append(x$5).toString();
                }
                {
                    this.w$1 = w$1;
                }
            }, Buffer$.MODULE$.canBuildFrom())).mkString(",\n");
        } else {
            string = lines.mkString(", ");
        }
        String body = string;
        sb.append(body);
        sb.append(")");
        String string2 = sb.toString();
        return ((TraversableOnce)nested.$plus$colon((Object)string2, Buffer$.MODULE$.canBuildFrom())).mkString("\n");
    }

    public String escapeNameIfReserved(String name) {
        return this.scalaReservedWords().contains((Object)name) ? new StringBuilder(2).append("`").append(name).append("`").toString() : name;
    }

    public Seq<String> scalaReservedWords() {
        if (!this.bitmap$init$0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/scio/scio/scio-google-cloud-platform/src/main/scala/com/spotify/scio/bigquery/types/SchemaUtil.scala: 99");
        }
        return this.scalaReservedWords;
    }

    private SchemaUtil$() {
        MODULE$ = this;
        this.scalaReservedWords = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"abstract", "case", "catch", "class", "def", "do", "else", "extends", "false", "final", "finally", "for", "forSome", "if", "implicit", "import", "lazy", "match", "new", "null", "object", "override", "package", "private", "protected", "return", "sealed", "super", "this", "throw", "trait", "try", "true", "type", "val", "var", "while", "with", "yield"}));
        this.bitmap$init$0 = true;
    }
}

