/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.scio.bigtable;

import com.google.cloud.bigtable.config.BigtableOptions;
import com.google.cloud.bigtable.grpc.BigtableSession;
import com.google.common.util.concurrent.ListenableFuture;
import com.spotify.scio.transforms.BaseAsyncLookupDoFn;
import com.spotify.scio.transforms.GuavaAsyncLookupDoFn;
import java.io.IOException;

public abstract class BigtableDoFn<A, B>
extends GuavaAsyncLookupDoFn<A, B, BigtableSession> {
    private final BigtableOptions options;

    public abstract ListenableFuture<B> asyncLookup(BigtableSession var1, A var2);

    public BigtableDoFn(BigtableOptions bigtableOptions) {
        this(bigtableOptions, 1000);
    }

    public BigtableDoFn(BigtableOptions bigtableOptions, int n) {
        this(bigtableOptions, n, (BaseAsyncLookupDoFn.CacheSupplier)new BaseAsyncLookupDoFn.NoOpCacheSupplier());
    }

    public <K> BigtableDoFn(BigtableOptions bigtableOptions, int n, BaseAsyncLookupDoFn.CacheSupplier<A, B, K> cacheSupplier) {
        super(n, cacheSupplier);
        this.options = bigtableOptions;
    }

    protected BigtableSession newClient() {
        try {
            return new BigtableSession(this.options);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }
}

