/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.scio.bigtable;

import com.google.bigtable.admin.v2.Cluster;
import com.google.bigtable.admin.v2.ListClustersRequest;
import com.google.bigtable.admin.v2.ListClustersResponse;
import com.google.cloud.bigtable.config.BigtableOptions;
import com.google.cloud.bigtable.grpc.BigtableClusterUtilities;
import com.google.cloud.bigtable.grpc.BigtableInstanceGrpcClient;
import com.google.cloud.bigtable.grpc.io.ChannelPool;
import com.spotify.scio.bigtable.ChannelPoolCreator;
import io.grpc.Channel;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import org.joda.time.Duration;
import org.joda.time.ReadablePeriod;
import org.joda.time.format.PeriodFormatter;
import org.joda.time.format.PeriodFormatterBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BigtableUtil {
    private static final Logger LOG = LoggerFactory.getLogger(BigtableUtil.class);
    private static final PeriodFormatter formatter = new PeriodFormatterBuilder().appendDays().appendSuffix("d").appendHours().appendSuffix("h").appendMinutes().appendSuffix("m").appendSeconds().appendSuffix("s").toFormatter();

    private BigtableUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateNumberOfBigtableNodes(BigtableOptions bigtableOptions, int n, Duration duration) throws IOException, InterruptedException {
        ChannelPool channelPool = ChannelPoolCreator.createPool(bigtableOptions);
        try {
            BigtableInstanceGrpcClient bigtableInstanceGrpcClient = new BigtableInstanceGrpcClient((Channel)channelPool);
            String string = bigtableOptions.getInstanceName().toString();
            ListClustersRequest listClustersRequest = ListClustersRequest.newBuilder().setParent(string).build();
            ListClustersResponse listClustersResponse = bigtableInstanceGrpcClient.listCluster(listClustersRequest);
            for (Cluster cluster : listClustersResponse.getClustersList()) {
                Cluster cluster2 = Cluster.newBuilder().setName(cluster.getName()).setServeNodes(n).build();
                LOG.info("Updating number of nodes to {} for cluster {}", (Object)n, (Object)cluster.getName());
                bigtableInstanceGrpcClient.updateCluster(cluster2);
            }
            if (duration.getMillis() > 0L) {
                LOG.info("Sleeping for {} after update", (Object)formatter.print((ReadablePeriod)duration.toPeriod()));
                Thread.sleep(duration.getMillis());
            }
        }
        finally {
            channelPool.shutdownNow();
        }
    }

    public static Map<String, Integer> getClusterSizes(String string, String string2) throws IOException, GeneralSecurityException {
        try (BigtableClusterUtilities bigtableClusterUtilities = BigtableClusterUtilities.forInstance((String)string, (String)string2);){
            Map<String, Integer> map = Collections.unmodifiableMap(bigtableClusterUtilities.getClusters().getClustersList().stream().collect(Collectors.toMap(cluster -> cluster.getName().substring(cluster.getName().indexOf("/clusters/") + 10), Cluster::getServeNodes)));
            return map;
        }
    }
}

