/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.scio.bigtable;

import com.google.cloud.bigtable.config.BigtableOptions;
import com.google.cloud.bigtable.grpc.BigtableSession;
import com.google.cloud.bigtable.grpc.io.ChannelPool;
import com.google.cloud.bigtable.grpc.io.CredentialInterceptorCache;
import io.grpc.ClientInterceptor;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelPoolCreator {
    private static final Logger LOG = LoggerFactory.getLogger(ChannelPoolCreator.class);

    private static ClientInterceptor[] getClientInterceptors(BigtableOptions bigtableOptions) {
        try {
            ClientInterceptor clientInterceptor = CredentialInterceptorCache.getInstance().getCredentialsInterceptor(bigtableOptions.getCredentialOptions(), bigtableOptions.getRetryOptions());
            if (clientInterceptor == null) {
                return new ClientInterceptor[0];
            }
            return new ClientInterceptor[]{clientInterceptor};
        }
        catch (Exception exception) {
            LOG.error("Failed to get credentials interceptor. No interceptor will be used for the channel.", (Throwable)exception);
            return new ClientInterceptor[0];
        }
    }

    public static ChannelPool createPool(BigtableOptions bigtableOptions) throws IOException {
        ClientInterceptor[] clientInterceptorArray = ChannelPoolCreator.getClientInterceptors(bigtableOptions);
        return new ChannelPool(() -> BigtableSession.createNettyChannel((String)bigtableOptions.getAdminHost(), (BigtableOptions)bigtableOptions, (ClientInterceptor[])clientInterceptorArray), 1);
    }
}

