/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.scio.bigtable;

import com.google.bigtable.admin.v2.ColumnFamily;
import com.google.bigtable.admin.v2.CreateTableRequest;
import com.google.bigtable.admin.v2.DropRowRangeRequest;
import com.google.bigtable.admin.v2.GcRule;
import com.google.bigtable.admin.v2.GetTableRequest;
import com.google.bigtable.admin.v2.ListTablesRequest;
import com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest;
import com.google.bigtable.admin.v2.Table;
import com.google.cloud.bigtable.config.BigtableOptions;
import com.google.cloud.bigtable.grpc.BigtableSessionSharedThreadPools;
import com.google.cloud.bigtable.grpc.BigtableTableAdminClient;
import com.google.cloud.bigtable.grpc.BigtableTableAdminGrpcClient;
import com.google.cloud.bigtable.grpc.io.ChannelPool;
import com.google.protobuf.ByteString;
import com.google.protobuf.Duration;
import com.spotify.scio.bigtable.ChannelPoolCreator;
import com.spotify.scio.bigtable.TableAdmin;
import com.spotify.scio.bigtable.TableAdmin$;
import com.spotify.scio.bigtable.TableAdmin$CreateDisposition$;
import com.spotify.scio.bigtable.TableAdmin$CreateDisposition$CreateIfNeeded$;
import com.spotify.scio.bigtable.TableAdmin$CreateDisposition$Never$;
import io.grpc.Channel;
import java.nio.charset.Charset;
import java.util.concurrent.ScheduledExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.UninitializedFieldError;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer$;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Try;
import scala.util.Try$;

public final class TableAdmin$ {
    public static TableAdmin$ MODULE$;
    private final Logger com$spotify$scio$bigtable$TableAdmin$$log;
    private volatile byte bitmap$init$0;

    static {
        new TableAdmin$();
    }

    public Logger com$spotify$scio$bigtable$TableAdmin$$log() {
        if ((byte)(this.bitmap$init$0 & 2) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/scio/scio/scio-google-cloud-platform/src/main/scala/com/spotify/scio/bigtable/TableAdmin.scala: 43");
        }
        return this.com$spotify$scio$bigtable$TableAdmin$$log;
    }

    private <A> Try<A> adminClient(BigtableOptions bigtableOptions, Function1<BigtableTableAdminClient, A> f) {
        ChannelPool channel = ChannelPoolCreator.createPool(bigtableOptions);
        ScheduledExecutorService executorService = BigtableSessionSharedThreadPools.getInstance().getRetryExecutor();
        BigtableTableAdminGrpcClient client = new BigtableTableAdminGrpcClient((Channel)channel, executorService, bigtableOptions);
        Try result = Try$.MODULE$.apply((Function0)new Serializable(f, client){
            public static final long serialVersionUID = 0L;
            private final Function1 f$1;
            private final BigtableTableAdminGrpcClient client$1;

            public final A apply() {
                return (A)this.f$1.apply((Object)this.client$1);
            }
            {
                this.f$1 = f$1;
                this.client$1 = client$1;
            }
        });
        channel.shutdownNow();
        return result;
    }

    public Set<String> com$spotify$scio$bigtable$TableAdmin$$fetchTables(BigtableTableAdminClient client, String instancePath) {
        return ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(client.listTables(ListTablesRequest.newBuilder().setParent(instancePath).build()).getTablesList()).asScala()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Table x$1) {
                return x$1.getName();
            }
        }, Buffer$.MODULE$.canBuildFrom())).toSet();
    }

    public void ensureTables(BigtableOptions bigtableOptions, Map<String, Iterable<String>> tablesAndColumnFamilies, TableAdmin.CreateDisposition createDisposition) {
        Map tcf = tablesAndColumnFamilies.iterator().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, Iterable<Tuple2<String, None$>>> apply(Tuple2<String, Iterable<String>> x0$1) {
                Tuple2<String, Iterable<String>> tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                String k = (String)tuple2._1();
                Iterable l = (Iterable)tuple2._2();
                Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), l.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<String, None$> apply(String x$2) {
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)x$2), (Object)None$.MODULE$);
                    }
                }, Iterable$.MODULE$.canBuildFrom()));
                return tuple22;
            }
        }).toMap(Predef$.MODULE$.$conforms());
        this.ensureTablesImpl(bigtableOptions, (Map<String, Iterable<Tuple2<String, Option<GcRule>>>>)tcf, createDisposition).get();
    }

    public TableAdmin.CreateDisposition ensureTables$default$3() {
        return TableAdmin$CreateDisposition$.MODULE$.default();
    }

    public void ensureTablesWithExpiration(BigtableOptions bigtableOptions, Map<String, Iterable<Tuple2<String, Option<org.joda.time.Duration>>>> tablesAndColumnFamilies, TableAdmin.CreateDisposition createDisposition) {
        Map x = tablesAndColumnFamilies.iterator().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, Iterable<Tuple2<String, Option<GcRule>>>> apply(Tuple2<String, Iterable<Tuple2<String, Option<org.joda.time.Duration>>>> x0$1) {
                Tuple2<String, Iterable<Tuple2<String, Option<org.joda.time.Duration>>>> tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                String k = (String)tuple2._1();
                Iterable v = (Iterable)tuple2._2();
                Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), v.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<String, Option<GcRule>> apply(Tuple2<String, Option<org.joda.time.Duration>> x0$2) {
                        Tuple2<String, Option<org.joda.time.Duration>> tuple2 = x0$2;
                        if (tuple2 == null) {
                            throw new MatchError(tuple2);
                        }
                        String columnFamily = (String)tuple2._1();
                        Option duration = (Option)tuple2._2();
                        Tuple2 tuple22 = new Tuple2((Object)columnFamily, (Object)duration.map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final GcRule apply(org.joda.time.Duration duration) {
                                return TableAdmin$.MODULE$.com$spotify$scio$bigtable$TableAdmin$$gcRuleFromDuration(duration);
                            }
                        }));
                        return tuple22;
                    }
                }, Iterable$.MODULE$.canBuildFrom()));
                return tuple22;
            }
        }).toMap(Predef$.MODULE$.$conforms());
        this.ensureTablesImpl(bigtableOptions, (Map<String, Iterable<Tuple2<String, Option<GcRule>>>>)x, createDisposition).get();
    }

    public TableAdmin.CreateDisposition ensureTablesWithExpiration$default$3() {
        return TableAdmin$CreateDisposition$.MODULE$.default();
    }

    public void ensureTablesWithGcRules(BigtableOptions bigtableOptions, Map<String, Iterable<Tuple2<String, Option<GcRule>>>> tablesAndColumnFamilies, TableAdmin.CreateDisposition createDisposition) {
        this.ensureTablesImpl(bigtableOptions, tablesAndColumnFamilies, createDisposition).get();
    }

    public TableAdmin.CreateDisposition ensureTablesWithGcRules$default$3() {
        return TableAdmin$CreateDisposition$.MODULE$.default();
    }

    private Try<BoxedUnit> ensureTablesImpl(BigtableOptions bigtableOptions, Map<String, Iterable<Tuple2<String, Option<GcRule>>>> tablesAndColumnFamilies, TableAdmin.CreateDisposition createDisposition) {
        String project = bigtableOptions.getProjectId();
        String instance2 = bigtableOptions.getInstanceId();
        String instancePath = new StringBuilder(20).append("projects/").append(project).append("/instances/").append(instance2).toString();
        this.com$spotify$scio$bigtable$TableAdmin$$log().info("Ensuring tables and column families exist in instance {}", new Object[]{instance2});
        return this.adminClient(bigtableOptions, (Function1)new Serializable(instancePath, tablesAndColumnFamilies, createDisposition){
            public static final long serialVersionUID = 0L;
            public final String instancePath$1;
            private final Map tablesAndColumnFamilies$1;
            public final TableAdmin.CreateDisposition createDisposition$1;

            public final void apply(BigtableTableAdminClient client) {
                Set<String> existingTables = TableAdmin$.MODULE$.com$spotify$scio$bigtable$TableAdmin$$fetchTables(client, this.instancePath$1);
                this.tablesAndColumnFamilies$1.foreach((Function1)new Serializable(this, existingTables, client){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.ensureTablesImpl.1 $outer;
                    private final Set existingTables$1;
                    private final BigtableTableAdminClient client$2;

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final void apply(Tuple2<String, Iterable<Tuple2<String, Option<GcRule>>>> x0$1) {
                        BoxedUnit boxedUnit;
                        Tuple2<String, Iterable<Tuple2<String, Option<GcRule>>>> tuple2 = x0$1;
                        if (tuple2 == null) throw new MatchError(tuple2);
                        String table2 = (String)tuple2._1();
                        Iterable columnFamilies = (Iterable)tuple2._2();
                        String tablePath = new StringBuilder(8).append(this.$outer.instancePath$1).append("/tables/").append(table2).toString();
                        boolean exists = this.existingTables$1.contains((Object)tablePath);
                        TableAdmin.CreateDisposition createDisposition = this.$outer.createDisposition$1;
                        if (exists) {
                            TableAdmin$.MODULE$.com$spotify$scio$bigtable$TableAdmin$$log().info("Table {} exists", new Object[]{table2});
                            boxedUnit = BoxedUnit.UNIT;
                        } else if (TableAdmin$CreateDisposition$CreateIfNeeded$.MODULE$.equals(createDisposition)) {
                            TableAdmin$.MODULE$.com$spotify$scio$bigtable$TableAdmin$$log().info("Creating table {}", new Object[]{table2});
                            boxedUnit = this.client$2.createTable(CreateTableRequest.newBuilder().setParent(this.$outer.instancePath$1).setTableId(table2).build());
                        } else {
                            if (!TableAdmin$CreateDisposition$Never$.MODULE$.equals(createDisposition)) throw new MatchError((Object)createDisposition);
                            throw new IllegalStateException(new StringBuilder(21).append("Table ").append(table2).append(" does not exist").toString());
                        }
                        TableAdmin$.MODULE$.com$spotify$scio$bigtable$TableAdmin$$ensureColumnFamilies(this.client$2, tablePath, (Iterable<Tuple2<String, Option<GcRule>>>)columnFamilies, this.$outer.createDisposition$1);
                        BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.existingTables$1 = existingTables$1;
                        this.client$2 = client$2;
                    }
                });
            }
            {
                this.instancePath$1 = instancePath$1;
                this.tablesAndColumnFamilies$1 = tablesAndColumnFamilies$1;
                this.createDisposition$1 = createDisposition$1;
            }
        });
    }

    public void com$spotify$scio$bigtable$TableAdmin$$ensureColumnFamilies(BigtableTableAdminClient client, String tablePath, Iterable<Tuple2<String, Option<GcRule>>> columnFamilies, TableAdmin.CreateDisposition createDisposition) {
        TableAdmin.CreateDisposition createDisposition2 = createDisposition;
        if (TableAdmin$CreateDisposition$CreateIfNeeded$.MODULE$.equals(createDisposition2)) {
            Table tableInfo = client.getTable(GetTableRequest.newBuilder().setName(tablePath).build());
            Iterable cfList = (Iterable)columnFamilies.map((Function1)new Serializable(tableInfo){
                public static final long serialVersionUID = 0L;
                private final Table tableInfo$1;

                public final Tuple2<String, ColumnFamily> apply(Tuple2<String, Option<GcRule>> x0$1) {
                    Tuple2<String, Option<GcRule>> tuple2 = x0$1;
                    if (tuple2 == null) {
                        throw new MatchError(tuple2);
                    }
                    String n = (String)tuple2._1();
                    Option gcRule = (Option)tuple2._2();
                    ColumnFamily cf = this.tableInfo$1.getColumnFamiliesOrDefault(n, ColumnFamily.newBuilder().build()).toBuilder().setGcRule((GcRule)gcRule.getOrElse((Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final GcRule apply() {
                            return GcRule.getDefaultInstance();
                        }
                    })).build();
                    Tuple2 tuple22 = new Tuple2((Object)n, (Object)cf);
                    return tuple22;
                }
                {
                    this.tableInfo$1 = tableInfo$1;
                }
            }, Iterable$.MODULE$.canBuildFrom());
            Iterable modifications = (Iterable)cfList.map((Function1)new Serializable(tableInfo){
                public static final long serialVersionUID = 0L;
                private final Table tableInfo$1;

                public final ModifyColumnFamiliesRequest.Modification apply(Tuple2<String, ColumnFamily> x0$2) {
                    Tuple2<String, ColumnFamily> tuple2 = x0$2;
                    if (tuple2 == null) {
                        throw new MatchError(tuple2);
                    }
                    String n = (String)tuple2._1();
                    ColumnFamily cf = (ColumnFamily)tuple2._2();
                    ModifyColumnFamiliesRequest.Modification.Builder mod = ModifyColumnFamiliesRequest.Modification.newBuilder().setId(n);
                    ModifyColumnFamiliesRequest.Modification.Builder builder = this.tableInfo$1.containsColumnFamilies(n) ? mod.setUpdate(cf) : mod.setCreate(cf);
                    ModifyColumnFamiliesRequest.Modification modification = mod.build();
                    return modification;
                }
                {
                    this.tableInfo$1 = tableInfo$1;
                }
            }, Iterable$.MODULE$.canBuildFrom());
            this.com$spotify$scio$bigtable$TableAdmin$$log().info("Modifying or updating {} column families for table {}", (Object)BoxesRunTime.boxToInteger((int)modifications.size()), (Object)tablePath);
            Object object = modifications.nonEmpty() ? client.modifyColumnFamily(ModifyColumnFamiliesRequest.newBuilder().setName(tablePath).addAllModifications((java.lang.Iterable)CollectionConverters$.MODULE$.asJavaIterableConverter(modifications).asJava()).build()) : BoxedUnit.UNIT;
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (TableAdmin$CreateDisposition$Never$.MODULE$.equals(createDisposition2)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)createDisposition2);
        }
    }

    public GcRule com$spotify$scio$bigtable$TableAdmin$$gcRuleFromDuration(org.joda.time.Duration duration) {
        Duration.Builder protoDuration = Duration.newBuilder().setSeconds(duration.getStandardSeconds());
        return GcRule.newBuilder().setMaxAge(protoDuration).build();
    }

    public Try<BoxedUnit> dropRowRange(BigtableOptions bigtableOptions, String table2, String rowPrefix) {
        return this.adminClient(bigtableOptions, (Function1)new Serializable(bigtableOptions, table2, rowPrefix){
            public static final long serialVersionUID = 0L;
            private final BigtableOptions bigtableOptions$1;
            private final String table$1;
            private final String rowPrefix$1;

            public final void apply(BigtableTableAdminClient client) {
                String project = this.bigtableOptions$1.getProjectId();
                String instance2 = this.bigtableOptions$1.getInstanceId();
                String instancePath = new StringBuilder(20).append("projects/").append(project).append("/instances/").append(instance2).toString();
                String tablePath = new StringBuilder(8).append(instancePath).append("/tables/").append(this.table$1).toString();
                TableAdmin$.MODULE$.com$spotify$scio$bigtable$TableAdmin$$dropRowRange(tablePath, this.rowPrefix$1, client);
            }
            {
                this.bigtableOptions$1 = bigtableOptions$1;
                this.table$1 = table$1;
                this.rowPrefix$1 = rowPrefix$1;
            }
        });
    }

    public void com$spotify$scio$bigtable$TableAdmin$$dropRowRange(String tablePath, String rowPrefix, BigtableTableAdminClient client) {
        DropRowRangeRequest request = DropRowRangeRequest.newBuilder().setName(tablePath).setRowKeyPrefix(ByteString.copyFrom((String)rowPrefix, (Charset)Charset.forName("UTF-8"))).build();
        client.dropRowRange(request);
    }

    private TableAdmin$() {
        MODULE$ = this;
        this.com$spotify$scio$bigtable$TableAdmin$$log = LoggerFactory.getLogger(this.getClass());
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
    }
}

