/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.TableFieldSchema;
import com.google.api.services.bigquery.model.TableRow;
import com.google.api.services.bigquery.model.TableSchema;
import java.util.ArrayList;
import java.util.List;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryAvroUtils;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;

public class BigQueryAvroUtilsWrapper {
    static final ImmutableMap<String, Schema.Type> BIG_QUERY_TO_AVRO_TYPES = ImmutableMap.builder().put((Object)"STRING", (Object)Schema.Type.STRING).put((Object)"GEOGRAPHY", (Object)Schema.Type.STRING).put((Object)"BYTES", (Object)Schema.Type.BYTES).put((Object)"INTEGER", (Object)Schema.Type.LONG).put((Object)"FLOAT", (Object)Schema.Type.DOUBLE).put((Object)"NUMERIC", (Object)Schema.Type.BYTES).put((Object)"BOOLEAN", (Object)Schema.Type.BOOLEAN).put((Object)"TIMESTAMP", (Object)Schema.Type.LONG).put((Object)"RECORD", (Object)Schema.Type.RECORD).put((Object)"DATE", (Object)Schema.Type.INT).put((Object)"DATETIME", (Object)Schema.Type.STRING).put((Object)"TIME", (Object)Schema.Type.LONG).build();

    public static TableRow convertGenericRecordToTableRow(GenericRecord genericRecord2, TableSchema tableSchema) {
        return BigQueryAvroUtils.convertGenericRecordToTableRow((GenericRecord)genericRecord2, (TableSchema)tableSchema);
    }

    public static Schema toGenericAvroSchema(String string, List<TableFieldSchema> list) {
        ArrayList<Schema.Field> arrayList = new ArrayList<Schema.Field>();
        for (TableFieldSchema tableFieldSchema : list) {
            arrayList.add(BigQueryAvroUtilsWrapper.convertField(tableFieldSchema));
        }
        return Schema.createRecord((String)string, (String)("Translated Avro Schema for " + string), (String)"org.apache.beam.sdk.io.gcp.bigquery", (boolean)false, arrayList);
    }

    private static Schema.Field convertField(TableFieldSchema tableFieldSchema) {
        Schema schema2;
        Schema schema3;
        Schema.Type type = (Schema.Type)BIG_QUERY_TO_AVRO_TYPES.get((Object)tableFieldSchema.getType());
        if (type == null) {
            throw new IllegalArgumentException("Unable to map BigQuery field type " + tableFieldSchema.getType() + " to avro type.");
        }
        if (type == Schema.Type.RECORD) {
            schema3 = BigQueryAvroUtilsWrapper.toGenericAvroSchema(tableFieldSchema.getName(), tableFieldSchema.getFields());
        } else {
            schema3 = Schema.create((Schema.Type)type);
            if (tableFieldSchema.getType().equals("DATE")) {
                schema3 = LogicalTypes.date().addToSchema(schema3);
            }
            if (tableFieldSchema.getType().equals("TIME")) {
                schema3 = LogicalTypes.timeMicros().addToSchema(schema3);
            }
            if (tableFieldSchema.getType().equals("DATETIME") && type != Schema.Type.STRING) {
                throw new IllegalArgumentException("DateTime type is not supported");
            }
        }
        if (tableFieldSchema.getMode() == null || "NULLABLE".equals(tableFieldSchema.getMode())) {
            schema2 = Schema.createUnion((Schema[])new Schema[]{Schema.create((Schema.Type)Schema.Type.NULL), schema3});
        } else if ("REQUIRED".equals(tableFieldSchema.getMode())) {
            schema2 = schema3;
        } else if ("REPEATED".equals(tableFieldSchema.getMode())) {
            schema2 = Schema.createArray((Schema)schema3);
        } else {
            throw new IllegalArgumentException(String.format("Unknown BigQuery Field Mode: %s", tableFieldSchema.getMode()));
        }
        return new Schema.Field(tableFieldSchema.getName(), schema2, tableFieldSchema.getDescription(), null);
    }
}

