/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.styx.cli;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.spotify.styx.api.BackfillPayload;
import com.spotify.styx.api.RunStateDataPayload;
import com.spotify.styx.cli.CliOutput;
import com.spotify.styx.cli.CliUtil;
import com.spotify.styx.model.Backfill;
import com.spotify.styx.model.Resource;
import com.spotify.styx.model.Workflow;
import com.spotify.styx.model.WorkflowId;
import com.spotify.styx.model.WorkflowState;
import com.spotify.styx.model.WorkflowWithState;
import com.spotify.styx.model.data.EventInfo;
import com.spotify.styx.serialization.Json;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

class JsonCliOutput
implements CliOutput {
    JsonCliOutput() {
    }

    private static void printJson(Object object) {
        try {
            System.out.println(Json.serialize((Object)object).utf8());
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void printStates(RunStateDataPayload runStateDataPayload) {
        JsonCliOutput.printJson(CliUtil.groupStates(runStateDataPayload.activeStates()).entrySet().stream().collect(Collectors.toMap(e -> ((WorkflowId)e.getKey()).toKey(), Map.Entry::getValue)));
    }

    @Override
    public void printEvents(List<EventInfo> eventInfos) {
        JsonCliOutput.printJson(eventInfos);
    }

    @Override
    public void printBackfill(Backfill backfill, boolean ignored) {
        JsonCliOutput.printJson(backfill);
    }

    @Override
    public void printBackfillPayload(BackfillPayload backfillPayload, boolean ignored) {
        JsonCliOutput.printJson(backfillPayload);
    }

    @Override
    public void printBackfills(List<BackfillPayload> backfills, boolean ignored) {
        JsonCliOutput.printJson(backfills);
    }

    @Override
    public void printResources(List<Resource> resources) {
        JsonCliOutput.printJson(resources);
    }

    @Override
    public void printMessage(String message) {
        JsonCliOutput.printJson(message);
    }

    @Override
    public void printWorkflow(Workflow workflow, WorkflowState state) {
        JsonCliOutput.printJson(WorkflowWithState.create((Workflow)workflow, (WorkflowState)state));
    }

    @Override
    public void printWorkflows(List<Workflow> workflows) {
        JsonCliOutput.printJson(workflows);
    }

    @Override
    public void printError(String message) {
        System.err.println(message);
    }
}

