/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.styx.cli;

import com.fasterxml.jackson.databind.MappingIterator;
import com.fasterxml.jackson.databind.ObjectReader;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.spotify.logging.LoggingConfigurator;
import com.spotify.styx.api.BackfillPayload;
import com.spotify.styx.api.BackfillsPayload;
import com.spotify.styx.api.ResourcesPayload;
import com.spotify.styx.api.RunStateDataPayload;
import com.spotify.styx.api.TestServiceAccountUsageAuthorizationResponse;
import com.spotify.styx.cli.CliExitException;
import com.spotify.styx.cli.CliOutput;
import com.spotify.styx.cli.JsonCliOutput;
import com.spotify.styx.cli.PlainCliOutput;
import com.spotify.styx.cli.PrettyCliOutput;
import com.spotify.styx.client.ApiErrorException;
import com.spotify.styx.client.ClientErrorException;
import com.spotify.styx.client.InputErrorException;
import com.spotify.styx.client.StyxClient;
import com.spotify.styx.client.StyxClientFactory;
import com.spotify.styx.model.Backfill;
import com.spotify.styx.model.BackfillInput;
import com.spotify.styx.model.Resource;
import com.spotify.styx.model.TriggerParameters;
import com.spotify.styx.model.Workflow;
import com.spotify.styx.model.WorkflowConfiguration;
import com.spotify.styx.model.WorkflowState;
import com.spotify.styx.model.WorkflowWithState;
import com.spotify.styx.serialization.Json;
import com.spotify.styx.util.BasicWorkflowValidator;
import com.spotify.styx.util.DockerImageValidator;
import com.spotify.styx.util.ParameterUtil;
import com.spotify.styx.util.WorkflowValidator;
import java.io.File;
import java.io.IOException;
import java.time.Instant;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import javaslang.Tuple;
import javaslang.Tuple2;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.helper.HelpScreenException;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.Argument;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.ArgumentGroup;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import net.sourceforge.argparse4j.inf.ArgumentType;
import net.sourceforge.argparse4j.inf.FeatureControl;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import net.sourceforge.argparse4j.inf.Subparsers;

public final class CliMain {
    private static final String ENV_VAR_PREFIX = "STYX_CLI";
    private static final String COMMAND_DEST = "command";
    private static final String SUBCOMMAND_DEST = "subcommand";
    private static final String COMPONENT_DEST = "component";
    private static final String WORKFLOW_DEST = "workflow";
    private static final String PARAMETER_DEST = "parameter";
    private static final String STYX_CLI_VERSION = "Styx CLI " + CliMain.class.getPackage().getImplementationVersion();
    private final StyxCliParser parser;
    private final Namespace namespace;
    private final String apiHost;
    private final CliOutput cliOutput;
    private final CliContext cliContext;
    private final boolean debug;
    private StyxClient styxClient;

    private CliMain(StyxCliParser parser, Namespace namespace, String apiHost, CliOutput cliOutput, CliContext cliContext, boolean debug) {
        this.parser = Objects.requireNonNull(parser);
        this.namespace = Objects.requireNonNull(namespace);
        this.apiHost = Objects.requireNonNull(apiHost);
        this.cliOutput = Objects.requireNonNull(cliOutput);
        this.cliContext = Objects.requireNonNull(cliContext);
        this.debug = debug;
    }

    public static void main(String ... args) {
        try {
            CliMain.run(CliContext.DEFAULT, args);
        }
        catch (CliExitException e) {
            System.exit(e.status().code);
        }
    }

    static void run(CliContext cliContext, String ... args) {
        CliMain.run(cliContext, (Collection<String>)ImmutableList.copyOf((Object[])args));
    }

    private static void run(CliContext cliContext, Collection<String> args) {
        String apiHost;
        Namespace namespace;
        StyxCliParser parser = new StyxCliParser(cliContext);
        if (args.isEmpty()) {
            parser.parser.printHelp();
            throw CliExitException.of(CliExitException.ExitStatus.Success);
        }
        try {
            namespace = parser.parser.parseArgs(args.toArray(new String[0]));
            apiHost = namespace.getString(parser.globalOptions.host.getDest());
            if (apiHost == null) {
                throw new ArgumentParserException("Styx API host not set", parser.parser);
            }
        }
        catch (HelpScreenException e) {
            throw CliExitException.of(CliExitException.ExitStatus.Success);
        }
        catch (ArgumentParserException e) {
            parser.parser.handleError(e);
            throw CliExitException.of(CliExitException.ExitStatus.ArgumentError);
        }
        boolean plainOutput = Objects.equals(namespace.getBoolean(parser.globalOptions.plain.getDest()), true);
        boolean jsonOutput = Objects.equals(namespace.getBoolean(parser.globalOptions.json.getDest()), true);
        CliOutput cliOutput = jsonOutput ? cliContext.output(CliContext.Output.JSON) : (plainOutput ? cliContext.output(CliContext.Output.PLAIN) : cliContext.output(CliContext.Output.PRETTY));
        boolean debug = Objects.equals(namespace.getBoolean(parser.globalOptions.debug.getDest()), true);
        if (debug) {
            LoggingConfigurator.configureDefaults((String)"styx-cli", (LoggingConfigurator.Level)LoggingConfigurator.Level.DEBUG);
        } else {
            LoggingConfigurator.configureNoLogging();
        }
        new CliMain(parser, namespace, apiHost, cliOutput, cliContext, debug).run();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void run() {
        Command command = (Command)((Object)this.namespace.get(COMMAND_DEST));
        try {
            this.styxClient = this.cliContext.createClient(this.apiHost);
            switch (command) {
                case LIST: {
                    this.activeStates();
                    return;
                }
                case EVENTS: {
                    this.eventsForWorkflowInstance();
                    return;
                }
                case TRIGGER: {
                    this.triggerWorkflowInstance();
                    return;
                }
                case HALT: {
                    this.haltWorkflowInstance();
                    return;
                }
                case RETRY: {
                    this.retryWorkflowInstance();
                    return;
                }
                case BACKFILL: {
                    BackfillCommand backfillCommand = (BackfillCommand)((Object)this.namespace.get(SUBCOMMAND_DEST));
                    switch (backfillCommand) {
                        case CREATE: {
                            this.backfillCreate();
                            return;
                        }
                        case EDIT: {
                            this.backfillEdit();
                            return;
                        }
                        case HALT: {
                            this.backfillHalt();
                            return;
                        }
                        case SHOW: {
                            this.backfillShow();
                            return;
                        }
                        case LIST: {
                            this.backfillList();
                            return;
                        }
                    }
                    throw new ArgumentParserException(String.format("Unrecognized command: %s %s", new Object[]{command, backfillCommand}), this.parser.parser);
                }
                case RESOURCE: {
                    ResourceCommand resourceCommand = (ResourceCommand)((Object)this.namespace.get(SUBCOMMAND_DEST));
                    switch (resourceCommand) {
                        case CREATE: {
                            this.resourceCreate();
                            return;
                        }
                        case EDIT: {
                            this.resourceEdit();
                            return;
                        }
                        case SHOW: {
                            this.resourceShow();
                            return;
                        }
                        case LIST: {
                            this.resourceList();
                            return;
                        }
                    }
                    throw new ArgumentParserException(String.format("Unrecognized command: %s %s", new Object[]{command, resourceCommand}), this.parser.parser);
                }
                case WORKFLOW: {
                    WorkflowCommand workflowCommand = (WorkflowCommand)((Object)this.namespace.get(SUBCOMMAND_DEST));
                    switch (workflowCommand) {
                        case LIST: {
                            this.workflowList();
                            return;
                        }
                        case SHOW: {
                            this.workflowShow();
                            return;
                        }
                        case CREATE: {
                            this.workflowCreate();
                            return;
                        }
                        case DELETE: {
                            this.workflowDelete();
                            return;
                        }
                        case ENABLE: {
                            this.workflowEnable();
                            return;
                        }
                        case DISABLE: {
                            this.workflowDisable();
                            return;
                        }
                    }
                    throw new ArgumentParserException(String.format("Unrecognized command: %s %s", new Object[]{command, workflowCommand}), this.parser.parser);
                }
                case AUTH: {
                    AuthCommand authCommand = (AuthCommand)((Object)this.namespace.get(SUBCOMMAND_DEST));
                    switch (authCommand) {
                        case TEST: {
                            this.authTestServiceAccountUsage();
                            return;
                        }
                    }
                    throw new ArgumentParserException(String.format("Unrecognized command: %s %s", new Object[]{command, authCommand}), this.parser.parser);
                }
                default: {
                    throw new ArgumentParserException("Unrecognized command: " + command, this.parser.parser);
                }
            }
        }
        catch (InputErrorException e) {
            this.cliOutput.printError(e.getMessage());
            throw CliExitException.of(CliExitException.ExitStatus.InputError);
        }
        catch (ArgumentParserException e) {
            this.parser.parser.handleError(e);
            throw CliExitException.of(CliExitException.ExitStatus.ArgumentError);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (this.debug) {
                this.cliOutput.printError(Throwables.getStackTraceAsString((Throwable)cause));
            }
            if (cause instanceof ApiErrorException) {
                ApiErrorException apiError = (ApiErrorException)cause;
                if (apiError.getCode() == 401) {
                    if (!apiError.isAuthenticated()) {
                        this.cliOutput.printError("API error: Unauthorized: " + apiError.getMessage() + "\nPlease set up Application Default Credentials or set the GOOGLE_APPLICATION_CREDENTIALS env var to point to a file defining the credentials.\n\nHint: Try setting up credentials using gcloud: \n\n\t$ gcloud auth application-default login");
                        throw CliExitException.of(CliExitException.ExitStatus.AuthError);
                    } else {
                        this.cliOutput.printError("API error: Unauthorized: " + apiError.getMessage());
                    }
                    throw CliExitException.of(CliExitException.ExitStatus.AuthError);
                }
                this.cliOutput.printError("API error: " + apiError.getMessage());
                throw CliExitException.of(CliExitException.ExitStatus.ApiError);
            }
            if (cause instanceof ClientErrorException) {
                Throwable rootCause = Throwables.getRootCause((Throwable)cause);
                this.cliOutput.printError("Client error: " + cause.getMessage() + ": " + rootCause.getClass().getSimpleName() + ": " + rootCause.getMessage());
                throw CliExitException.of(CliExitException.ExitStatus.ClientError);
            }
            this.cliOutput.printError(Throwables.getStackTraceAsString((Throwable)cause));
            throw CliExitException.of(CliExitException.ExitStatus.ClientError);
        }
        catch (CliExitException e) {
            throw e;
        }
        catch (Exception e) {
            this.cliOutput.printError(Throwables.getStackTraceAsString((Throwable)e));
            throw CliExitException.of(CliExitException.ExitStatus.UnknownError);
        }
        finally {
            this.styxClient.close();
        }
    }

    private void workflowDelete() throws ExecutionException, InterruptedException {
        String reply;
        String component = this.namespace.getString(this.parser.workflowDeleteComponentId.getDest());
        List workflows = this.namespace.getList(this.parser.workflowDeleteWorkflowId.getDest());
        boolean force = this.namespace.getBoolean(this.parser.workflowDeleteForce.getDest());
        if (this.cliContext.hasConsole() && !force && !"y".equals(reply = this.cliContext.consoleReadLine("Sure you want to delete the workflow" + (workflows.size() > 1 ? "s" : "") + " " + String.join((CharSequence)", ", workflows) + " in component " + component + "? [y/N] ").trim())) {
            throw CliExitException.of(CliExitException.ExitStatus.UnknownError);
        }
        List futures = workflows.stream().map(workflow -> Tuple.of((Object)workflow, (Object)this.styxClient.deleteWorkflow(component, workflow))).collect(Collectors.toList());
        for (Tuple2 future : futures) {
            String workflow2 = (String)future._1;
            try {
                ((CompletionStage)future._2).toCompletableFuture().get();
                this.cliOutput.printMessage("Workflow " + workflow2 + " in component " + component + " deleted.");
            }
            catch (ExecutionException e) {
                this.handleWorkflowNotFound(component, workflow2, e);
            }
        }
    }

    private void workflowCreate() throws IOException, ExecutionException, InterruptedException {
        List configurations;
        String component = this.namespace.getString(this.parser.workflowCreateComponentId.getDest());
        File file = (File)this.namespace.get(this.parser.workflowCreateFile.getDest());
        ObjectReader workflowReader = Json.YAML_MAPPER.reader().forType(WorkflowConfiguration.class);
        MappingIterator iterator = file == null || file.getName().equals("-") ? workflowReader.readValues(System.in) : workflowReader.readValues(file);
        try {
            configurations = iterator.readAll();
        }
        catch (IOException e) {
            throw this.createInputErrorException(e);
        }
        boolean invalid = false;
        for (WorkflowConfiguration configuration2 : configurations) {
            Workflow workflow = Workflow.create((String)component, (WorkflowConfiguration)configuration2);
            List errors = this.cliContext.workflowValidator().validateWorkflow(workflow);
            if (errors.isEmpty()) continue;
            this.cliOutput.printError("Invalid workflow configuration: " + configuration2.id());
            errors.forEach(error -> this.cliOutput.printError("  error: " + error));
            invalid = true;
        }
        if (invalid) {
            throw CliExitException.of(CliExitException.ExitStatus.ArgumentError);
        }
        List futures = configurations.stream().map(configuration -> this.styxClient.createOrUpdateWorkflow(component, configuration)).collect(Collectors.toList());
        for (CompletionStage future : futures) {
            Workflow created = (Workflow)future.toCompletableFuture().get();
            this.cliOutput.printMessage("Workflow " + created.workflowId() + " in component " + created.componentId() + " created.");
        }
    }

    private InputErrorException createInputErrorException(IOException e) {
        String errorMessage = "Workflow configuration doesn't conform to the expected structure, ";
        String validExample = "\nMinimal valid example: \n========================\nid: bar\nschedule: DAYS\ndocker_image: busybox\ndocker_args: [echo, bar]\n========================\n";
        if (e.getMessage().contains("problem:")) {
            throw new InputErrorException(errorMessage + e.getMessage().substring(e.getMessage().indexOf("problem")) + validExample, (Throwable)e);
        }
        throw new InputErrorException(errorMessage + e.getMessage(), (Throwable)e);
    }

    private void workflowEnable() throws ExecutionException, InterruptedException {
        String component = this.namespace.getString(this.parser.workflowEnableComponentId.getDest());
        List workflows = this.namespace.getList(this.parser.workflowEnableWorkflowId.getDest());
        this.workflowStateUpdate(component, workflows, WorkflowState.patchEnabled((boolean)true)).forEach(t -> this.cliOutput.printMessage("Workflow " + (String)t._1 + " in component " + component + " enabled."));
    }

    private void workflowDisable() throws ExecutionException, InterruptedException {
        String component = this.namespace.getString(this.parser.workflowDisableComponentId.getDest());
        List workflows = this.namespace.getList(this.parser.workflowDisableWorkflowId.getDest());
        this.workflowStateUpdate(component, workflows, WorkflowState.patchEnabled((boolean)false)).forEach(t -> this.cliOutput.printMessage("Workflow " + (String)t._1 + " in component " + component + " disabled."));
    }

    private List<Tuple2<String, WorkflowState>> workflowStateUpdate(String component, List<String> workflows, WorkflowState workflowState) throws ExecutionException, InterruptedException {
        List futures = workflows.stream().map(workflow -> Tuple.of((Object)workflow, (Object)this.styxClient.updateWorkflowState(component, workflow, workflowState))).collect(Collectors.toList());
        ArrayList<Tuple2<String, WorkflowState>> updatedWorkflowStates = new ArrayList<Tuple2<String, WorkflowState>>(futures.size());
        for (Tuple2 future : futures) {
            String workflow2 = (String)future._1;
            try {
                updatedWorkflowStates.add((Tuple2<String, WorkflowState>)Tuple.of((Object)workflow2, (Object)((WorkflowState)((CompletionStage)future._2).toCompletableFuture().get())));
            }
            catch (ExecutionException e) {
                this.handleWorkflowNotFound(component, workflow2, e);
            }
        }
        return updatedWorkflowStates;
    }

    private void handleWorkflowNotFound(String component, String workflow, ExecutionException e) throws ExecutionException {
        Throwable cause = e.getCause();
        if (cause instanceof ApiErrorException) {
            ApiErrorException apiError = (ApiErrorException)cause;
            if (apiError.getCode() != 404) {
                throw e;
            }
        } else {
            throw e;
        }
        this.cliOutput.printMessage("Workflow " + workflow + " in component " + component + " not found.");
    }

    private void backfillCreate() throws ExecutionException, InterruptedException {
        String component = this.namespace.getString(this.parser.backfillCreateComponent.getDest());
        String workflow = this.namespace.getString(this.parser.backfillCreateWorkflow.getDest());
        String start = this.namespace.getString(this.parser.backfillCreateStart.getDest());
        String end = this.namespace.getString(this.parser.backfillCreateEnd.getDest());
        boolean reverse = this.namespace.getBoolean(this.parser.backfillCreateReverse.getDest());
        int concurrency = this.namespace.getInt(this.parser.backfillCreateConcurrency.getDest());
        String description = this.namespace.getString(this.parser.backfillCreateDescription.getDest());
        TriggerParameters triggerParameters = TriggerParameters.builder().env(this.parser.getEnvVars(this.namespace, this.parser.backfillCreateEnv)).build();
        BackfillInput configuration = BackfillInput.newBuilder().component(component).workflow(workflow).start(Instant.parse(start)).end(Instant.parse(end)).reverse(reverse).concurrency(concurrency).description(description).triggerParameters(triggerParameters).build();
        boolean allowFuture = this.namespace.getBoolean(this.parser.backfillCreateAllowFuture.getDest());
        Backfill backfill = (Backfill)this.styxClient.backfillCreate(configuration, allowFuture).toCompletableFuture().get();
        this.cliOutput.printBackfill(backfill, true);
    }

    private void backfillEdit() throws ExecutionException, InterruptedException {
        Integer concurrency = this.namespace.getInt(this.parser.backfillEditConcurrency.getDest());
        String id = this.namespace.getString(this.parser.backfillEditId.getDest());
        if (concurrency != null) {
            Backfill backfill = (Backfill)this.styxClient.backfillEditConcurrency(id, concurrency.intValue()).toCompletableFuture().get();
            this.cliOutput.printBackfill(backfill, true);
        }
    }

    private void backfillHalt() throws ExecutionException, InterruptedException {
        String id = this.namespace.getString(this.parser.backfillHaltId.getDest());
        Boolean graceful = this.namespace.getBoolean(this.parser.backfillHaltGraceful.getDest());
        this.styxClient.backfillHalt(id, graceful.booleanValue()).toCompletableFuture().get();
        this.cliOutput.printMessage("Backfill halted! Use `styx backfill show " + id + "` to check the backfill status.");
    }

    private void backfillShow() throws ExecutionException, InterruptedException {
        String id = this.namespace.getString(this.parser.backfillShowId.getDest());
        boolean noTruncate = this.namespace.getBoolean(this.parser.backfillShowNoTruncate.getDest());
        BackfillPayload backfillPayload = (BackfillPayload)this.styxClient.backfill(id, true).toCompletableFuture().get();
        this.cliOutput.printBackfillPayload(backfillPayload, noTruncate);
    }

    private void backfillList() throws ExecutionException, InterruptedException {
        Optional<String> component = Optional.ofNullable(this.namespace.getString(this.parser.backfillListComponent.getDest()));
        Optional<String> workflow = Optional.ofNullable(this.namespace.getString(this.parser.backfillListWorkflow.getDest()));
        boolean showAll = this.namespace.getBoolean(this.parser.backfillListShowAll.getDest());
        boolean noTruncate = this.namespace.getBoolean(this.parser.backfillListNoTruncate.getDest());
        BackfillsPayload backfillsPayload = (BackfillsPayload)this.styxClient.backfillList(component, workflow, showAll, false).toCompletableFuture().get();
        this.cliOutput.printBackfills(backfillsPayload.backfills(), noTruncate);
    }

    private void resourceCreate() throws ExecutionException, InterruptedException {
        String id = this.namespace.getString(this.parser.resourceCreateId.getDest());
        int concurrency = this.namespace.getInt(this.parser.resourceCreateConcurrency.getDest());
        Resource resource = (Resource)this.styxClient.resourceCreate(id, concurrency).toCompletableFuture().get();
        this.cliOutput.printResources(Collections.singletonList(resource));
    }

    private void resourceEdit() throws ExecutionException, InterruptedException {
        String id = this.namespace.getString(this.parser.resourceEditId.getDest());
        Integer concurrency = this.namespace.getInt(this.parser.resourceEditConcurrency.getDest());
        if (concurrency != null) {
            Resource resource = (Resource)this.styxClient.resourceEdit(id, concurrency.intValue()).toCompletableFuture().get();
            this.cliOutput.printResources(Collections.singletonList(resource));
        }
    }

    private void resourceShow() throws ExecutionException, InterruptedException {
        String id = this.namespace.getString(this.parser.resourceShowId.getDest());
        Resource resource = (Resource)this.styxClient.resource(id).toCompletableFuture().get();
        this.cliOutput.printResources(Collections.singletonList(resource));
    }

    private void resourceList() throws ExecutionException, InterruptedException {
        ResourcesPayload resourcesPayload = (ResourcesPayload)this.styxClient.resourceList().toCompletableFuture().get();
        this.cliOutput.printResources(resourcesPayload.resources());
    }

    private void workflowShow() throws ExecutionException, InterruptedException {
        String component = this.namespace.getString(this.parser.workflowShowComponentId.getDest());
        String workflow = this.namespace.getString(this.parser.workflowShowWorkflowId.getDest());
        WorkflowWithState workflowWithStateFuture = (WorkflowWithState)this.styxClient.workflowWithState(component, workflow).toCompletableFuture().get();
        this.cliOutput.printWorkflow(workflowWithStateFuture.workflow(), workflowWithStateFuture.state());
    }

    private void workflowList() throws ExecutionException, InterruptedException {
        this.cliOutput.printWorkflows((List)this.styxClient.workflows().toCompletableFuture().get());
    }

    private void activeStates() throws ExecutionException, InterruptedException {
        Optional<String> component = Optional.ofNullable(this.namespace.getString(this.parser.listComponent.getDest()));
        RunStateDataPayload runStateDataPayload = (RunStateDataPayload)this.styxClient.activeStates(component).toCompletableFuture().get();
        this.cliOutput.printStates(runStateDataPayload);
    }

    private void eventsForWorkflowInstance() throws ExecutionException, InterruptedException {
        String component = this.namespace.getString(COMPONENT_DEST);
        String workflow = this.namespace.getString(WORKFLOW_DEST);
        String parameter = this.namespace.getString(PARAMETER_DEST);
        List eventInfos = (List)this.styxClient.eventsForWorkflowInstance(component, workflow, parameter).toCompletableFuture().get();
        this.cliOutput.printEvents(eventInfos);
    }

    private void triggerWorkflowInstance() throws ExecutionException, InterruptedException {
        String component = this.namespace.getString(COMPONENT_DEST);
        String workflow = this.namespace.getString(WORKFLOW_DEST);
        String parameter = this.namespace.getString(PARAMETER_DEST);
        TriggerParameters parameters = TriggerParameters.builder().env(this.parser.getEnvVars(this.namespace, this.parser.triggerEnv)).build();
        boolean allowFuture = this.namespace.getBoolean(this.parser.triggerAllowFuture.getDest());
        this.styxClient.triggerWorkflowInstance(component, workflow, parameter, parameters, allowFuture).toCompletableFuture().get();
        this.cliOutput.printMessage("Triggered! Use `styx ls -c " + component + "` to check active workflow instances.");
    }

    private void haltWorkflowInstance() throws ExecutionException, InterruptedException {
        String component = this.namespace.getString(COMPONENT_DEST);
        String workflow = this.namespace.getString(WORKFLOW_DEST);
        String parameter = this.namespace.getString(PARAMETER_DEST);
        this.styxClient.haltWorkflowInstance(component, workflow, parameter).toCompletableFuture().get();
        this.cliOutput.printMessage("Halted! Use `styx events " + component + " " + workflow + " " + parameter + "` to verify.");
    }

    private void retryWorkflowInstance() throws ExecutionException, InterruptedException {
        String component = this.namespace.getString(COMPONENT_DEST);
        String workflow = this.namespace.getString(WORKFLOW_DEST);
        String parameter = this.namespace.getString(PARAMETER_DEST);
        this.styxClient.retryWorkflowInstance(component, workflow, parameter).toCompletableFuture().get();
        this.cliOutput.printMessage("Retrying! Use `styx ls -c " + component + "` to check active workflow instances.");
    }

    private void authTestServiceAccountUsage() throws ExecutionException, InterruptedException {
        String principal;
        String serviceAccount = this.namespace.getString(this.parser.authServiceAccount.getDest());
        TestServiceAccountUsageAuthorizationResponse response = (TestServiceAccountUsageAuthorizationResponse)this.styxClient.testServiceAccountUsageAuthorization(serviceAccount, principal = this.namespace.getString(this.parser.authPrincipal.getDest())).toCompletableFuture().get();
        if (!response.authorized()) {
            this.cliOutput.printMessage("The principal " + principal + " is not authorized to use the service account " + serviceAccount + ". " + response.message().orElse(""));
            throw CliExitException.of(CliExitException.ExitStatus.UnknownError);
        }
        this.cliOutput.printMessage("The principal " + principal + " is authorized to use the service account " + serviceAccount + ". " + response.message().orElse(""));
    }

    private static Subparser addSubparser(Subparsers subCommands, String name, CliContext cliContext) {
        Subparser parser = subCommands.addParser(name);
        GlobalOptions.add((ArgumentParser)parser, cliContext, true);
        return parser;
    }

    static interface CliContext {
        public static final CliContext DEFAULT = new CliContext(){

            @Override
            public StyxClient createClient(String host) {
                return StyxClientFactory.create((String)host);
            }

            @Override
            public CliOutput output(Output output) {
                switch (output) {
                    case JSON: {
                        return new JsonCliOutput();
                    }
                    case PLAIN: {
                        return new PlainCliOutput();
                    }
                    case PRETTY: {
                        return new PrettyCliOutput();
                    }
                }
                throw new AssertionError();
            }

            @Override
            public Map<String, String> env() {
                return System.getenv();
            }

            @Override
            public boolean hasConsole() {
                return System.console() != null;
            }

            @Override
            public String consoleReadLine(String prompt) {
                if (!this.hasConsole()) {
                    throw new IllegalStateException();
                }
                return System.console().readLine(prompt, new Object[0]);
            }

            @Override
            public WorkflowValidator workflowValidator() {
                return new BasicWorkflowValidator(new DockerImageValidator());
            }
        };

        public CliOutput output(Output var1);

        public Map<String, String> env();

        public StyxClient createClient(String var1);

        public boolean hasConsole();

        public String consoleReadLine(String var1);

        public WorkflowValidator workflowValidator();

        public static enum Output {
            JSON,
            PLAIN,
            PRETTY;

        }
    }

    private static class PartitionAction
    implements ArgumentAction {
        private PartitionAction() {
        }

        public void run(ArgumentParser parser, Argument arg, Map<String, Object> attrs, String flag, Object value) throws ArgumentParserException {
            try {
                attrs.put(arg.getDest(), ParameterUtil.parseDateHour((String)value.toString()));
            }
            catch (DateTimeParseException dateHourException) {
                try {
                    attrs.put(arg.getDest(), ParameterUtil.parseDate((String)value.toString()));
                }
                catch (Exception dateException) {
                    throw new ArgumentParserException(String.format("could not parse date/datehour for parameter '%s'; if datehour: [%s], if date: [%s]", arg.textualName(), dateHourException.getMessage(), dateException.getMessage()), parser);
                }
            }
        }

        public void onAttach(Argument arg) {
        }

        public boolean consumeArgument() {
            return true;
        }
    }

    private static enum AuthCommand {
        TEST("", "Test authorization");

        private final String alias;
        private final String description;

        private AuthCommand(String alias, String description) {
            this.alias = alias;
            this.description = description;
        }

        public Subparser parser(Subparsers subCommands, CliContext cliContext) {
            Subparser subparser = CliMain.addSubparser(subCommands, this.name().toLowerCase(), cliContext).setDefault(CliMain.SUBCOMMAND_DEST, (Object)this).description(this.description).help(this.description);
            if (this.alias != null && !this.alias.isEmpty()) {
                subparser.aliases(new String[]{this.alias});
            }
            return subparser;
        }
    }

    private static enum WorkflowCommand {
        LIST("ls", "List all workflows"),
        SHOW("get", "Show info about a specific workflow"),
        CREATE("", "Create or update workflow(s)"),
        DELETE("", "Delete workflow(s)"),
        ENABLE("", "Enable workflow(s)"),
        DISABLE("", "Disable workflow(s)");

        private final String alias;
        private final String description;

        private WorkflowCommand(String alias, String description) {
            this.alias = alias;
            this.description = description;
        }

        public Subparser parser(Subparsers subCommands, CliContext cliContext) {
            Subparser subparser = CliMain.addSubparser(subCommands, this.name().toLowerCase(), cliContext).setDefault(CliMain.SUBCOMMAND_DEST, (Object)this).description(this.description).help(this.description);
            if (this.alias != null && !this.alias.isEmpty()) {
                subparser.aliases(new String[]{this.alias});
            }
            return subparser;
        }
    }

    private static enum ResourceCommand {
        LIST("ls", "List resources"),
        CREATE("", "Create a resource"),
        EDIT("e", "Edit a resource"),
        SHOW("get", "Show info about a specific resource");

        private final String alias;
        private final String description;

        private ResourceCommand(String alias, String description) {
            this.alias = alias;
            this.description = description;
        }

        public Subparser parser(Subparsers subCommands, CliContext cliContext) {
            Subparser subparser = CliMain.addSubparser(subCommands, this.name().toLowerCase(), cliContext).setDefault(CliMain.SUBCOMMAND_DEST, (Object)this).description(this.description).help(this.description);
            if (this.alias != null && !this.alias.isEmpty()) {
                subparser.aliases(new String[]{this.alias});
            }
            return subparser;
        }
    }

    private static enum BackfillCommand {
        LIST("ls", "List active backfills. Use option -a (--show-all) to show all"),
        CREATE("", "Create a backfill"),
        EDIT("e", "Edit a backfill"),
        HALT("h", "Halt a backfill"),
        SHOW("get", "Show info about a specific backfill");

        private final String alias;
        private final String description;

        private BackfillCommand(String alias, String description) {
            this.alias = alias;
            this.description = description;
        }

        public Subparser parser(Subparsers subCommands, CliContext cliContext) {
            Subparser subparser = CliMain.addSubparser(subCommands, this.name().toLowerCase(), cliContext).setDefault(CliMain.SUBCOMMAND_DEST, (Object)this).description(this.description).help(this.description);
            if (this.alias != null && !this.alias.isEmpty()) {
                subparser.aliases(new String[]{this.alias});
            }
            return subparser;
        }
    }

    private static class GlobalOptions {
        final Argument host;
        final Argument json;
        final Argument plain;
        final Argument debug;
        final ArgumentGroup options;

        private GlobalOptions(ArgumentParser parser, CliContext cliContext, boolean subCommand) {
            this.options = parser.addArgumentGroup("global options");
            this.host = this.options.addArgument(new String[]{"-H", "--host"}).help("Styx API host (can also be set with environment variable STYX_CLI_HOST)").setDefault((FeatureControl)(subCommand ? FeatureControl.SUPPRESS : null)).setDefault((Object)cliContext.env().get("STYX_CLI_HOST")).action((ArgumentAction)Arguments.store());
            this.json = this.options.addArgument(new String[]{"--json"}).help("json output").setDefault((FeatureControl)(subCommand ? FeatureControl.SUPPRESS : null)).action((ArgumentAction)Arguments.storeTrue());
            this.plain = this.options.addArgument(new String[]{"-p", "--plain"}).help("plain output").setDefault((FeatureControl)(subCommand ? FeatureControl.SUPPRESS : null)).action((ArgumentAction)Arguments.storeTrue());
            this.debug = this.options.addArgument(new String[]{"--debug"}).help("debug output").setDefault((FeatureControl)(subCommand ? FeatureControl.SUPPRESS : null)).action((ArgumentAction)Arguments.storeTrue());
        }

        static GlobalOptions add(ArgumentParser parser, CliContext cliContext, boolean subCommand) {
            return new GlobalOptions(parser, cliContext, subCommand);
        }
    }

    private static enum Command {
        LIST("ls", "List active workflow instances"),
        EVENTS("e", "List events for a workflow instance"),
        HALT("h", "Halt a workflow instance"),
        TRIGGER("t", "Trigger a workflow instance, fail if the instance is already active"),
        RETRY("r", "Retry a workflow instance that is in a waiting state"),
        RESOURCE(null, "Commands related to resources"),
        BACKFILL(null, "Commands related to backfills"),
        WORKFLOW(null, "Commands related to workflows"),
        AUTH(null, "Commands related to authentication and authorization");

        private final String alias;
        private final String description;

        private Command(String alias, String description) {
            this.alias = alias;
            this.description = description;
        }

        public Subparser parser(Subparsers subCommands, CliContext cliContext) {
            Subparser subparser = CliMain.addSubparser(subCommands, this.name().toLowerCase(), cliContext).setDefault(CliMain.COMMAND_DEST, (Object)this).description(this.description).help(this.description);
            if (this.alias != null && !this.alias.isEmpty()) {
                subparser.aliases(new String[]{this.alias});
            }
            return subparser;
        }
    }

    private static class StyxCliParser
    extends ParserBase {
        final ArgumentParser parser = ArgumentParsers.newArgumentParser((String)"styx").description("Styx CLI").version(STYX_CLI_VERSION);
        final PartitionAction partitionAction = new PartitionAction();
        final Subparsers subCommands = this.parser.addSubparsers().title("commands").metavar(" ");
        final Subparsers backfillParser = Command.BACKFILL.parser(this.subCommands, this.cliContext).addSubparsers().title("commands").metavar(" ");
        final Subparser backfillShow = BackfillCommand.SHOW.parser(this.backfillParser, this.cliContext);
        final Argument backfillShowId = this.backfillShow.addArgument(new String[]{"backfill"}).help("Backfill ID");
        final Argument backfillShowNoTruncate = this.backfillShow.addArgument(new String[]{"--no-trunc"}).setDefault((Object)false).action((ArgumentAction)Arguments.storeTrue()).help("don't truncate output (only for pretty printing)");
        final Subparser backfillEdit = BackfillCommand.EDIT.parser(this.backfillParser, this.cliContext);
        final Argument backfillEditId = this.backfillEdit.addArgument(new String[]{"backfill"}).help("Backfill ID");
        final Argument backfillEditConcurrency = this.backfillEdit.addArgument(new String[]{"--concurrency"}).help("set the concurrency value for the backfill").type(Integer.class);
        final Subparser backfillHalt = BackfillCommand.HALT.parser(this.backfillParser, this.cliContext);
        final Argument backfillHaltId = this.backfillHalt.addArgument(new String[]{"backfill"}).help("Backfill ID");
        final Argument backfillHaltGraceful = this.backfillHalt.addArgument(new String[]{"--graceful"}).setDefault((Object)false).action((ArgumentAction)Arguments.storeTrue()).help("halt the backfill while leaving already triggered instances untouched");
        final Subparser backfillList = BackfillCommand.LIST.parser(this.backfillParser, this.cliContext);
        final Argument backfillListWorkflow = this.backfillList.addArgument(new String[]{"-w", "--workflow"}).help("only show backfills for WORKFLOW");
        final Argument backfillListComponent = this.backfillList.addArgument(new String[]{"-c", "--component"}).help("only show backfills for COMPONENT");
        final Argument backfillListShowAll = this.backfillList.addArgument(new String[]{"-a", "--show-all"}).setDefault((Object)false).action((ArgumentAction)Arguments.storeTrue()).help("show all backfills, even halted and all-triggered ones");
        final Argument backfillListNoTruncate = this.backfillList.addArgument(new String[]{"--no-trunc"}).setDefault((Object)false).action((ArgumentAction)Arguments.storeTrue()).help("don't truncate output (only for pretty printing)");
        final Subparser backfillCreate = BackfillCommand.CREATE.parser(this.backfillParser, this.cliContext);
        final Argument backfillCreateComponent = this.backfillCreate.addArgument(new String[]{"component"}).help("Component ID");
        final Argument backfillCreateWorkflow = this.backfillCreate.addArgument(new String[]{"workflow"}).help("Workflow ID");
        final Argument backfillCreateStart = this.backfillCreate.addArgument(new String[]{"start"}).help("Start date/datehour (inclusive)").action((ArgumentAction)this.partitionAction);
        final Argument backfillCreateEnd = this.backfillCreate.addArgument(new String[]{"end"}).help("End date/datehour (exclusive)").action((ArgumentAction)this.partitionAction);
        final Argument backfillCreateReverse = this.backfillCreate.addArgument(new String[]{"--reverse"}).setDefault((Object)false).help("Run backfill in reverse, from end (exclusive) to beginning (inclusive)").action((ArgumentAction)Arguments.storeTrue());
        final Argument backfillCreateConcurrency = this.backfillCreate.addArgument(new String[]{"concurrency"}).help("The number of jobs to run in parallel").type(Integer.class);
        final Argument backfillCreateDescription = this.backfillCreate.addArgument(new String[]{"-d", "--description"}).help("a description of the backfill");
        final Argument backfillCreateEnv = this.addEnvVarArgument((ArgumentParser)this.backfillCreate, "-e", "--env");
        final Argument backfillCreateAllowFuture = this.addEnvVarArgument((ArgumentParser)this.backfillCreate, "--allow-future").help("Allow backfilling future partitions").setDefault((Object)false).action((ArgumentAction)Arguments.storeTrue());
        final Subparsers resourceParser = Command.RESOURCE.parser(this.subCommands, this.cliContext).addSubparsers().title("commands").metavar(" ");
        final Subparser resourceShow = ResourceCommand.SHOW.parser(this.resourceParser, this.cliContext);
        final Argument resourceShowId = this.resourceShow.addArgument(new String[]{"id"}).help("Resource ID");
        final Subparser resourceEdit = ResourceCommand.EDIT.parser(this.resourceParser, this.cliContext);
        final Argument resourceEditId = this.resourceEdit.addArgument(new String[]{"id"}).help("Resource ID");
        final Argument resourceEditConcurrency = this.resourceEdit.addArgument(new String[]{"--concurrency"}).help("set the concurrency value for the resource").type(Integer.class);
        final Subparser resourceList = ResourceCommand.LIST.parser(this.resourceParser, this.cliContext);
        final Subparser resourceCreate = ResourceCommand.CREATE.parser(this.resourceParser, this.cliContext);
        final Argument resourceCreateId = this.resourceCreate.addArgument(new String[]{"id"}).help("Resource ID");
        final Argument resourceCreateConcurrency = this.resourceCreate.addArgument(new String[]{"concurrency"}).help("The concurrency of this resource").type(Integer.class);
        final Subparsers workflowParser = Command.WORKFLOW.parser(this.subCommands, this.cliContext).addSubparsers().title("commands").metavar(" ");
        final Subparser workflowList = WorkflowCommand.LIST.parser(this.workflowParser, this.cliContext);
        final Subparser workflowShow = WorkflowCommand.SHOW.parser(this.workflowParser, this.cliContext);
        final Argument workflowShowComponentId = this.workflowShow.addArgument(new String[]{"component"}).help("Component ID");
        final Argument workflowShowWorkflowId = this.workflowShow.addArgument(new String[]{"workflow"}).help("Workflow ID");
        final Subparser workflowCreate = WorkflowCommand.CREATE.parser(this.workflowParser, this.cliContext);
        final Argument workflowCreateComponentId = this.workflowCreate.addArgument(new String[]{"component"}).help("Component ID");
        final Argument workflowCreateFile = this.workflowCreate.addArgument(new String[]{"-f", "--file"}).type((ArgumentType)Arguments.fileType().acceptSystemIn().verifyCanRead()).help("Workflow configuration file");
        final Subparser workflowDelete = WorkflowCommand.DELETE.parser(this.workflowParser, this.cliContext);
        final Argument workflowDeleteComponentId = this.workflowDelete.addArgument(new String[]{"component"}).help("Component ID");
        final Argument workflowDeleteWorkflowId = this.workflowDelete.addArgument(new String[]{"workflow"}).nargs("+").help("Workflow IDs");
        final Argument workflowDeleteForce = this.workflowDelete.addArgument(new String[]{"--force"}).help("Do not ask for confirmation").setDefault((Object)false).action((ArgumentAction)Arguments.storeTrue());
        final Subparser workflowEnable = WorkflowCommand.ENABLE.parser(this.workflowParser, this.cliContext);
        final Argument workflowEnableComponentId = this.workflowEnable.addArgument(new String[]{"component"}).help("Component ID");
        final Argument workflowEnableWorkflowId = this.workflowEnable.addArgument(new String[]{"workflow"}).nargs("+").help("Workflow IDs");
        final Subparser workflowDisable = WorkflowCommand.DISABLE.parser(this.workflowParser, this.cliContext);
        final Argument workflowDisableComponentId = this.workflowDisable.addArgument(new String[]{"component"}).help("Component ID");
        final Argument workflowDisableWorkflowId = this.workflowDisable.addArgument(new String[]{"workflow"}).nargs("+").help("Workflow IDs");
        final Subparser list = Command.LIST.parser(this.subCommands, this.cliContext);
        final Argument listComponent = this.list.addArgument(new String[]{"-c", "--component"}).help("only show instances for COMPONENT");
        final Subparser events = StyxCliParser.addWorkflowInstanceArguments(Command.EVENTS.parser(this.subCommands, this.cliContext));
        final Subparser trigger = StyxCliParser.addWorkflowInstanceArguments(Command.TRIGGER.parser(this.subCommands, this.cliContext));
        final Argument triggerEnv = this.addEnvVarArgument((ArgumentParser)this.trigger, "-e", "--env");
        final Argument triggerAllowFuture = this.addEnvVarArgument((ArgumentParser)this.trigger, "--allow-future").help("Allow triggering future partition").setDefault((Object)false).action((ArgumentAction)Arguments.storeTrue());
        final Subparser halt = StyxCliParser.addWorkflowInstanceArguments(Command.HALT.parser(this.subCommands, this.cliContext));
        final Subparser retry = StyxCliParser.addWorkflowInstanceArguments(Command.RETRY.parser(this.subCommands, this.cliContext));
        final Subparsers authParser = Command.AUTH.parser(this.subCommands, this.cliContext).addSubparsers().title("commands").metavar(" ");
        final Subparser testServiceAccountUsage = AuthCommand.TEST.parser(this.authParser, this.cliContext);
        final Argument authServiceAccount = this.testServiceAccountUsage.addArgument(new String[]{"-a", "--service-account"}).required(true).help("The service account to test usage authorization against");
        final Argument authPrincipal = this.testServiceAccountUsage.addArgument(new String[]{"-u", "--principal"}).required(true).help("The principal (user) to test for service account usage authorization");
        final GlobalOptions globalOptions = GlobalOptions.add(this.parser, this.cliContext, false);
        final Argument version = this.parser.addArgument(new String[]{"--version"}).action((ArgumentAction)Arguments.version());

        private StyxCliParser(CliContext cliContext) {
            super(cliContext);
        }

        private static Subparser addWorkflowInstanceArguments(Subparser subparser) {
            subparser.addArgument(new String[]{CliMain.COMPONENT_DEST}).help("Component id");
            subparser.addArgument(new String[]{CliMain.WORKFLOW_DEST}).help("Workflow id");
            subparser.addArgument(new String[]{CliMain.PARAMETER_DEST}).help("Parameter identifying the workflow instance, e.g. '2016-09-14' or '2016-09-14T17'");
            return subparser;
        }

        private Argument addEnvVarArgument(ArgumentParser parser, String ... flags) {
            return parser.addArgument(flags).type(String.class).action((ArgumentAction)Arguments.append()).help("Environment variables");
        }

        private Map<String, String> getEnvVars(Namespace namespace, Argument argument) {
            List args = namespace.getList(argument.getDest());
            return args == null ? Collections.emptyMap() : args.stream().map(s -> Splitter.on((char)'=').splitToList((CharSequence)s)).peek(kv -> Preconditions.checkArgument((kv.size() == 2 ? 1 : 0) != 0)).collect(Collectors.toMap(kv -> (String)kv.get(0), kv -> (String)kv.get(1)));
        }
    }

    private static class ParserBase {
        final CliContext cliContext;

        ParserBase(CliContext cliContext) {
            this.cliContext = cliContext;
        }
    }
}

