/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.styx.cli;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.spotify.styx.api.RunStateDataPayload;
import com.spotify.styx.model.WorkflowId;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.fusesource.jansi.Ansi;

class CliUtil {
    private CliUtil() {
    }

    static Ansi colored(Ansi.Color color, Object obj) {
        return Ansi.ansi().fg(color).a(obj).reset();
    }

    static Ansi coloredBright(Ansi.Color color, Object obj) {
        return Ansi.ansi().fgBright(color).a(obj).reset();
    }

    static SortedMap<WorkflowId, SortedSet<RunStateDataPayload.RunStateData>> groupStates(List<RunStateDataPayload.RunStateData> runStateDataList) {
        return runStateDataList.stream().collect(Collectors.groupingBy(state -> state.workflowInstance().workflowId(), CliUtil::newSortedWorkflowIdSet, Collectors.toCollection(CliUtil::newSortedStateSet)));
    }

    private static TreeSet<RunStateDataPayload.RunStateData> newSortedStateSet() {
        return Sets.newTreeSet((Comparator)RunStateDataPayload.RunStateData.PARAMETER_COMPARATOR);
    }

    private static TreeMap<WorkflowId, SortedSet<RunStateDataPayload.RunStateData>> newSortedWorkflowIdSet() {
        return Maps.newTreeMap((Comparator)WorkflowId.KEY_COMPARATOR);
    }

    static String formatTimestamp(long timestamp) {
        return Instant.ofEpochMilli(timestamp).atZone(ZoneId.of("UTC")).toLocalDateTime().format(DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss"));
    }

    static String formatMap(Map<String, String> map) {
        return Joiner.on((String)" ").withKeyValueSeparator("=").join((Map)ImmutableSortedMap.copyOf(map));
    }
}

