/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.styx.cli;

import com.google.common.base.Joiner;
import com.spotify.styx.api.BackfillPayload;
import com.spotify.styx.api.RunStateDataPayload;
import com.spotify.styx.cli.CliOutput;
import com.spotify.styx.cli.CliUtil;
import com.spotify.styx.model.Backfill;
import com.spotify.styx.model.Resource;
import com.spotify.styx.model.Schedule;
import com.spotify.styx.model.Workflow;
import com.spotify.styx.model.WorkflowId;
import com.spotify.styx.model.WorkflowState;
import com.spotify.styx.model.data.EventInfo;
import com.spotify.styx.state.Message;
import com.spotify.styx.state.StateData;
import com.spotify.styx.util.ParameterUtil;
import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import org.fusesource.jansi.Ansi;

class PrettyCliOutput
implements CliOutput {
    private static final String BACKFILL_FORMAT = "%28s  %6s  %13s %12s  %-20s  %-20s  %-7s  %-20s  %-<cid-length>s  %-<wid-length>s %-20s %-20s %-<description-length>s %s";
    private static final String WORKFLOW_FORMAT = "%-<cid-length>s  %-<wid-length>s";
    private static final String NA_VALUE = "N/A";
    private static final int TRUNCATED_LENGTH = 20;
    private static final String ELLIPSIS = "...";
    private static final String COMPONENT_HEADER = "COMPONENT";
    private static final String WORKFLOW_HEADER = "WORKFLOW";
    private static final String DESCRIPTION_HEADER = "DESCRIPTION";

    PrettyCliOutput() {
    }

    @Override
    public void printStates(RunStateDataPayload runStateDataPayload) {
        System.out.println(String.format("  %-20s %-12s %-47s %-7s %s", "WORKFLOW INSTANCE", "STATE", "EXECUTION ID", "TRIES", "PREVIOUS EXECUTION MESSAGE"));
        CliUtil.groupStates(runStateDataPayload.activeStates()).forEach((key, value) -> {
            System.out.println();
            System.out.println(String.format("%s %s", CliUtil.colored(Ansi.Color.CYAN, key.componentId()), CliUtil.colored(Ansi.Color.BLUE, key.id())));
            value.forEach(runStateData -> {
                StateData stateData = runStateData.stateData();
                Ansi ansiState = this.getAnsiForState((RunStateDataPayload.RunStateData)runStateData);
                Message lastMessage = stateData.message().orElse(Message.create((Message.MessageLevel)Message.MessageLevel.UNKNOWN, (String)"No info"));
                Ansi ansiMessage = CliUtil.colored(this.messageColor(lastMessage.level()), lastMessage.line());
                System.out.println(String.format("  %-20s %-20s %-47s %-7d %s", runStateData.workflowInstance().parameter(), ansiState, stateData.executionId().orElse("<no-execution-id>"), stateData.tries(), ansiMessage));
            });
        });
    }

    @Override
    public void printEvents(List<EventInfo> eventInfos) {
        String formatString = "%-25s %-25s %s";
        System.out.println(String.format("%-25s %-25s %s", "TIME", "EVENT", "DATA"));
        eventInfos.forEach(eventInfo -> System.out.println(String.format("%-25s %-25s %s", CliUtil.formatTimestamp(eventInfo.timestamp()), eventInfo.name(), eventInfo.info())));
    }

    @Override
    public void printBackfill(Backfill backfill, boolean noTruncate) {
        this.printBackfill(backfill, this.effectiveLongFieldLength(Optional.ofNullable(backfill.workflowId().componentId()), COMPONENT_HEADER, true), this.effectiveLongFieldLength(Optional.ofNullable(backfill.workflowId().id()), WORKFLOW_HEADER, true), this.effectiveLongFieldLength(backfill.description(), DESCRIPTION_HEADER, noTruncate), noTruncate);
    }

    private void printBackfill(Backfill backfill, int cidLength, int widLength, int descriptionLength, boolean noTruncate) {
        Schedule schedule = backfill.schedule();
        WorkflowId workflowId = backfill.workflowId();
        String format = BACKFILL_FORMAT.replaceAll("<cid-length>", String.valueOf(cidLength)).replaceAll("<wid-length>", String.valueOf(widLength)).replaceAll("<description-length>", String.valueOf(descriptionLength));
        System.out.println(String.format(format, backfill.id(), backfill.halted(), backfill.allTriggered(), backfill.concurrency(), ParameterUtil.toParameter((Schedule)schedule, (Instant)backfill.start()), ParameterUtil.toParameter((Schedule)schedule, (Instant)backfill.end()), backfill.reverse(), ParameterUtil.toParameter((Schedule)schedule, (Instant)backfill.nextTrigger()), workflowId.componentId(), workflowId.id(), backfill.created().map(Instant::toString).orElse(""), backfill.lastModified().map(lastModified -> lastModified.toString()).orElse(""), this.formatLongField(backfill.description(), noTruncate), this.formatLongField(backfill.triggerParameters().map(triggerParameters -> CliUtil.formatMap(triggerParameters.env())), noTruncate)));
    }

    private void printBackfillHeader(int cidLength, int widLength, int descriptionLength) {
        String format = BACKFILL_FORMAT.replaceAll("<cid-length>", String.valueOf(cidLength)).replaceAll("<wid-length>", String.valueOf(widLength)).replaceAll("<description-length>", String.valueOf(descriptionLength));
        System.out.println(String.format(format, "BACKFILL ID", "HALTED", "ALL TRIGGERED", "CONCURRENCY", "START (INCL)", "END (EXCL)", "REVERSE", "NEXT TRIGGER", COMPONENT_HEADER, WORKFLOW_HEADER, "CREATED", "LAST MODIFIED", DESCRIPTION_HEADER, "TRIGGER ENV"));
    }

    private void printWorkflowHeader(int cidLength, int widLength) {
        String format = WORKFLOW_FORMAT.replaceAll("<cid-length>", String.valueOf(cidLength)).replaceAll("<wid-length>", String.valueOf(widLength));
        System.out.println(String.format(format, COMPONENT_HEADER, WORKFLOW_HEADER));
    }

    @Override
    public void printBackfillPayload(BackfillPayload backfillPayload, boolean noTruncate) {
        this.printBackfillHeader(this.effectiveLongFieldLength(Optional.ofNullable(backfillPayload.backfill().workflowId().componentId()), COMPONENT_HEADER, true), this.effectiveLongFieldLength(Optional.ofNullable(backfillPayload.backfill().workflowId().id()), WORKFLOW_HEADER, true), this.effectiveLongFieldLength(backfillPayload.backfill().description(), DESCRIPTION_HEADER, noTruncate));
        this.printBackfill(backfillPayload.backfill(), noTruncate);
        if (backfillPayload.statuses().isPresent()) {
            System.out.println();
            System.out.println();
            this.printStates((RunStateDataPayload)backfillPayload.statuses().get());
        }
    }

    @Override
    public void printBackfills(List<BackfillPayload> backfills, boolean noTruncate) {
        int cidLength = backfills.stream().map(x -> this.effectiveLongFieldLength(Optional.of(x.backfill().workflowId().componentId()), COMPONENT_HEADER, true)).max(Comparator.naturalOrder()).orElse(1);
        int widLength = backfills.stream().map(x -> this.effectiveLongFieldLength(Optional.of(x.backfill().workflowId().id()), WORKFLOW_HEADER, true)).max(Comparator.naturalOrder()).orElse(1);
        int descriptionLength = backfills.stream().map(x -> this.effectiveLongFieldLength(x.backfill().description(), DESCRIPTION_HEADER, noTruncate)).max(Comparator.naturalOrder()).orElse(1);
        this.printBackfillHeader(cidLength, widLength, descriptionLength);
        for (BackfillPayload backfillPayload : backfills) {
            this.printBackfill(backfillPayload.backfill(), cidLength, widLength, descriptionLength, noTruncate);
            if (!backfillPayload.statuses().isPresent()) continue;
            System.out.println();
            System.out.println();
            this.printStates((RunStateDataPayload)backfillPayload.statuses().get());
        }
    }

    @Override
    public void printResources(List<Resource> resources) {
        String format = "%50s %12s";
        System.out.println(String.format("%50s %12s", "RESOURCE", "CONCURRENCY"));
        resources.forEach(resource -> System.out.println(String.format("%50s %12s", resource.id(), resource.concurrency())));
    }

    @Override
    public void printMessage(String message) {
        System.out.println(message);
    }

    @Override
    public void printWorkflow(Workflow wf, WorkflowState state) {
        System.out.println("Component:             " + wf.componentId());
        System.out.println("Workflow:              " + wf.workflowId());
        System.out.println("Schedule:              " + wf.configuration().schedule());
        System.out.println("Offset:                " + wf.configuration().offset().orElse(""));
        System.out.println("Docker Image:          " + wf.configuration().dockerImage().orElse(""));
        System.out.println("Docker Arguments:      " + wf.configuration().dockerArgs().orElse(Collections.emptyList()));
        System.out.println("Termination Logging:   " + wf.configuration().dockerTerminationLogging());
        System.out.println("Service Account:       " + wf.configuration().serviceAccount().orElse(""));
        System.out.println("Resources:             " + wf.configuration().resources());
        System.out.println("Environment:           " + Joiner.on((char)' ').withKeyValueSeparator('=').join(wf.configuration().env()));
        System.out.println("Timeout:               " + wf.configuration().runningTimeout().map(Duration::toString).orElse(""));
        System.out.println("Commit:                " + wf.configuration().commitSha().orElse(""));
        System.out.println("Retry Condition:       " + wf.configuration().retryCondition().orElse(""));
        System.out.println("Enabled:               " + state.enabled().map(Object::toString).orElse(""));
        System.out.println("Next Trigger:          " + state.nextNaturalTrigger().map(Object::toString).orElse(""));
        System.out.println("Next Trigger (offset): " + state.nextNaturalOffsetTrigger().map(Object::toString).orElse(""));
    }

    private void printWorkflow(Workflow workflow, int cidLength, int widLength) {
        String format = WORKFLOW_FORMAT.replaceAll("<cid-length>", String.valueOf(cidLength)).replaceAll("<wid-length>", String.valueOf(widLength));
        System.out.println(String.format(format, workflow.componentId(), workflow.workflowId()));
    }

    @Override
    public void printWorkflows(List<Workflow> workflows) {
        int cidLength = workflows.stream().map(x -> x.componentId().length()).max(Comparator.naturalOrder()).orElse(1);
        int widLength = workflows.stream().map(x -> x.workflowId().length()).max(Comparator.naturalOrder()).orElse(1);
        this.printWorkflowHeader(cidLength, widLength);
        workflows.forEach(wf -> this.printWorkflow((Workflow)wf, cidLength, widLength));
    }

    @Override
    public void printError(String message) {
        System.err.println(message);
    }

    private String formatLongField(Optional<String> value, boolean noTruncate) {
        return value.map(x -> {
            if (noTruncate || x.length() <= 20) {
                return x;
            }
            return x.substring(0, 20) + ELLIPSIS;
        }).orElse(NA_VALUE);
    }

    private int effectiveLongFieldLength(Optional<String> value, String header, boolean noTruncate) {
        int length = value.orElse(NA_VALUE).length();
        if (length <= header.length()) {
            return header.length();
        }
        if (!noTruncate && length > 20 + ELLIPSIS.length()) {
            return 20 + ELLIPSIS.length();
        }
        return length;
    }

    private Ansi getAnsiForState(RunStateDataPayload.RunStateData runStateData) {
        String state;
        switch (state = runStateData.state()) {
            case "WAITING": 
            case "NEW": 
            case "QUEUED": 
            case "TERMINATED": {
                return CliUtil.coloredBright(Ansi.Color.BLACK, state);
            }
            case "PREPARE": 
            case "SUBMITTING": 
            case "SUBMITTED": {
                return CliUtil.colored(Ansi.Color.CYAN, state);
            }
            case "RUNNING": {
                return CliUtil.coloredBright(Ansi.Color.BLUE, state);
            }
            case "FAILED": {
                return CliUtil.colored(Ansi.Color.RED, state);
            }
            case "UNKNOWN": 
            case "ERROR": {
                return CliUtil.coloredBright(Ansi.Color.RED, state);
            }
            case "DONE": {
                return CliUtil.coloredBright(Ansi.Color.GREEN, state);
            }
        }
        return CliUtil.colored(Ansi.Color.DEFAULT, state);
    }

    private Ansi.Color messageColor(Message.MessageLevel level) {
        switch (level) {
            case INFO: {
                return Ansi.Color.GREEN;
            }
            case WARNING: {
                return Ansi.Color.YELLOW;
            }
            case ERROR: {
                return Ansi.Color.RED;
            }
        }
        return Ansi.Color.DEFAULT;
    }
}

