package com.spotify.styx.cli;

import com.spotify.styx.model.Workflow;
import com.spotify.styx.model.WorkflowState;
import io.norberg.automatter.AutoMatter;
import javax.annotation.Generated;

@Generated("io.norberg.automatter.processor.AutoMatterProcessor")
final class WorkflowWithStateBuilder {
  private Workflow workflow;

  private WorkflowState state;

  public WorkflowWithStateBuilder() {
  }

  private WorkflowWithStateBuilder(JsonCliOutput.WorkflowWithState v) {
    this.workflow = v.workflow();
    this.state = v.state();
  }

  private WorkflowWithStateBuilder(WorkflowWithStateBuilder v) {
    this.workflow = v.workflow;
    this.state = v.state;
  }

  public Workflow workflow() {
    return workflow;
  }

  public WorkflowWithStateBuilder workflow(Workflow workflow) {
    if (workflow == null) {
      throw new NullPointerException("workflow");
    }
    this.workflow = workflow;
    return this;
  }

  public WorkflowState state() {
    return state;
  }

  public WorkflowWithStateBuilder state(WorkflowState state) {
    if (state == null) {
      throw new NullPointerException("state");
    }
    this.state = state;
    return this;
  }

  public JsonCliOutput.WorkflowWithState build() {
    return new Value(workflow, state);
  }

  public static WorkflowWithStateBuilder from(JsonCliOutput.WorkflowWithState v) {
    return new WorkflowWithStateBuilder(v);
  }

  public static WorkflowWithStateBuilder from(WorkflowWithStateBuilder v) {
    return new WorkflowWithStateBuilder(v);
  }

  private static final class Value implements JsonCliOutput.WorkflowWithState {
    private final Workflow workflow;

    private final WorkflowState state;

    private Value(@AutoMatter.Field("workflow") Workflow workflow,
        @AutoMatter.Field("state") WorkflowState state) {
      if (workflow == null) {
        throw new NullPointerException("workflow");
      }
      if (state == null) {
        throw new NullPointerException("state");
      }
      this.workflow = workflow;
      this.state = state;
    }

    @AutoMatter.Field
    @Override
    public Workflow workflow() {
      return workflow;
    }

    @AutoMatter.Field
    @Override
    public WorkflowState state() {
      return state;
    }

    public WorkflowWithStateBuilder builder() {
      return new WorkflowWithStateBuilder(this);
    }

    @Override
    public boolean equals(Object o) {
      if (this == o) {
        return true;
      }
      if (!(o instanceof JsonCliOutput.WorkflowWithState)) {
        return false;
      }
      final JsonCliOutput.WorkflowWithState that = (JsonCliOutput.WorkflowWithState) o;
      if (workflow != null ? !workflow.equals(that.workflow()) : that.workflow() != null) {
        return false;
      }
      if (state != null ? !state.equals(that.state()) : that.state() != null) {
        return false;
      }
      return true;
    }

    @Override
    public int hashCode() {
      int result = 1;
      long temp;
      result = 31 * result + (this.workflow != null ? this.workflow.hashCode() : 0);
      result = 31 * result + (this.state != null ? this.state.hashCode() : 0);
      return result;
    }

    @Override
    public String toString() {
      return "JsonCliOutput.WorkflowWithState{" +
      "workflow=" + workflow +
      ", state=" + state +
      '}';
    }
  }
}
