/*
 * Decompiled with CFR 0.152.
 */
package com.cronutils.model.time;

import com.cronutils.model.time.NearestValue;
import com.cronutils.utils.Preconditions;
import com.cronutils.utils.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

class TimeNode {
    protected List<Integer> values;

    public TimeNode(List<Integer> values2) {
        this.values = Preconditions.checkNotNullNorEmpty(values2, (Object)"Values must not be empty");
        Collections.sort(this.values);
    }

    public NearestValue getNextValue(int reference, int shifts) {
        return this.getNearestForwardValue(reference, shifts);
    }

    public List<Integer> getValues() {
        return Collections.unmodifiableList(this.values);
    }

    public NearestValue getPreviousValue(int reference, int shifts) {
        return this.getNearestBackwardValue(reference, shifts);
    }

    @VisibleForTesting
    NearestValue getNearestForwardValue(int reference, int shiftsToApply) {
        ArrayList<Integer> values2 = new ArrayList<Integer>(this.values);
        int index = 0;
        boolean foundGreater = false;
        AtomicInteger shift = new AtomicInteger(0);
        if (!values2.contains(reference)) {
            for (Integer value : values2) {
                if (value <= reference) continue;
                index = values2.indexOf(value);
                --shiftsToApply;
                foundGreater = true;
                break;
            }
            if (!foundGreater) {
                shift.incrementAndGet();
            }
        } else {
            index = values2.indexOf(reference);
        }
        int value = (Integer)values2.get(index);
        for (int j = 0; j < shiftsToApply; ++j) {
            value = this.getValueFromList(values2, index + 1, shift);
            index = values2.indexOf(value);
        }
        return new NearestValue(value, shift.get());
    }

    @VisibleForTesting
    NearestValue getNearestBackwardValue(int reference, int shiftsToApply) {
        ArrayList<Integer> values2 = new ArrayList<Integer>(this.values);
        Collections.reverse(values2);
        int index = 0;
        boolean foundSmaller = false;
        AtomicInteger shift = new AtomicInteger(0);
        if (!values2.contains(reference)) {
            for (Integer value : values2) {
                if (value >= reference) continue;
                index = values2.indexOf(value);
                --shiftsToApply;
                foundSmaller = true;
                break;
            }
            if (!foundSmaller) {
                shift.incrementAndGet();
            }
        } else {
            index = values2.indexOf(reference);
        }
        int value = (Integer)values2.get(index);
        for (int j = 0; j < shiftsToApply; ++j) {
            value = this.getValueFromList(values2, index + 1, shift);
            index = values2.indexOf(value);
        }
        return new NearestValue(value, shift.get());
    }

    @VisibleForTesting
    int getValueFromList(List<Integer> values2, int index, AtomicInteger shift) {
        Preconditions.checkNotNullNorEmpty(values2, (Object)"List must not be empty");
        if (index < 0) {
            shift.incrementAndGet();
            return this.getValueFromList(values2, index += values2.size(), shift);
        }
        if (index >= values2.size()) {
            shift.incrementAndGet();
            return this.getValueFromList(values2, index -= values2.size(), shift);
        }
        return values2.get(index);
    }
}

