/*
 * Decompiled with CFR 0.152.
 */
package com.getsentry.raven.connection;

import com.getsentry.raven.connection.Connection;
import com.getsentry.raven.connection.ConnectionException;
import com.getsentry.raven.connection.EventSendFailureCallback;
import com.getsentry.raven.environment.RavenEnvironment;
import com.getsentry.raven.event.Event;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConnection
implements Connection {
    public static final String SENTRY_PROTOCOL_VERSION = "6";
    public static final long DEFAULT_MAX_WAITING_TIME = TimeUnit.MINUTES.toMillis(5L);
    public static final long DEFAULT_BASE_WAITING_TIME = TimeUnit.MILLISECONDS.toMillis(10L);
    private static final Logger logger = LoggerFactory.getLogger(AbstractConnection.class);
    private final AtomicBoolean lockdown = new AtomicBoolean();
    private final Lock lock = new ReentrantLock();
    private final Condition condition = this.lock.newCondition();
    private final String authHeader;
    private long maxWaitingTime = DEFAULT_MAX_WAITING_TIME;
    private long baseWaitingTime;
    private long waitingTime = this.baseWaitingTime = DEFAULT_BASE_WAITING_TIME;
    private Set<EventSendFailureCallback> eventSendFailureCallbacks = new HashSet<EventSendFailureCallback>();

    protected AbstractConnection(String publicKey, String secretKey) {
        this.authHeader = "Sentry sentry_version=6,sentry_client=" + RavenEnvironment.getRavenName() + ",sentry_key=" + publicKey + ",sentry_secret=" + secretKey;
    }

    protected String getAuthHeader() {
        return this.authHeader;
    }

    @Override
    public final void send(Event event) throws ConnectionException {
        try {
            this.waitIfLockedDown();
            this.doSend(event);
            this.waitingTime = this.baseWaitingTime;
        }
        catch (ConnectionException e) {
            logger.warn("An exception due to the connection occurred, a lockdown will be initiated.", e);
            this.lockDown();
            for (EventSendFailureCallback eventSendFailureCallback : this.eventSendFailureCallbacks) {
                try {
                    eventSendFailureCallback.onFailure(event, e);
                }
                catch (Exception exc) {
                    logger.warn("An exception occurred while running an EventSendFailureCallback: " + eventSendFailureCallback.getClass().getName(), exc);
                }
            }
            throw e;
        }
    }

    private void waitIfLockedDown() {
        while (this.lockdown.get()) {
            this.lock.lock();
            try {
                if (!this.lockdown.get()) continue;
                this.condition.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                logger.warn("An exception occurred during the lockdown.", e);
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lockDown() {
        if (!this.lockdown.compareAndSet(false, true)) {
            return;
        }
        try {
            logger.warn("Lockdown started for {}ms.", (Object)this.waitingTime);
            Thread.sleep(this.waitingTime);
            if (this.waitingTime < this.maxWaitingTime) {
                this.waitingTime <<= 1;
            }
        }
        catch (Exception e) {
            logger.warn("An exception occurred during the lockdown.", e);
        }
        finally {
            this.lockdown.set(false);
            this.lock.lock();
            try {
                this.condition.signalAll();
            }
            finally {
                this.lock.unlock();
            }
            logger.warn("Lockdown ended.");
        }
    }

    protected abstract void doSend(Event var1) throws ConnectionException;

    public void setMaxWaitingTime(long maxWaitingTime) {
        this.maxWaitingTime = maxWaitingTime;
    }

    public void setBaseWaitingTime(long baseWaitingTime) {
        this.baseWaitingTime = baseWaitingTime;
    }

    @Override
    public void addEventSendFailureCallback(EventSendFailureCallback eventSendFailureCallback) {
        this.eventSendFailureCallbacks.add(eventSendFailureCallback);
    }
}

