/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.styx.api;

import com.spotify.styx.api.RunStateDataBuilder;
import com.spotify.styx.api.RunStateDataPayloadBuilder;
import com.spotify.styx.model.WorkflowInstance;
import com.spotify.styx.state.StateData;
import io.norberg.automatter.AutoMatter;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;

@AutoMatter
public interface RunStateDataPayload {
    public List<RunStateData> activeStates();

    public static RunStateDataPayload create(List<RunStateData> runStateDataList) {
        return new RunStateDataPayloadBuilder().activeStates(runStateDataList).build();
    }

    @AutoMatter
    public static interface RunStateData {
        public static final Comparator<RunStateData> PARAMETER_COMPARATOR = Comparator.comparing(a -> a.workflowInstance().parameter());

        public WorkflowInstance workflowInstance();

        public String state();

        public StateData stateData();

        public Optional<Long> initialTimestamp();

        public Optional<Long> latestTimestamp();

        public RunStateDataBuilder builder();

        public static RunStateDataBuilder newBuilder() {
            return new RunStateDataBuilder();
        }

        public static RunStateData create(WorkflowInstance workflowInstance, String state, StateData stateData) {
            return RunStateData.newBuilder().workflowInstance(workflowInstance).state(state).stateData(stateData).build();
        }
    }
}

