/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.styx.cli;

import com.spotify.styx.cli.JsonCliOutput;
import com.spotify.styx.model.Workflow;
import com.spotify.styx.model.WorkflowState;
import io.norberg.automatter.AutoMatter;

final class WorkflowWithStateBuilder {
    private Workflow workflow;
    private WorkflowState state;

    public WorkflowWithStateBuilder() {
    }

    private WorkflowWithStateBuilder(JsonCliOutput.WorkflowWithState v) {
        this.workflow = v.workflow();
        this.state = v.state();
    }

    private WorkflowWithStateBuilder(WorkflowWithStateBuilder v) {
        this.workflow = v.workflow;
        this.state = v.state;
    }

    public Workflow workflow() {
        return this.workflow;
    }

    public WorkflowWithStateBuilder workflow(Workflow workflow) {
        if (workflow == null) {
            throw new NullPointerException("workflow");
        }
        this.workflow = workflow;
        return this;
    }

    public WorkflowState state() {
        return this.state;
    }

    public WorkflowWithStateBuilder state(WorkflowState state) {
        if (state == null) {
            throw new NullPointerException("state");
        }
        this.state = state;
        return this;
    }

    public JsonCliOutput.WorkflowWithState build() {
        return new Value(this.workflow, this.state);
    }

    public static WorkflowWithStateBuilder from(JsonCliOutput.WorkflowWithState v) {
        return new WorkflowWithStateBuilder(v);
    }

    public static WorkflowWithStateBuilder from(WorkflowWithStateBuilder v) {
        return new WorkflowWithStateBuilder(v);
    }

    private static final class Value
    implements JsonCliOutput.WorkflowWithState {
        private final Workflow workflow;
        private final WorkflowState state;

        private Value(@AutoMatter.Field(value="workflow") Workflow workflow, @AutoMatter.Field(value="state") WorkflowState state) {
            if (workflow == null) {
                throw new NullPointerException("workflow");
            }
            if (state == null) {
                throw new NullPointerException("state");
            }
            this.workflow = workflow;
            this.state = state;
        }

        @Override
        @AutoMatter.Field
        public Workflow workflow() {
            return this.workflow;
        }

        @Override
        @AutoMatter.Field
        public WorkflowState state() {
            return this.state;
        }

        public WorkflowWithStateBuilder builder() {
            return new WorkflowWithStateBuilder(this);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof JsonCliOutput.WorkflowWithState)) {
                return false;
            }
            JsonCliOutput.WorkflowWithState that = (JsonCliOutput.WorkflowWithState)o;
            if (this.workflow != null ? !this.workflow.equals(that.workflow()) : that.workflow() != null) {
                return false;
            }
            return !(this.state != null ? !this.state.equals(that.state()) : that.state() != null);
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.workflow != null ? this.workflow.hashCode() : 0);
            result = 31 * result + (this.state != null ? this.state.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "JsonCliOutput.WorkflowWithState{workflow=" + this.workflow + ", state=" + this.state + "}";
        }
    }
}

