/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.styx.client;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.auth.oauth2.GoogleCredentials;
import com.spotify.styx.api.BackfillPayload;
import com.spotify.styx.api.BackfillsPayload;
import com.spotify.styx.api.ResourcesPayload;
import com.spotify.styx.api.RunStateDataPayload;
import com.spotify.styx.api.TestServiceAccountUsageAuthorizationRequest;
import com.spotify.styx.api.TestServiceAccountUsageAuthorizationRequestBuilder;
import com.spotify.styx.api.TestServiceAccountUsageAuthorizationResponse;
import com.spotify.styx.client.ApiErrorException;
import com.spotify.styx.client.ClientErrorException;
import com.spotify.styx.client.FutureOkHttpClient;
import com.spotify.styx.client.GoogleIdTokenAuth;
import com.spotify.styx.client.StyxClient;
import com.spotify.styx.model.Backfill;
import com.spotify.styx.model.BackfillInput;
import com.spotify.styx.model.EditableBackfillInput;
import com.spotify.styx.model.Event;
import com.spotify.styx.model.Resource;
import com.spotify.styx.model.TriggerParameters;
import com.spotify.styx.model.TriggerRequest;
import com.spotify.styx.model.Workflow;
import com.spotify.styx.model.WorkflowConfiguration;
import com.spotify.styx.model.WorkflowId;
import com.spotify.styx.model.WorkflowInstance;
import com.spotify.styx.model.WorkflowState;
import com.spotify.styx.model.data.EventInfo;
import com.spotify.styx.model.data.WorkflowInstanceExecutionData;
import com.spotify.styx.serialization.Json;
import com.spotify.styx.util.EventUtil;
import java.io.IOException;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class StyxOkHttpClient
implements StyxClient {
    private static final Logger LOG = LoggerFactory.getLogger(StyxOkHttpClient.class);
    static final String STYX_API_VERSION = "v3";
    private static final String STYX_CLIENT_VERSION = "Styx Client " + StyxOkHttpClient.class.getPackage().getImplementationVersion();
    private final URI apiHost;
    private final FutureOkHttpClient client;
    private final GoogleIdTokenAuth auth;

    private StyxOkHttpClient(String apiHost, FutureOkHttpClient client, GoogleIdTokenAuth auth) {
        this.apiHost = apiHost.contains("://") ? URI.create(apiHost) : URI.create("https://" + apiHost);
        this.client = Objects.requireNonNull(client, "client");
        this.auth = Objects.requireNonNull(auth, "auth");
    }

    public static StyxClient create(String apiHost) {
        return StyxOkHttpClient.create(apiHost, FutureOkHttpClient.createDefault(), GoogleIdTokenAuth.ofDefaultCredential());
    }

    public static StyxClient create(String apiHost, GoogleCredentials credentials) {
        return StyxOkHttpClient.create(apiHost, FutureOkHttpClient.createDefault(), GoogleIdTokenAuth.of(credentials));
    }

    public static StyxClient create(String apiHost, OkHttpClient client) {
        return StyxOkHttpClient.create(apiHost, FutureOkHttpClient.create(client), GoogleIdTokenAuth.ofDefaultCredential());
    }

    public static StyxClient create(String apiHost, OkHttpClient client, GoogleCredentials credentials) {
        return StyxOkHttpClient.create(apiHost, FutureOkHttpClient.create(client), GoogleIdTokenAuth.of(credentials));
    }

    static StyxClient create(String apiHost, FutureOkHttpClient client, GoogleCredentials credentials) {
        return new StyxOkHttpClient(apiHost, client, GoogleIdTokenAuth.of(credentials));
    }

    static StyxClient create(String apiHost, FutureOkHttpClient client, GoogleIdTokenAuth auth) {
        return new StyxOkHttpClient(apiHost, client, auth);
    }

    @Override
    public CompletionStage<RunStateDataPayload> activeStates(Optional<String> componentId) {
        HttpUrl.Builder url = this.urlBuilder("status", "activeStates");
        componentId.ifPresent(id -> url.addQueryParameter("component", (String)id));
        return this.execute(FutureOkHttpClient.forUri(url), RunStateDataPayload.class);
    }

    @Override
    public CompletionStage<List<EventInfo>> eventsForWorkflowInstance(String componentId, String workflowId, String parameter) {
        return this.execute(FutureOkHttpClient.forUri(this.urlBuilder("status", "events", componentId, workflowId, parameter))).thenApply(response -> {
            JsonNode jsonNode;
            try (ResponseBody responseBody = response.body();){
                jsonNode = Json.OBJECT_MAPPER.readTree(responseBody.bytes());
            }
            catch (IOException e) {
                throw new RuntimeException("Invalid json returned from API", e);
            }
            if (!jsonNode.isObject()) {
                throw new RuntimeException("Unexpected json returned from API");
            }
            ArrayNode events = ((ObjectNode)jsonNode).withArray("events");
            return StreamSupport.stream(events.spliterator(), false).map(eventWithTimestamp -> {
                long ts = eventWithTimestamp.get("timestamp").asLong();
                JsonNode event = eventWithTimestamp.get("event");
                try {
                    Event typedEvent = Json.OBJECT_MAPPER.convertValue((Object)event, Event.class);
                    return EventInfo.create(ts, EventUtil.name(typedEvent), EventUtil.info(typedEvent));
                }
                catch (IllegalArgumentException e) {
                    return EventInfo.create(ts, event.get("@type").asText(), "");
                }
            }).collect(Collectors.toList());
        });
    }

    @Override
    public CompletionStage<TestServiceAccountUsageAuthorizationResponse> testServiceAccountUsageAuthorization(String serviceAccountEmail, String principalEmail) {
        TestServiceAccountUsageAuthorizationRequest request = new TestServiceAccountUsageAuthorizationRequestBuilder().serviceAccount(serviceAccountEmail).principal(principalEmail).build();
        return this.execute(FutureOkHttpClient.forUri(this.urlBuilder("status", "testServiceAccountUsageAuthorization"), "POST", (Object)request), TestServiceAccountUsageAuthorizationResponse.class);
    }

    @Override
    public CompletionStage<Workflow> workflow(String componentId, String workflowId) {
        return this.execute(FutureOkHttpClient.forUri(this.urlBuilder("workflows", componentId, workflowId)), Workflow.class);
    }

    @Override
    public CompletionStage<List<Workflow>> workflows() {
        return this.execute(FutureOkHttpClient.forUri(this.urlBuilder("workflows")), Workflow[].class).thenApply(Arrays::asList);
    }

    @Override
    public CompletionStage<Workflow> createOrUpdateWorkflow(String componentId, WorkflowConfiguration workflowConfig) {
        return this.execute(FutureOkHttpClient.forUri(this.urlBuilder("workflows", componentId), "POST", (Object)workflowConfig), Workflow.class);
    }

    @Override
    public CompletionStage<Void> deleteWorkflow(String componentId, String workflowId) {
        return this.execute(FutureOkHttpClient.forUri(this.urlBuilder("workflows", componentId, workflowId), "DELETE")).thenApply(response -> null);
    }

    @Override
    public CompletionStage<WorkflowState> workflowState(String componentId, String workflowId) {
        return this.execute(FutureOkHttpClient.forUri(this.urlBuilder("workflows", componentId, workflowId, "state")), WorkflowState.class);
    }

    @Override
    public CompletionStage<WorkflowInstanceExecutionData> workflowInstanceExecutions(String componentId, String workflowId, String parameter) {
        return this.execute(FutureOkHttpClient.forUri(this.urlBuilder("workflows", componentId, workflowId, "instances", parameter)), WorkflowInstanceExecutionData.class);
    }

    @Override
    public CompletionStage<WorkflowState> updateWorkflowState(String componentId, String workflowId, WorkflowState workflowState) {
        return this.execute(FutureOkHttpClient.forUri(this.urlBuilder("workflows", componentId, workflowId, "state"), "PATCH", (Object)workflowState), WorkflowState.class);
    }

    @Override
    public CompletionStage<Void> triggerWorkflowInstance(String componentId, String workflowId, String parameter) {
        return this.triggerWorkflowInstance(componentId, workflowId, parameter, TriggerParameters.zero());
    }

    @Override
    public CompletionStage<Void> triggerWorkflowInstance(String componentId, String workflowId, String parameter, TriggerParameters triggerParameters) {
        return this.triggerWorkflowInstance(componentId, workflowId, parameter, triggerParameters, false);
    }

    @Override
    public CompletionStage<Void> triggerWorkflowInstance(String componentId, String workflowId, String parameter, TriggerParameters triggerParameters, boolean allowFuture) {
        TriggerRequest triggerRequest = TriggerRequest.of(WorkflowId.create(componentId, workflowId), parameter, triggerParameters);
        return this.execute(FutureOkHttpClient.forUri(this.urlBuilder("scheduler", "trigger").addQueryParameter("allowFuture", String.valueOf(allowFuture)), "POST", (Object)triggerRequest)).thenApply(response -> null);
    }

    @Override
    public CompletionStage<Void> haltWorkflowInstance(String componentId, String workflowId, String parameter) {
        HttpUrl.Builder url = this.urlBuilder("scheduler", "halt");
        WorkflowInstance workflowInstance = WorkflowInstance.create(WorkflowId.create(componentId, workflowId), parameter);
        return this.execute(FutureOkHttpClient.forUri(url, "POST", (Object)workflowInstance)).thenApply(response -> null);
    }

    @Override
    public CompletionStage<Void> retryWorkflowInstance(String componentId, String workflowId, String parameter) {
        HttpUrl.Builder url = this.urlBuilder("scheduler", "retry");
        WorkflowInstance workflowInstance = WorkflowInstance.create(WorkflowId.create(componentId, workflowId), parameter);
        return this.execute(FutureOkHttpClient.forUri(url, "POST", (Object)workflowInstance)).thenApply(response -> null);
    }

    @Override
    public CompletionStage<Resource> resourceCreate(String resourceId, int concurrency) {
        Resource resource = Resource.create(resourceId, concurrency);
        return this.execute(FutureOkHttpClient.forUri(this.urlBuilder("resources"), "POST", (Object)resource), Resource.class);
    }

    @Override
    public CompletionStage<Resource> resourceEdit(String resourceId, int concurrency) {
        Resource resource = Resource.create(resourceId, concurrency);
        return this.execute(FutureOkHttpClient.forUri(this.urlBuilder("resources", resourceId), "PUT", (Object)resource), Resource.class);
    }

    @Override
    public CompletionStage<Resource> resource(String resourceId) {
        HttpUrl.Builder url = this.urlBuilder("resources", resourceId);
        return this.execute(FutureOkHttpClient.forUri(url), Resource.class);
    }

    @Override
    public CompletionStage<ResourcesPayload> resourceList() {
        HttpUrl.Builder url = this.urlBuilder("resources");
        return this.execute(FutureOkHttpClient.forUri(url), ResourcesPayload.class);
    }

    @Override
    public CompletionStage<Backfill> backfillCreate(String componentId, String workflowId, String start, String end, int concurrency) {
        return this.backfillCreate(componentId, workflowId, start, end, concurrency, null);
    }

    @Override
    public CompletionStage<Backfill> backfillCreate(String componentId, String workflowId, String start, String end, int concurrency, String description) {
        BackfillInput backfill = BackfillInput.newBuilder().start(Instant.parse(start)).end(Instant.parse(end)).component(componentId).workflow(workflowId).concurrency(concurrency).description(Optional.ofNullable(description)).build();
        return this.backfillCreate(backfill);
    }

    @Override
    public CompletionStage<Backfill> backfillCreate(BackfillInput backfill) {
        return this.backfillCreate(backfill, false);
    }

    @Override
    public CompletionStage<Backfill> backfillCreate(BackfillInput backfill, boolean allowFuture) {
        return this.execute(FutureOkHttpClient.forUri(this.urlBuilder("backfills").addQueryParameter("allowFuture", String.valueOf(allowFuture)), "POST", (Object)backfill), Backfill.class);
    }

    @Override
    public CompletionStage<Backfill> backfillEditConcurrency(String backfillId, int concurrency) {
        EditableBackfillInput editableBackfillInput = EditableBackfillInput.newBuilder().id(backfillId).concurrency(concurrency).build();
        HttpUrl.Builder url = this.urlBuilder("backfills", backfillId);
        return this.execute(FutureOkHttpClient.forUri(url, "PUT", (Object)editableBackfillInput), Backfill.class);
    }

    @Override
    public CompletionStage<Void> backfillHalt(String backfillId) {
        return this.execute(FutureOkHttpClient.forUri(this.urlBuilder("backfills", backfillId), "DELETE")).thenApply(response -> null);
    }

    @Override
    public CompletionStage<BackfillPayload> backfill(String backfillId, boolean includeStatus) {
        HttpUrl.Builder url = this.urlBuilder("backfills", backfillId);
        url.addQueryParameter("status", Boolean.toString(includeStatus));
        return this.execute(FutureOkHttpClient.forUri(url), BackfillPayload.class);
    }

    @Override
    public CompletionStage<BackfillsPayload> backfillList(Optional<String> componentId, Optional<String> workflowId, boolean showAll, boolean includeStatus) {
        HttpUrl.Builder url = this.urlBuilder("backfills");
        componentId.ifPresent(c -> url.addQueryParameter("component", (String)c));
        workflowId.ifPresent(w -> url.addQueryParameter("workflow", (String)w));
        url.addQueryParameter("showAll", Boolean.toString(showAll));
        url.addQueryParameter("status", Boolean.toString(includeStatus));
        return this.execute(FutureOkHttpClient.forUri(url), BackfillsPayload.class);
    }

    private <T> CompletionStage<T> execute(Request request, Class<T> tClass) {
        return this.execute(request).thenApply(response -> {
            ResponseBody responseBody = response.body();
            try {
                Object t = Json.OBJECT_MAPPER.readValue(responseBody.bytes(), tClass);
                if (responseBody != null) {
                    responseBody.close();
                }
                return t;
            }
            catch (Throwable throwable) {
                try {
                    if (responseBody != null) {
                        try {
                            responseBody.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Error while reading the received payload: " + e.getMessage(), e);
                }
            }
        });
    }

    private Request decorateRequest(Request request, String requestId, Optional<String> authToken) {
        Request.Builder builder = request.newBuilder().addHeader("User-Agent", STYX_CLIENT_VERSION).addHeader("X-Request-Id", requestId);
        authToken.ifPresent(t -> builder.addHeader("Authorization", "Bearer " + t));
        return builder.build();
    }

    private CompletionStage<Response> execute(Request request) {
        Optional<String> authToken;
        try {
            authToken = this.auth.getToken(this.apiHost.toString());
        }
        catch (IOException | GeneralSecurityException e2) {
            throw new ClientErrorException("Authentication failure: " + e2.getMessage(), e2);
        }
        String requestId = UUID.randomUUID().toString().replace("-", "");
        return this.client.send(this.decorateRequest(request, requestId, authToken)).handle((response, e) -> {
            String effectiveRequestId;
            if (e != null) {
                throw new ClientErrorException("Request failed: " + request.method() + " " + request.url(), (Throwable)e);
            }
            String responseRequestId = response.headers().get("X-Request-Id");
            if (responseRequestId != null && !responseRequestId.equals(requestId)) {
                effectiveRequestId = responseRequestId;
                LOG.warn("Request ID mismatch: '{}' != '{}'", (Object)requestId, (Object)responseRequestId);
            } else {
                effectiveRequestId = requestId;
            }
            if (!response.isSuccessful()) {
                throw new ApiErrorException(response.code() + " " + response.message(), response.code(), authToken.isPresent(), effectiveRequestId);
            }
            return response;
        });
    }

    private HttpUrl.Builder urlBuilder(String ... pathSegments) {
        HttpUrl.Builder builder = new HttpUrl.Builder().scheme(this.apiHost.getScheme()).host(this.apiHost.getHost()).addPathSegment("api").addPathSegment(STYX_API_VERSION);
        Arrays.stream(pathSegments).forEach(builder::addPathSegment);
        if (this.apiHost.getPort() != -1) {
            builder.port(this.apiHost.getPort());
        }
        return builder;
    }

    @Override
    public void close() {
        this.client.close();
    }
}

