/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.styx.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.spotify.styx.model.WorkflowState;
import java.time.Instant;
import java.util.Optional;

final class AutoValue_WorkflowState
extends WorkflowState {
    private final Optional<Boolean> enabled;
    private final Optional<Instant> nextNaturalTrigger;
    private final Optional<Instant> nextNaturalOffsetTrigger;

    private AutoValue_WorkflowState(Optional<Boolean> enabled, Optional<Instant> nextNaturalTrigger, Optional<Instant> nextNaturalOffsetTrigger) {
        this.enabled = enabled;
        this.nextNaturalTrigger = nextNaturalTrigger;
        this.nextNaturalOffsetTrigger = nextNaturalOffsetTrigger;
    }

    @Override
    @JsonProperty
    public Optional<Boolean> enabled() {
        return this.enabled;
    }

    @Override
    @JsonProperty
    public Optional<Instant> nextNaturalTrigger() {
        return this.nextNaturalTrigger;
    }

    @Override
    @JsonProperty
    public Optional<Instant> nextNaturalOffsetTrigger() {
        return this.nextNaturalOffsetTrigger;
    }

    public String toString() {
        return "WorkflowState{enabled=" + this.enabled + ", nextNaturalTrigger=" + this.nextNaturalTrigger + ", nextNaturalOffsetTrigger=" + this.nextNaturalOffsetTrigger + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof WorkflowState) {
            WorkflowState that = (WorkflowState)o;
            return this.enabled.equals(that.enabled()) && this.nextNaturalTrigger.equals(that.nextNaturalTrigger()) && this.nextNaturalOffsetTrigger.equals(that.nextNaturalOffsetTrigger());
        }
        return false;
    }

    public int hashCode() {
        int h2 = 1;
        h2 *= 1000003;
        h2 ^= this.enabled.hashCode();
        h2 *= 1000003;
        h2 ^= this.nextNaturalTrigger.hashCode();
        h2 *= 1000003;
        return h2 ^= this.nextNaturalOffsetTrigger.hashCode();
    }

    @Override
    public WorkflowState.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends WorkflowState.Builder {
        private Optional<Boolean> enabled = Optional.empty();
        private Optional<Instant> nextNaturalTrigger = Optional.empty();
        private Optional<Instant> nextNaturalOffsetTrigger = Optional.empty();

        Builder() {
        }

        private Builder(WorkflowState source2) {
            this.enabled = source2.enabled();
            this.nextNaturalTrigger = source2.nextNaturalTrigger();
            this.nextNaturalOffsetTrigger = source2.nextNaturalOffsetTrigger();
        }

        @Override
        public WorkflowState.Builder enabled(boolean enabled) {
            this.enabled = Optional.of(enabled);
            return this;
        }

        @Override
        public WorkflowState.Builder nextNaturalTrigger(Instant nextNaturalTrigger) {
            if (nextNaturalTrigger == null) {
                throw new NullPointerException("Null nextNaturalTrigger");
            }
            this.nextNaturalTrigger = Optional.of(nextNaturalTrigger);
            return this;
        }

        @Override
        public WorkflowState.Builder nextNaturalOffsetTrigger(Instant nextNaturalOffsetTrigger) {
            if (nextNaturalOffsetTrigger == null) {
                throw new NullPointerException("Null nextNaturalOffsetTrigger");
            }
            this.nextNaturalOffsetTrigger = Optional.of(nextNaturalOffsetTrigger);
            return this;
        }

        @Override
        public WorkflowState build() {
            return new AutoValue_WorkflowState(this.enabled, this.nextNaturalTrigger, this.nextNaturalOffsetTrigger);
        }
    }
}

