/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.styx.model;

import com.spotify.styx.model.ExecutionDescriptionBuilder;
import com.spotify.styx.model.WorkflowConfiguration;
import io.norberg.automatter.AutoMatter;
import java.util.List;
import java.util.Map;
import java.util.Optional;

@AutoMatter
public interface ExecutionDescription {
    public String dockerImage();

    public List<String> dockerArgs();

    public boolean dockerTerminationLogging();

    public Optional<WorkflowConfiguration.Secret> secret();

    public Optional<String> serviceAccount();

    public Optional<String> commitSha();

    public Map<String, String> env();

    public static ExecutionDescriptionBuilder builder() {
        return new ExecutionDescriptionBuilder();
    }

    public static ExecutionDescription forImage(String dockerImage) {
        return ExecutionDescription.builder().dockerImage(dockerImage).build();
    }
}

