/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.styx.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import com.spotify.styx.model.AutoValue_WorkflowInstance;
import com.spotify.styx.model.WorkflowId;
import java.util.Comparator;

@AutoValue
public abstract class WorkflowInstance {
    public static final Comparator<WorkflowInstance> KEY_COMPARATOR = (a, b) -> a.toKey().compareTo(b.toKey());

    @JsonProperty
    public abstract WorkflowId workflowId();

    @JsonProperty
    public abstract String parameter();

    public String toKey() {
        return this.workflowId().toKey() + "#" + this.parameter();
    }

    @JsonCreator
    public static WorkflowInstance create(@JsonProperty(value="workflow_id") WorkflowId workflowId, @JsonProperty(value="parameter") String parameter) {
        return new AutoValue_WorkflowInstance(workflowId, parameter);
    }

    public static WorkflowInstance parseKey(String key) {
        int lastHashPos = key.lastIndexOf(35);
        if (lastHashPos < 1) {
            throw new IllegalArgumentException("Key must contain a hash '#' sign on position > 0");
        }
        WorkflowId workflowId = WorkflowId.parseKey(key.substring(0, lastHashPos));
        return WorkflowInstance.create(workflowId, key.substring(lastHashPos + 1));
    }

    public String toString() {
        return this.toKey();
    }
}

