/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.styx.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DockerImageValidator {
    private static final Pattern DOMAIN_PATTERN = Pattern.compile("^(?:(?:[a-zA-Z0-9]|(?:[a-zA-Z0-9][a-zA-Z0-9\\-]*[a-zA-Z0-9]))(\\.(?:[a-zA-Z0-9]|(?:[a-zA-Z0-9][a-zA-Z0-9\\-]*[a-zA-Z0-9])))*)\\.?$");
    private static final Pattern IPV4_PATTERN = Pattern.compile("^(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})$");
    private static final Pattern NAME_COMPONENT_PATTERN = Pattern.compile("^([a-z0-9._-]+)$");
    private static final int REPO_NAME_MAX_LENGTH = 255;
    private static final Pattern TAG_PATTERN = Pattern.compile("[\\w][\\w.-]{0,127}");
    private static final Pattern DIGEST_PATTERN = Pattern.compile("(?<algorithm>[A-Za-z][A-Za-z0-9]*(?:[-_+.][A-Za-z][A-Za-z0-9]*)*)[:](?<identifier>[\\p{XDigit}]{32,})");
    private static final Pattern SHA256_IDENTIFIER_PATTERN = Pattern.compile("[a-f0-9]{64}");
    private static final Pattern DIGIT_PERIOD = Pattern.compile("^[0-9.]+$");

    public Collection<String> validateImageReference(String imageRef) {
        HashSet<String> errors = new HashSet<String>();
        this.validateImageReference(imageRef, errors);
        return errors;
    }

    private boolean validateImageReference(String imageRef, Collection<String> errors) {
        String repo;
        String tag;
        int tagColon;
        int tagEnd;
        boolean valid = true;
        int lastAtSign = imageRef.lastIndexOf(64);
        if (lastAtSign != -1) {
            String digest = imageRef.substring(lastAtSign + 1);
            tagEnd = lastAtSign;
            tagColon = imageRef.lastIndexOf(58, tagEnd);
            valid &= this.validateDigest(digest, errors);
        } else {
            tagColon = imageRef.lastIndexOf(58);
            tagEnd = imageRef.length();
        }
        if (tagColon != -1 && !(tag = imageRef.substring(tagColon + 1, tagEnd)).contains("/")) {
            repo = imageRef.substring(0, tagColon);
            valid &= this.validateTag(tag, errors);
        } else {
            repo = imageRef.substring(0, tagEnd);
        }
        String invalidRepoName = "Invalid repository name (ex: \"registry.domain.tld/myrepos\")";
        if (repo.contains("://")) {
            errors.add("Invalid repository name (ex: \"registry.domain.tld/myrepos\")");
            return false;
        }
        String[] nameParts = repo.split("/", 2);
        if (!(nameParts[0].contains(".") || nameParts[0].contains(":") || nameParts[0].equals("localhost"))) {
            return this.validateRepositoryName(imageRef, repo, errors);
        }
        if (nameParts.length < 2) {
            errors.add("Invalid repository name (ex: \"registry.domain.tld/myrepos\")");
            return false;
        }
        String endpoint = nameParts[0];
        String reposName = nameParts[1];
        valid &= this.validateEndpoint(endpoint, errors);
        return valid &= this.validateRepositoryName(imageRef, reposName, errors);
    }

    private boolean validateTag(String tag, Collection<String> errors) {
        if (tag.isEmpty()) {
            errors.add("Tag cannot be empty");
            return false;
        }
        if (!TAG_PATTERN.matcher(tag).matches()) {
            errors.add(String.format("Illegal tag: \"%s\", must match %s", tag, TAG_PATTERN));
            return false;
        }
        return true;
    }

    private boolean validateDigest(String digest, Collection<String> errors) {
        if (digest.isEmpty()) {
            errors.add("Digest cannot be empty");
            return false;
        }
        Matcher matcher = DIGEST_PATTERN.matcher(digest);
        if (!matcher.matches()) {
            errors.add(String.format("Illegal digest: \"%s\"", digest));
            return false;
        }
        String algorithm = matcher.group("algorithm");
        String identifier = matcher.group("identifier");
        if ("sha256".equals(algorithm) && !SHA256_IDENTIFIER_PATTERN.matcher(identifier).matches()) {
            errors.add(String.format("Illegal digest: \"%s\"", digest));
            return false;
        }
        return true;
    }

    private boolean validateEndpoint(String endpoint, Collection<String> errors) {
        String[] parts = endpoint.split(":", 2);
        if (!this.validateAddress(parts[0], errors)) {
            return false;
        }
        if (parts.length > 1) {
            int port;
            try {
                port = Integer.valueOf(parts[1]);
            }
            catch (NumberFormatException e) {
                errors.add(String.format("Invalid port in endpoint: \"%s\"", endpoint));
                return false;
            }
            if (port < 0 || port > 65535) {
                errors.add(String.format("Invalid port in endpoint: \"%s\"", endpoint));
                return false;
            }
        }
        return true;
    }

    private boolean validateAddress(String address, Collection<String> errors) {
        if (IPV4_PATTERN.matcher(address).matches()) {
            return true;
        }
        if (!DOMAIN_PATTERN.matcher(address).matches() || DIGIT_PERIOD.matcher(address).find()) {
            errors.add(String.format("Invalid domain name: \"%s\"", address));
            return false;
        }
        return true;
    }

    private boolean validateRepositoryName(String imageName, String repositoryName, Collection<String> errors) {
        String[] nameParts;
        for (String name : nameParts = repositoryName.split("/")) {
            if (NAME_COMPONENT_PATTERN.matcher(name).matches()) continue;
            errors.add(String.format("Invalid image name (%s), only %s is allowed for each slash-separated name component (failed on \"%s\")", imageName, NAME_COMPONENT_PATTERN, name));
            return false;
        }
        if (repositoryName.length() > 255) {
            errors.add(String.format("Invalid image name (%s), repository name cannot be larger than %d characters", imageName, 255));
            return false;
        }
        return true;
    }
}

