/*
 * Decompiled with CFR 0.152.
 */
package com.cronutils.model.field.definition;

import com.cronutils.model.field.CronFieldName;
import com.cronutils.model.field.constraint.FieldConstraints;
import com.cronutils.utils.Preconditions;
import java.io.Serializable;
import java.util.Comparator;

public class FieldDefinition
implements Serializable {
    private CronFieldName fieldName;
    private FieldConstraints constraints;
    private final boolean optional;

    public FieldDefinition(CronFieldName fieldName, FieldConstraints constraints) {
        this(fieldName, constraints, false);
    }

    public FieldDefinition(CronFieldName fieldName, FieldConstraints constraints, boolean optional) {
        this.fieldName = Preconditions.checkNotNull(fieldName, "CronFieldName must not be null");
        this.constraints = Preconditions.checkNotNull(constraints, "FieldConstraints must not be null");
        this.optional = optional;
    }

    public CronFieldName getFieldName() {
        return this.fieldName;
    }

    public FieldConstraints getConstraints() {
        return this.constraints;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public static Comparator<FieldDefinition> createFieldDefinitionComparator() {
        return Comparator.comparingInt(o -> o.getFieldName().getOrder());
    }
}

