/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.styx.util;

import com.google.common.base.Ticker;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.spotify.styx.util.Time;
import java.time.Duration;
import java.util.concurrent.Executors;
import java.util.function.Supplier;
import javaslang.control.Try;

public class CachedSupplier<T>
implements Supplier<T> {
    static final Duration DEFAULT_TIMEOUT = Duration.ofSeconds(30L);
    private final LoadingCache<Boolean, T> cache;

    public CachedSupplier(Try.CheckedSupplier<T> delegate, Time time) {
        this(delegate, time, DEFAULT_TIMEOUT);
    }

    CachedSupplier(Try.CheckedSupplier<T> delegate, final Time time, Duration timeout) {
        this.cache = CacheBuilder.newBuilder().maximumSize(1L).refreshAfterWrite(timeout).ticker(new Ticker(){

            @Override
            public long read() {
                return time.nanoTime();
            }
        }).build(new AsyncLoader<T>(delegate));
    }

    @Override
    public T get() {
        return (T)Try.of(() -> this.cache.get(Boolean.TRUE)).get();
    }

    private static class AsyncLoader<T>
    extends CacheLoader<Boolean, T> {
        private static final ListeningExecutorService EXECUTOR = MoreExecutors.listeningDecorator(Executors.newCachedThreadPool());
        private final Try.CheckedSupplier<T> delegate;

        private AsyncLoader(Try.CheckedSupplier<T> delegate) {
            this.delegate = delegate;
        }

        @Override
        public T load(Boolean key) throws Exception {
            try {
                return this.delegate.get();
            }
            catch (Error | Exception e) {
                throw e;
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }

        @Override
        public ListenableFuture<T> reload(Boolean key, T oldValue) {
            return EXECUTOR.submit(() -> this.load(key));
        }
    }
}

