/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.styx.util;

import com.spotify.styx.state.Trigger;
import com.spotify.styx.state.TriggerVisitor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class TriggerUtil {
    public static final String NATURAL_TRIGGER_ID = "natural-trigger";

    private TriggerUtil() {
        throw new UnsupportedOperationException();
    }

    public static boolean isBackfill(Trigger trigger) {
        return trigger.accept(TriggerIsBackfillVisitor.INSTANCE);
    }

    public static String triggerType(Trigger trigger) {
        return trigger.accept(TriggerTypeVisitor.INSTANCE);
    }

    public static String triggerId(Trigger trigger) {
        return trigger.accept(TriggerIdVisitor.INSTANCE);
    }

    public static List<String> triggerTypesList() {
        return Arrays.stream(TriggerVisitor.class.getDeclaredMethods()).map(Method::getName).collect(Collectors.toList());
    }

    public static Trigger trigger(String type, String triggerId) {
        switch (type) {
            case "natural": {
                return Trigger.natural();
            }
            case "adhoc": {
                return Trigger.adhoc(triggerId);
            }
            case "backfill": {
                return Trigger.backfill(triggerId);
            }
            case "unknown": {
                return Trigger.unknown(triggerId);
            }
        }
        throw new IllegalArgumentException("Unknown trigger type: " + type);
    }

    private static enum TriggerIdVisitor implements TriggerVisitor<String>
    {
        INSTANCE;


        @Override
        public String natural() {
            return TriggerUtil.NATURAL_TRIGGER_ID;
        }

        @Override
        public String adhoc(String triggerId) {
            return triggerId;
        }

        @Override
        public String backfill(String triggerId) {
            return triggerId;
        }

        @Override
        public String unknown(String triggerId) {
            return triggerId;
        }
    }

    private static enum TriggerTypeVisitor implements TriggerVisitor<String>
    {
        INSTANCE;


        @Override
        public String natural() {
            return "natural";
        }

        @Override
        public String adhoc(String triggerId) {
            return "adhoc";
        }

        @Override
        public String backfill(String triggerId) {
            return "backfill";
        }

        @Override
        public String unknown(String triggerId) {
            return "unknown";
        }
    }

    private static enum TriggerIsBackfillVisitor implements TriggerVisitor<Boolean>
    {
        INSTANCE;


        @Override
        public Boolean natural() {
            return false;
        }

        @Override
        public Boolean adhoc(String triggerId) {
            return false;
        }

        @Override
        public Boolean backfill(String triggerId) {
            return true;
        }

        @Override
        public Boolean unknown(String triggerId) {
            return false;
        }
    }
}

