/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.logging.logback;

import ch.qos.logback.classic.PatternLayout;
import ch.qos.logback.classic.net.SyslogAppender;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.StackTraceElementProxy;
import ch.qos.logback.core.Layout;
import ch.qos.logback.core.net.SyslogAppenderBase;
import com.google.common.base.Charsets;
import com.google.common.base.Throwables;
import com.spotify.logging.logback.MillisecondPrecisionSyslogStartConverter;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.nio.charset.Charset;

public class MillisecondPrecisionSyslogAppender
extends SyslogAppender {
    private Charset charset = Charsets.UTF_8;
    PatternLayout stackTraceLayout = new PatternLayout();
    private OutputStream sos;

    @Override
    public void start() {
        super.start();
        this.sos = this.getSyslogOutputStream();
        this.setupStackTraceLayout();
    }

    String getPrefixPattern() {
        return "%syslogStart{" + this.getFacility() + "}%nopex{}";
    }

    @Override
    protected void append(ILoggingEvent eventObject) {
        if (!this.isStarted()) {
            return;
        }
        try {
            String msg = this.getLayout().doLayout(eventObject);
            if (msg == null) {
                return;
            }
            if (msg.length() > this.getMaxMessageSize()) {
                msg = msg.substring(0, this.getMaxMessageSize());
            }
            this.sos.write(msg.getBytes(this.charset));
            this.sos.flush();
            this.postProcess(eventObject, this.sos);
        }
        catch (IOException ioe) {
            this.addError("Failed to send diagram to " + this.getSyslogHost(), ioe);
        }
    }

    @Override
    protected void postProcess(Object eventObject, OutputStream sw) {
        if (this.isThrowableExcluded()) {
            return;
        }
        ILoggingEvent event = (ILoggingEvent)eventObject;
        IThrowableProxy tp = event.getThrowableProxy();
        if (tp == null) {
            return;
        }
        String stackTracePrefix = this.stackTraceLayout.doLayout(event);
        this.recursiveWrite(sw, stackTracePrefix, tp, 0, null);
    }

    private void recursiveWrite(OutputStream sw, String stackTracePrefix, IThrowableProxy tp, int indent, String firstLinePrefix) {
        IThrowableProxy cause;
        StackTraceElementProxy[] stepArray = tp.getStackTraceElementProxyArray();
        try {
            this.handleThrowableFirstLine(sw, tp, stackTracePrefix, indent, firstLinePrefix);
            for (StackTraceElementProxy step : stepArray) {
                StringBuilder sb = new StringBuilder();
                sb.append(stackTracePrefix);
                this.addIndent(sb, indent);
                sb.append(step);
                sw.write(sb.toString().getBytes());
                sw.flush();
            }
        }
        catch (IOException e) {
            return;
        }
        IThrowableProxy[] suppressed = tp.getSuppressed();
        if (suppressed != null) {
            for (IThrowableProxy current : suppressed) {
                this.recursiveWrite(sw, stackTracePrefix, current, indent + 1, "Suppressed: ");
            }
        }
        if ((cause = tp.getCause()) != null) {
            this.recursiveWrite(sw, stackTracePrefix, cause, indent, "Caused by: ");
        }
    }

    private void addIndent(StringBuilder sb, int indent) {
        for (int i = 0; i < indent; ++i) {
            sb.append('\t');
        }
    }

    private void handleThrowableFirstLine(OutputStream sw, IThrowableProxy tp, String stackTracePrefix, int indent, String prefix) throws IOException {
        StringBuilder sb = new StringBuilder().append(stackTracePrefix);
        this.addIndent(sb, indent);
        if (prefix != null) {
            sb.append(prefix);
        }
        sb.append(tp.getClassName()).append(": ").append(tp.getMessage());
        sw.write(sb.toString().getBytes());
        sw.flush();
    }

    @Override
    public Layout<ILoggingEvent> buildLayout() {
        PatternLayout layout = new PatternLayout();
        layout.getInstanceConverterMap().put("syslogStart", MillisecondPrecisionSyslogStartConverter.class.getName());
        if (this.suffixPattern == null) {
            this.suffixPattern = "[%thread] %logger %msg";
        }
        layout.setPattern(this.getPrefixPattern() + this.suffixPattern);
        layout.setContext(this.getContext());
        layout.start();
        return layout;
    }

    private void setupStackTraceLayout() {
        this.stackTraceLayout.getInstanceConverterMap().put("syslogStart", MillisecondPrecisionSyslogStartConverter.class.getName());
        this.stackTraceLayout.setPattern(this.getPrefixPattern() + this.getStackTracePattern());
        this.stackTraceLayout.setContext(this.getContext());
        this.stackTraceLayout.start();
    }

    private OutputStream getSyslogOutputStream() {
        try {
            Field f = SyslogAppenderBase.class.getDeclaredField("sos");
            f.setAccessible(true);
            return (OutputStream)f.get(this);
        }
        catch (ReflectiveOperationException e) {
            throw Throwables.propagate(e);
        }
    }

    @Override
    public Charset getCharset() {
        return this.charset;
    }

    @Override
    public void setCharset(Charset charset) {
        this.charset = charset;
    }
}

