/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.styx.util;

import com.google.common.io.Closer;
import java.io.Closeable;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloserUtil {
    private static final Logger log = LoggerFactory.getLogger(CloserUtil.class);
    static final Duration DEFAULT_TIMEOUT = Duration.ofSeconds(30L);

    private CloserUtil() {
        throw new UnsupportedOperationException();
    }

    public static <T extends ExecutorService> T register(Closer closer, T executorService, String name) {
        return CloserUtil.register(closer, executorService, name, DEFAULT_TIMEOUT);
    }

    public static <T extends ExecutorService> T register(Closer closer, T executorService, String name, Duration timeout) {
        closer.register(CloserUtil.closeable(executorService, name, timeout));
        return executorService;
    }

    public static Closeable closeable(ExecutorService executor, String name) {
        return CloserUtil.closeable(executor, name, DEFAULT_TIMEOUT);
    }

    public static Closeable closeable(ExecutorService executor, String name, Duration timeout) {
        return () -> CloserUtil.close(executor, name, timeout);
    }

    private static void close(ExecutorService executor, String name, Duration timeout) {
        log.debug("Shutting down executor: {}", (Object)name);
        executor.shutdown();
        try {
            executor.awaitTermination(timeout.toNanos(), TimeUnit.NANOSECONDS);
        }
        catch (InterruptedException ignored) {
            log.warn("Interrupted");
            Thread.currentThread().interrupt();
        }
        List<Runnable> runnables = executor.shutdownNow();
        if (!runnables.isEmpty()) {
            log.warn("{} task(s) in {} did not execute", (Object)runnables.size(), (Object)name);
        }
    }
}

