/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.styx.util;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.function.Function;

public class TypeWrapperModule
extends SimpleModule {
    public TypeWrapperModule() {
        super("AdtModule");
    }

    @Override
    public void setupModule(Module.SetupContext context) {
        super.setupModule(context);
    }

    public <T, W> TypeWrapperModule setupWrapping(Class<T> valueClass, Class<W> wrapperClass, Function<T, W> wrapper, Function<W, T> unwrapper) {
        super.addSerializer(valueClass, new DelegatingSerializer<T>(valueClass, wrapper));
        super.addDeserializer(valueClass, new DelegatingDeserializer<T, W>(valueClass, wrapperClass, unwrapper));
        return this;
    }

    private static class DelegatingDeserializer<T, W>
    extends StdDeserializer<T> {
        private final Class<W> wrapperClass;
        private final Function<W, T> unwrapper;

        private DelegatingDeserializer(Class<T> valueClass, Class<W> wrapperClass, Function<W, T> unwrapper) {
            super(valueClass);
            this.wrapperClass = wrapperClass;
            this.unwrapper = unwrapper;
        }

        @Override
        public T deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            return this.unwrapper.apply(ctxt.readValue(p, this.wrapperClass));
        }
    }

    private static class DelegatingSerializer<T>
    extends StdSerializer<T> {
        private final Function<T, ?> wrapper;

        private DelegatingSerializer(Class<T> jsonClass, Function<T, ?> wrapper) {
            super(jsonClass);
            this.wrapper = wrapper;
        }

        @Override
        public void serialize(T value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeObject(this.wrapper.apply(value));
        }
    }
}

